/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta1;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta1";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient1 theTests = new dbMetaClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSupportsStoredProcedures() throws Exception {
        try {
            this.msg.setMsg("Calling supportsStoredProcedures on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsStoredProcedures();
            if (retValue) {
                this.msg.setMsg("SupportsStoredProcedures is supported");
            } else {
                this.msg.printTestError("SupportsStoredProcedures is not supported", "supportsStoredProcedures should always return true!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsStoredProcedures is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsStoredProcedures is Failed!");
        }
    }

    public void testAllProceduresAreCallable() throws Exception {
        try {
            this.msg.setMsg("Calling allProceduresAreCallable on DatabaseMetaData");
            boolean retValue = this.dbmd.allProceduresAreCallable();
            if (retValue) {
                this.msg.setMsg("allProceduresAreCallable method called by the current user");
            } else {
                this.msg.setMsg("allProceduresAreCallable method not called by the current user");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to allProceduresAreCallable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to allProceduresAreCallable is Failed!");
        }
    }

    public void testAllTablesAreSelectable() throws Exception {
        try {
            this.msg.setMsg("Calling allTablesAreSelectable on DatabaseMetaData");
            boolean retValue = this.dbmd.allTablesAreSelectable();
            if (retValue) {
                this.msg.setMsg("allTablesAreSelectable method SELECTed by the current user");
            } else {
                this.msg.setMsg("allTablesAreSelectable method not SELECTed by the current user");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to allTablesAreSelectable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to allTablesAreSelectable is Failed!");
        }
    }

    public void testGetURL() throws Exception {
        try {
            this.msg.setMsg("Calling getURL on DatabaseMetaData");
            String sRetValue = this.dbmd.getURL();
            this.logTrace("getURL returns null if it cannot be generated");
            if (sRetValue == null) {
                this.msg.setMsg("getURL method return a null value ");
            } else {
                this.msg.setMsg("getURL method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getURL is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getURL is Failed!");
        }
    }

    public void testGetUserName() throws Exception {
        try {
            this.msg.setMsg("Calling getUserName on DatabaseMetaData");
            String sRetValue = this.dbmd.getUserName();
            if (sRetValue == null) {
                this.msg.setMsg("getUserName method does not returns user name ");
            } else {
                this.msg.setMsg("getUserName method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getUserName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getUserName is Failed!");
        }
    }

    public void testIsReadOnly() throws Exception {
        try {
            this.msg.setMsg("Calling isReadOnly on DatabaseMetaData");
            boolean retValue = this.dbmd.isReadOnly();
            if (retValue) {
                this.msg.setMsg("IsReadOnly method is in read-only mode");
            } else {
                this.msg.setMsg("IsReadOnly method is not in read-only mode");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isReadOnly is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isReadOnly is Failed!");
        }
    }

    public void testNullsAreSortedHigh() throws Exception {
        try {
            this.msg.setMsg("Calling nullsAreSortedHigh on DatabaseMetaData");
            boolean retValue = this.dbmd.nullsAreSortedHigh();
            if (retValue) {
                this.msg.setMsg("nullsAreSortedHigh method returns NULL values sorted  high");
            } else {
                this.msg.setMsg("nullsAreSortedHigh method returns NULL values not sorted high");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to nullsAreSortedHigh is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to nullsAreSortedHigh is Failed!");
        }
    }

    public void testNullsAreSortedLow() throws Exception {
        try {
            this.msg.setMsg("Calling nullsAreSortedLow on DatabaseMetaData");
            boolean retValue = this.dbmd.nullsAreSortedLow();
            if (retValue) {
                this.msg.setMsg("nullsAreSortedLow method returns NULL values sorted low");
            } else {
                this.msg.setMsg("nullsAreSortedLow method returns NULL values not sorted low");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to nullsAreSortedLow is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to nullsAreSortedLow is Failed!");
        }
    }

    public void testNullsAreSortedAtStart() throws Exception {
        try {
            this.msg.setMsg("Calling nullsAreSortedAtStart on DatabaseMetaData");
            boolean retValue = this.dbmd.nullsAreSortedAtStart();
            if (retValue) {
                this.msg.setMsg("nullsAreSortedAtStart method returns NULL values sorted at the start");
            } else {
                this.msg.setMsg("nullsAreSortedAtStart method returns NULL values not sorted at the start");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to nullsAreSortedAtStart is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to nullsAreSortedAtStart is Failed!");
        }
    }

    public void testNullsAreSortedAtEnd() throws Exception {
        try {
            this.msg.setMsg("Calling NullsAreSortedAtEnd on DatabaseMetaData");
            boolean retValue = this.dbmd.nullsAreSortedAtEnd();
            if (retValue) {
                this.msg.setMsg("nullsAreSortedAtEnd method returns NULL values sorted at the end");
            } else {
                this.msg.setMsg("nullsAreSortedAtEnd method returns NULL values not sorted at the end");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to nullsAreSortedAtEnd is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to nullsAreSortedAtEnd is Failed!");
        }
    }

    public void testGetDatabaseProductName() throws Exception {
        try {
            this.msg.setMsg("Calling getDatabaseProductName on DatabaseMetaData");
            String sRetValue = this.dbmd.getDatabaseProductName();
            if (sRetValue == null) {
                this.msg.setMsg("getDatabaseProductName method does not returns database product name ");
            } else {
                this.msg.setMsg("getDatabaseProductName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDatabaseProductName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDatabaseProductName is Failed!");
        }
    }

    public void testGetDatabaseProductVersion() throws Exception {
        try {
            this.msg.setMsg("Calling getDatabaseProductVersion on DatabaseMetaData");
            String sRetValue = this.dbmd.getDatabaseProductVersion();
            if (sRetValue == null) {
                this.msg.setMsg("getDatabaseProductVersion  method does not returns a database product version ");
            } else {
                this.msg.setMsg("getDatabaseProductVersion method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDatabaseProductVersion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDatabaseProductVersion is Failed!");
        }
    }

    public void testGetDriverName() throws Exception {
        try {
            this.msg.setMsg("Calling getDriverName on DatabaseMetaData");
            String sRetValue = this.dbmd.getDriverName();
            if (sRetValue == null) {
                this.msg.setMsg("getDriverName method does not returns a JDBC Driver Name ");
            } else {
                this.msg.setMsg("getDriverName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDriverName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDriverName is Failed!");
        }
    }

    public void testGetDriverVersion() throws Exception {
        try {
            this.msg.setMsg("Calling getDriverVersion on DatabaseMetaData");
            String sRetValue = this.dbmd.getDriverVersion();
            if (sRetValue == null) {
                this.msg.setMsg("getDriverVersion method does not returns a Driver Version ");
            } else {
                this.msg.setMsg("getDriverVersion returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDriverVersion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDriverVersion is Failed!");
        }
    }

    public void testGetDriverMajorVersion() throws Exception {
        try {
            this.msg.setMsg("Calling getDriverMajorVersion on DatabaseMetaData");
            int drMajorVersion = this.dbmd.getDriverMajorVersion();
            if (drMajorVersion >= 0) {
                this.msg.setMsg("getDriverMajorVersion method returns: " + drMajorVersion);
            } else {
                this.msg.setMsg(" getDriverMajorVersion method returns a negative value");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDriverMajorVersion is Failed!");
        }
    }

    public void testGetDriverMinorVersion() throws Exception {
        try {
            this.msg.setMsg("Calling getDriverMinorVersion on DatabaseMetaData");
            int drMinorVersion = this.dbmd.getDriverMinorVersion();
            if (drMinorVersion >= 0) {
                this.msg.setMsg(" getDriverMinorVersion method returns: " + drMinorVersion);
            } else {
                this.msg.setMsg(" getDriverMinorVersion method returns a negative value: " + drMinorVersion);
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDriverMinorVersion Failed!");
        }
    }

    public void testUsesLocalFilePerTable() throws Exception {
        try {
            this.msg.setMsg("Calling usesLocalFilePerTable on DatabaseMetaData");
            boolean retValue = this.dbmd.usesLocalFilePerTable();
            if (retValue) {
                this.msg.setMsg("usesLocalFilePerTable method returns database uses a local file");
            } else {
                this.msg.setMsg("usesLocalFilePerTable method returns database not uses a local file");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to usesLocalFilePerTable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to usesLocalFilePerTable is Failed!");
        }
    }

    public void testSupportsMixedCaseIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling supportsMixedCaseIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsMixedCaseIdentifiers();
            if (retValue) {
                this.msg.setMsg("supportsMixedCaseIdentifiers method is supported");
            } else {
                this.msg.setMsg("supportsMixedCaseIdentifiers method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsMixedCaseIdentifiers is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsMixedCaseIdentifiers Failed!");
        }
    }

    public void testStoresUpperCaseIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling storesUpperCaseIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.storesUpperCaseIdentifiers();
            if (retValue) {
                this.msg.setMsg("storesUpperCaseIdentifiers method returns unquoted SQL identifiers stored as upper case");
            } else {
                this.msg.setMsg("storesUpperCaseIdentifiers method returns unquoted SQL identifiers not stored as upper case");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to storesUpperCaseIdentifiers is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to storesUpperCaseIdentifiers is Failed");
        }
    }

    public void testStoresLowerCaseIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling storesLowerCaseIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.storesLowerCaseIdentifiers();
            if (retValue) {
                this.msg.setMsg("storesLowerCaseIdentifiers method returns unquoted SQL identifiers stored as lower case");
            } else {
                this.msg.setMsg("storesLowerCaseIdentifiers returns unquoted SQL identifiers not stored as lower case");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to storesLowerCaseIdentifiers is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to storesLowerCaseIdentifiers is Failed");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

