/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.client;

import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.jstl.common.client.BaseUrlClient;
import com.sun.ts.tests.jstl.common.resources.Resources_en;
import com.sun.ts.tests.jstl.common.tags.TestTag;
import java.io.InputStream;
import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public class AbstractUrlClient
extends BaseUrlClient {
    private static final System.Logger logger = System.getLogger(AbstractUrlClient.class.getName());
    @ArquillianResource
    @OperateOnDeployment(value="_DEFAULT_")
    public URL url;
    protected InputStream goldenFileStream = null;
    protected static final String STANDARD_COMPAT = "standardCompat";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public InputStream getGoldenFileStream() {
        return this.goldenFileStream;
    }

    public void setGoldenFileStream(InputStream gfStream) {
        this.goldenFileStream = gfStream;
    }

    private void setGoldenFileStreamProperty(WebTestCase testCase, InputStream gfStream) {
        testCase.setGoldenFileStream(gfStream);
    }

    protected boolean isNullOrEmpty(String val) {
        return val == null || val.equals("");
    }

    protected static JavaArchive getCommonJarArchive() {
        String packagePathTags = TestTag.class.getPackageName().replace(".", "/");
        String packagePathResources = Resources_en.class.getPackageName().replace(".", "/");
        JavaArchive jstlTCKCommonJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jstltck-common.jar");
        jstlTCKCommonJar.addAsResource((Asset)new UrlAsset(TestTag.class.getClassLoader().getResource(packagePathTags + "/tlds/jstltck-util.tld")), "META-INF/jstltck-util.tld");
        jstlTCKCommonJar.addAsResource((Asset)new UrlAsset(TestTag.class.getClassLoader().getResource(packagePathTags + "/tlds/permitted.tld")), "META-INF/permitted.tld");
        jstlTCKCommonJar.addAsResource((Asset)new UrlAsset(TestTag.class.getClassLoader().getResource(packagePathTags + "/tlds/scrfree_nodecl.tld")), "META-INF/scrfree_nodecl.tld");
        jstlTCKCommonJar.addAsResource((Asset)new UrlAsset(TestTag.class.getClassLoader().getResource(packagePathTags + "/tlds/scrfree_noexpr.tld")), "META-INF/scrfree_noexpr.tld");
        jstlTCKCommonJar.addAsResource((Asset)new UrlAsset(TestTag.class.getClassLoader().getResource(packagePathTags + "/tlds/scrfree_nortexpr.tld")), "META-INF/scrfree_nortexpr.tld");
        jstlTCKCommonJar.addAsResource((Asset)new UrlAsset(TestTag.class.getClassLoader().getResource(packagePathTags + "/tlds/scrfree_noscr.tld")), "META-INF/scrfree_noscr.tld");
        jstlTCKCommonJar.addPackages(true, new String[]{"com.sun.ts.tests.jstl.common"});
        jstlTCKCommonJar.add((Asset)new UrlAsset(Resources_en.class.getClassLoader().getResource(packagePathResources + "/AlgoResources_en_IE_EURO.properties")), packagePathResources + "/AlgoResources_en_IE_EURO.properties");
        jstlTCKCommonJar.add((Asset)new UrlAsset(Resources_en.class.getClassLoader().getResource(packagePathResources + "/AlgoResources.properties")), packagePathResources + "/AlgoResources.properties");
        return jstlTCKCommonJar;
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.INFO, "setup method AbstractUrlClient");
        if (this.url == null) {
            throw new Exception("[AbstractUrlClient] The url was not injected");
        }
        String hostname = this.url.getHost();
        String portnum = Integer.toString(this.url.getPort());
        Assertions.assertFalse((boolean)this.isNullOrEmpty(hostname), (String)"[AbstractUrlClient] 'webServerHost' was not set in the properties.");
        this._hostname = hostname.trim();
        Assertions.assertFalse((boolean)this.isNullOrEmpty(portnum), (String)"[AbstractUrlClient] 'webServerPort' was not set in the properties.");
        this._port = Integer.parseInt(portnum.trim());
        logger.log(System.Logger.Level.INFO, "[AbstractUrlClient] Test setup OK");
    }

    @Override
    protected void setTestProperties(WebTestCase testCase) {
        this.setStandardProperties(TEST_PROPS.getProperty("standard"), testCase);
        this.setStandardCompatProperties(TEST_PROPS.getProperty(STANDARD_COMPAT), testCase);
        if (testCase.getRequest() == null) {
            String test = TEST_PROPS.getProperty("request");
            if (test.indexOf("HTTP/") < 0) {
                StringBuffer sb = new StringBuffer(25);
                sb.append("GET ").append(this._contextRoot);
                sb.append("/").append(test).append(" HTTP/1.1");
                HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
                testCase.setRequest(req);
            }
            this.setGoldenFileStreamProperty(testCase, this.goldenFileStream);
        }
        super.setTestProperties(testCase);
    }

    @Override
    public void setGoldenFileDir(String goldenDir) {
        this.GOLDENFILEDIR = goldenDir;
    }

    private void setStandardProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        this._testName = testValue;
        sb.append("GET ").append(this._contextRoot).append("/");
        sb.append(testValue).append(".jsp").append(" HTTP/1.1");
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
    }

    private void setStandardCompatProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        this._testName = testValue;
        sb.append("GET ").append(this._contextRoot).append("/");
        sb.append(testValue).append(".jsp").append(" HTTP/1.1");
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
    }

    public boolean isJavaVersion20OrGreater() {
        boolean isJavaVersion20OrGreater = false;
        String version = System.getProperty("java.version");
        int majorVersionDot = version.indexOf(".");
        if (Integer.parseInt(version = version.substring(0, majorVersionDot)) >= 20) {
            isJavaVersion20OrGreater = true;
        }
        return isJavaVersion20OrGreater;
    }
}

