/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.allowed;

import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.ejb30.common.allowed.AllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.CallbackAllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.Constants;
import com.sun.ts.tests.ejb30.common.allowed.SessionContextAllowedIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public abstract class ClientBase
extends EETest
implements Constants {
    private AllowedIF allowedBean;
    private CallbackAllowedIF callbackAllowedBean;
    private SessionContextAllowedIF sessionContextAllowedBean;
    private SessionContextAllowedIF injectionAllowedBean;
    protected Properties props;

    protected SessionContextAllowedIF lookupInjectionAllowedBean() throws NamingException {
        return (SessionContextAllowedIF)ServiceLocator.lookup("java:comp/env/ejb/injectionAllowedBean", new Context[0]);
    }

    protected AllowedIF lookupAllowedBean() throws NamingException {
        return (AllowedIF)ServiceLocator.lookup("java:comp/env/ejb/allowedBean", new Context[0]);
    }

    protected CallbackAllowedIF lookupCallbackAllowedBean() throws NamingException {
        return (CallbackAllowedIF)ServiceLocator.lookup("java:comp/env/ejb/callbackAllowedBean", new Context[0]);
    }

    protected SessionContextAllowedIF lookupSessionContextAllowedBean() throws NamingException {
        return (SessionContextAllowedIF)ServiceLocator.lookup("java:comp/env/ejb/sessionContextAllowedBean", new Context[0]);
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
    }

    public void cleanup() throws Exception {
    }

    protected void remove() {
        if (this.allowedBean != null) {
            try {
                this.allowedBean.remove();
                TLogger.log("allowedBean removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove allowedBean.");
            }
        }
        if (this.callbackAllowedBean != null) {
            try {
                this.callbackAllowedBean.remove();
                TLogger.log("callbackAllowedBean removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove callbackAllowedBean.");
            }
        }
        if (this.sessionContextAllowedBean != null) {
            try {
                this.sessionContextAllowedBean.remove();
                TLogger.log("sessionContextAllowedBean removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove sessionContextAllowedBean.");
            }
        }
    }

    public void checkResults(Properties results, Properties expected) throws Exception {
        if (results == null) {
            throw new Exception("results are null");
        }
        if (expected == null) {
            throw new Exception("expected results are null");
        }
        int resultsCount = results.size();
        int expectedCount = expected.size();
        TLogger.log("Expected results count: " + expectedCount);
        expected.list(System.out);
        TLogger.log(TLogger.NL);
        TLogger.log("Actual results count: " + resultsCount);
        results.list(System.out);
        if (expectedCount != resultsCount) {
            TLogger.log(TLogger.NL + "Continue to compare each element of expected and actual results.");
        }
        Enumeration<Object> keys = expected.keys();
        Object reason = "";
        while (keys.hasMoreElements()) {
            String actual;
            String key = (String)keys.nextElement();
            String val = expected.getProperty(key);
            if (val.equals(actual = results.getProperty(key))) continue;
            reason = (String)reason + TLogger.NL + "Expected " + key + "=" + val + ", but actual " + actual;
        }
        if (((String)reason).length() > 0) {
            TLogger.log(TLogger.NL + (String)reason);
            throw new Exception("failed in result check");
        }
    }

    public void injectionMethod() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("EJBContext_lookup", "allowed");
        try {
            this.injectionAllowedBean = this.lookupInjectionAllowedBean();
            results = this.injectionAllowedBean.getResults();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        this.checkResults(results, expected);
    }
}

