/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.resourcedefs.annotations;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.jms.ee20.resourcedefs.annotations.EjbClientIF;
import jakarta.ejb.EJB;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSConnectionFactoryDefinitions;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.JMSDestinationDefinitions;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

@JMSDestinationDefinitions(value={@JMSDestinationDefinition(description="Define Queue AppClientMyTestQueue", interfaceName="jakarta.jms.Queue", name="java:global/env/AppClientMyTestQueue", destinationName="AppClientMyTestQueue"), @JMSDestinationDefinition(description="Define Topic AppClientMyTestTopic", interfaceName="jakarta.jms.Topic", name="java:app/env/AppClientMyTestTopic", destinationName="AppClientMyTestTopic")})
@JMSConnectionFactoryDefinitions(value={@JMSConnectionFactoryDefinition(description="Define ConnectionFactory AppClientMyTestConnectionFactory", interfaceName="jakarta.jms.ConnectionFactory", name="java:global/AppClientMyTestConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define QueueConnectionFactory AppClientMyTestQueueConnectionFactory", interfaceName="jakarta.jms.QueueConnectionFactory", name="java:app/AppClientMyTestQueueConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define TopicConnectionFactory AppClientMyTestTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:module/AppClientMyTestTopicConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define Durable TopicConnectionFactory AppClientMyTestDurableTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:comp/env/jms/AppClientMyTestDurableTopicConnectionFactory", user="j2ee", password="j2ee", clientId="MyClientID", properties={"Property1=10", "Property2=20"}, transactional=false, maxPoolSize=30, minPoolSize=20)})
public class Client
extends EETest {
    private static final long serialVersionUID = 1L;
    protected transient ConnectionFactory dcf = null;
    protected transient ConnectionFactory cf = null;
    protected transient ConnectionFactory cfra = null;
    protected transient QueueConnectionFactory qcf = null;
    protected transient TopicConnectionFactory tcf = null;
    protected transient TopicConnectionFactory dtcf = null;
    protected transient Topic topic = null;
    protected transient Topic topica = null;
    protected transient Queue queue = null;
    protected transient JMSContext context = null;
    protected transient JMSConsumer consumerQ = null;
    protected transient JMSProducer producerQ = null;
    protected transient JMSConsumer consumerT = null;
    protected transient JMSProducer producerT = null;
    protected boolean queueTest = false;
    protected Properties props = null;
    protected long timeout;
    protected String user;
    protected String password;
    protected String mode;
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private transient URLConnection urlConn = null;
    private String SERVLET = "/resourcedefs_annotations_web/ServletTest";
    private String JSP = "/resourcedefs_annotations_web/JspClient.jsp";
    @EJB(name="ejb/JMSResourceDefsEjbClientBean")
    static EjbClientIF ejbclient;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.hostname = p.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' in ts.jte must not be null");
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in ts.jte must be a number");
            }
            if (ejbclient == null) {
                throw new Exception("setup failed: ejbclient injection failure");
            }
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"cleanup ok");
    }

    private void doLookupJMSObjects() throws Exception {
        try {
            TestUtil.logMsg((String)"Lookup JMS factories defined in @JMSConnectionFactoryDefinitions");
            TestUtil.logMsg((String)"Lookup JMS destinations defined in @JMSDestinationDefinitions");
            TSNamingContext namingctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup java:comp/DefaultJMSConnectionFactory");
            this.dcf = (ConnectionFactory)namingctx.lookup("java:comp/DefaultJMSConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:global/AppClientMyTestConnectionFactory");
            this.cf = (ConnectionFactory)namingctx.lookup("java:global/AppClientMyTestConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:app/AppClientMyTestQueueConnectionFactory");
            this.qcf = (QueueConnectionFactory)namingctx.lookup("java:app/AppClientMyTestQueueConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:module/AppClientMyTestTopicConnectionFactory");
            this.tcf = (TopicConnectionFactory)namingctx.lookup("java:module/AppClientMyTestTopicConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:comp/env/jms/AppClientMyTestDurableTopicConnectionFactory");
            this.dtcf = (TopicConnectionFactory)namingctx.lookup("java:comp/env/jms/AppClientMyTestDurableTopicConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:global/env/AppClientMyTestQueue");
            this.queue = (Queue)namingctx.lookup("java:global/env/AppClientMyTestQueue");
            TestUtil.logMsg((String)"Lookup java:app/env/AppClientMyTestTopic");
            this.topic = (Topic)namingctx.lookup("java:app/env/AppClientMyTestTopic");
            TestUtil.logMsg((String)"Create JMSContext, JMSProducer's and JMSConsumer's");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producerQ = this.context.createProducer();
            this.consumerQ = this.context.createConsumer((Destination)this.queue);
            this.producerT = this.context.createProducer();
            this.consumerT = this.context.createConsumer((Destination)this.topic);
        }
        catch (Exception e) {
            throw new Exception("doLookupJMSObjects failed:", e);
        }
    }

    private void doCleanup() throws Exception {
        try {
            if (this.queueTest && this.consumerQ != null) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                Message rmsg = this.consumerQ.receive(this.timeout);
                while (rmsg != null) {
                    rmsg = this.consumerQ.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = this.consumerQ.receiveNoWait();
                }
                this.consumerQ.close();
            }
            if (this.consumerT != null) {
                this.consumerT.close();
            }
            TestUtil.logMsg((String)"Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("doCleanup failed!", e);
        }
    }

    public void sendAndRecvQueueTestFromAppClient() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.doLookupJMSObjects();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvQueueTestFromAppClient");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerQ.send((Destination)this.queue, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerQ.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("sendAndRecvQueueTestFromAppClient", e);
        }
        finally {
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                throw new Exception("doCleanup failed: ", e);
            }
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromAppClient failed");
        }
    }

    public void sendAndRecvTopicTestFromAppClient() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.doLookupJMSObjects();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTopicTestFromAppClient");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerT.send((Destination)this.topic, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerT.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("sendAndRecvTopicTestFromAppClient", e);
        }
        finally {
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                throw new Exception("doCleanup failed: ", e);
            }
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromAppClient failed");
        }
    }

    public void sendAndRecvQueueTestFromServletClient() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-------------------------------------");
            TestUtil.logMsg((String)"sendAndRecvQueueTestFromServletClient");
            TestUtil.logMsg((String)"-------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "sendAndRecvQueueTestFromServletClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Servlet");
                TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"JMSConnectionFactoryDefinitions test passed from Servlet");
                TestUtil.logMsg((String)"JMSDestinationDefinitions test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Servlet");
            TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromServletClient failed");
        }
    }

    public void sendAndRecvTopicTestFromServletClient() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-------------------------------------");
            TestUtil.logMsg((String)"sendAndRecvTopicTestFromServletClient");
            TestUtil.logMsg((String)"-------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "sendAndRecvTopicTestFromServletClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Servlet");
                TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"JMSConnectionFactoryDefinitions test passed from Servlet");
                TestUtil.logMsg((String)"JMSDestinationDefinitions test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Servlet");
            TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromServletClient failed");
        }
    }

    public void sendAndRecvQueueTestFromJspClient() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"---------------------------------");
            TestUtil.logMsg((String)"sendAndRecvQueueTestFromJspClient");
            TestUtil.logMsg((String)"---------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.JSP);
            TestUtil.logMsg((String)("Jsp URL: " + this.url));
            this.props.setProperty("TEST", "sendAndRecvQueueTestFromJspClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Jsp");
                TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Jsp");
            } else {
                TestUtil.logMsg((String)"JMSConnectionFactoryDefinitions test passed from Jsp");
                TestUtil.logMsg((String)"JMSDestinationDefinitions test passed from Jsp");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Jsp");
            TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Jsp");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromJspClient failed");
        }
    }

    public void sendAndRecvTopicTestFromJspClient() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"---------------------------------");
            TestUtil.logMsg((String)"sendAndRecvTopicTestFromJspClient");
            TestUtil.logMsg((String)"---------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.JSP);
            TestUtil.logMsg((String)("Jsp URL: " + this.url));
            this.props.setProperty("TEST", "sendAndRecvTopicTestFromJspClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Jsp");
                TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Jsp");
            } else {
                TestUtil.logMsg((String)"JMSConnectionFactoryDefinitions test passed from Jsp");
                TestUtil.logMsg((String)"JMSDestinationDefinitions test passed from Jsp");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Jsp");
            TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Jsp");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromJspClient failed");
        }
    }

    public void sendAndRecvQueueTestFromEjbClient() throws Exception {
        boolean pass = true;
        try {
            ejbclient.init(this.props);
            TestUtil.logMsg((String)"---------------------------------");
            TestUtil.logMsg((String)"sendAndRecvQueueTestFromEjbClient");
            TestUtil.logMsg((String)"---------------------------------");
            boolean passEjb = ejbclient.echo("sendAndRecvQueueTestFromEjbClient");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Ejb");
                TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"JMSConnectionFactoryDefinitions test passed from Ejb");
                TestUtil.logMsg((String)"JMSDestinationDefinitions test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Ejb");
            TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromEjbClient failed");
        }
    }

    public void sendAndRecvTopicTestFromEjbClient() throws Exception {
        boolean pass = true;
        try {
            ejbclient.init(this.props);
            TestUtil.logMsg((String)"---------------------------------");
            TestUtil.logMsg((String)"sendAndRecvTopicTestFromEjbClient");
            TestUtil.logMsg((String)"---------------------------------");
            boolean passEjb = ejbclient.echo("sendAndRecvTopicTestFromEjbClient");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Ejb");
                TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"JMSConnectionFactoryDefinitions test passed from Ejb");
                TestUtil.logMsg((String)"JMSDestinationDefinitions test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"JMSConnectionFactoryDefinitions test failed from Ejb");
            TestUtil.logErr((String)"JMSDestinationDefinitions test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromEjbClient failed");
        }
    }

    public void checkClientIDOnDurableConnFactoryTest() throws Exception {
        boolean pass = true;
        JMSContext context = null;
        try {
            this.queueTest = false;
            this.doLookupJMSObjects();
            TestUtil.logMsg((String)"==============================================================");
            TestUtil.logMsg((String)"Verify admin configured client id is MyClientID from AppClient");
            TestUtil.logMsg((String)"==============================================================");
            TestUtil.logMsg((String)"Create JMSContext from durable topic connection factory");
            TestUtil.logMsg((String)"Check the client id which is configured as MyClientID in the JMSConnectionFactoryDefinition annotation");
            context = this.dtcf.createContext(this.user, this.password, 1);
            String clientid = context.getClientID();
            if (clientid == null) {
                TestUtil.logErr((String)"Client ID value is null (expected MyClientID)");
                pass = false;
            } else if (clientid.equals("MyClientID")) {
                TestUtil.logMsg((String)"Client ID value is correct (MyClientID)");
            } else {
                TestUtil.logErr((String)("Client ID value is incorrect (expected MyClientID, got " + clientid + ")"));
                pass = false;
            }
            context.close();
            context = null;
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error in cleanup");
            }
            TestUtil.logMsg((String)"==================================================================");
            TestUtil.logMsg((String)"Verify admin configured client id is MyClientID from ServletClient");
            TestUtil.logMsg((String)"==================================================================");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "checkClientIDTestFromServletClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"Check ClientID test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"Check ClientID test passed from Servlet");
            }
            TestUtil.logMsg((String)"==============================================================");
            TestUtil.logMsg((String)"Verify admin configured client id is MyClientID from JspClient");
            TestUtil.logMsg((String)"==============================================================");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.JSP);
            TestUtil.logMsg((String)("Jsp URL: " + this.url));
            this.props.setProperty("TEST", "checkClientIDTestFromJspClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"Check ClientID test failed from Jsp");
            } else {
                TestUtil.logMsg((String)"Check ClientID test passed from Jsp");
            }
            TestUtil.logMsg((String)"==============================================================");
            TestUtil.logMsg((String)"Verify admin configured client id is MyClientID from EjbClient");
            TestUtil.logMsg((String)"==============================================================");
            boolean passEjb = ejbclient.echo("checkClientIDTestFromEjbClient");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"Check ClientID test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"Check ClientID test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("checkClientIDOnDurableConnFactoryTest", e);
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
                this.doCleanup();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Error cleanup " + e));
            }
        }
        if (!pass) {
            throw new Exception("checkClientIDOnDurableConnFactoryTest failed");
        }
    }
}

