/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.resourceDefs.ejb;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.connector.resourceDefs.ejb.ITestStatelessEjb;
import jakarta.annotation.security.DeclareRoles;
import jakarta.ejb.EJB;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@DeclareRoles(value={"Administrator", "Manager", "Employee"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"Administrator"}), httpMethodConstraints={@HttpMethodConstraint(value="GET", rolesAllowed={"Administrator"}), @HttpMethodConstraint(value="POST", rolesAllowed={"Administrator"})})
@WebServlet(name="CRDTestServlet", urlPatterns={"/CRDTestServlet"})
public class CRDTestServlet
extends HttpServlet {
    @EJB
    private ITestStatelessEjb testStatelessEjb;
    private String servletAppContext = null;
    private String testMethod = null;
    private String RARJndiScope = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in CRDTestServlet.doGet()");
        this.getPropsAndParams(request, response);
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in CRDTestServlet.doPost()");
        this.getPropsAndParams(request, response);
        this.doTests(request, response);
    }

    private void doTests(HttpServletRequest request, HttpServletResponse response) {
        this.debug("in CRDTestServlet.doTests()");
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (Exception ex) {
            this.debug("got exception in CRDTestServlet");
            ex.printStackTrace();
        }
        this.getPropsAndParams(request, response);
        if (this.testMethod.equals("ValidateGlobalResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateGlobalResourceDef");
            this.validateGlobalResourceDef(request, response);
        } else if (this.testMethod.equals("ValidateAppResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateAppResourceDef");
            this.validateAppResourceDef(request, response);
        } else if (this.testMethod.equals("ValidateCompResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateCompResourceDef");
            this.validateCompResourceDef(request, response);
        } else if (this.testMethod.equals("ValidateModuleResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateModuleResourceDef");
            this.validateModuleResourceDef(request, response);
        }
    }

    private void getPropsAndParams(HttpServletRequest req, HttpServletResponse response) {
        this.testMethod = req.getParameter("method.under.test");
        this.RARJndiScope = req.getParameter("rar.jndi.scope");
        this.debug("CRDTestServlet.getPropsAndParams():  testMethod = " + this.testMethod);
        this.debug("CRDTestServlet.getPropsAndParams():  RARJndiScope = " + this.RARJndiScope);
    }

    public void validateGlobalResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            System.out.println("TestServlet->validateGlobalResourceDef()  calling testStatefullEjb.validateGlobalResourceDef()");
            if (this.testStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testStatelessEjb == null");
            }
            if (bval = this.testStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateGlobalResourceDef passed.");
            } else {
                this.send_output(out, "FAILURE:  validateGlobalResourceDef had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->validateGlobalResourceDef() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateGlobalResourceDef had unexpected exception.");
        }
    }

    public void validateAppResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            if (this.testStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testStatelessEjb == null");
            }
            if (bval = this.testStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateAppResourceDef passed.");
            } else {
                this.send_output(out, "FAILURE:  validateAppResourceDef had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->validateAppResourceDef() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateAppResourceDef had unexpected exception.");
        }
    }

    public void validateCompResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            if (this.testStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testStatelessEjb == null");
            }
            if (bval = this.testStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateCompResourceDef passed.");
            } else {
                this.send_output(out, "FAILURE:  validateCompResourceDef had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->validateCompResourceDef() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateCompResourceDef had unexpected exception.");
        }
    }

    public void validateModuleResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            if (this.testStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testStatelessEjb == null");
            }
            if (bval = this.testStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateModuleResourceDef passed.");
            } else {
                this.send_output(out, "FAILURE:  validateModuleResourceDef had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->validateModuleResourceDef() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateModuleResourceDef had unexpected exception.");
        }
    }

    public void send_output(PrintWriter out, String str) {
        if (out != null) {
            out.println(str);
            out.flush();
            this.debug(str);
        } else {
            this.print_err("ERROR, Null PrintWriter:  can not properly send back message: " + str);
        }
    }

    public void print_err(String str) {
        System.err.println(str);
        this.debug(str);
    }

    public void debug(String str) {
        TestUtil.logMsg((String)str);
        System.out.println(str);
    }
}

