/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class BindResult
extends LDAPResult {
    private static final byte TYPE_SERVER_SASL_CREDENTIALS = -121;
    private static final long serialVersionUID = 2211625049303605730L;
    private final ASN1OctetString serverSASLCredentials;

    public BindResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Control[] responseControls) {
        this(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls, null);
    }

    public BindResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Control[] responseControls, ASN1OctetString serverSASLCredentials) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
        this.serverSASLCredentials = serverSASLCredentials;
    }

    public BindResult(LDAPResult ldapResult) {
        super(ldapResult);
        this.serverSASLCredentials = null;
    }

    public BindResult(LDAPException exception) {
        super(exception.toLDAPResult());
        this.serverSASLCredentials = null;
    }

    protected BindResult(BindResult bindResult) {
        super(bindResult);
        this.serverSASLCredentials = bindResult.serverSASLCredentials;
    }

    static BindResult readBindResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        try {
            String diagnosticMessage;
            ASN1StreamReaderSequence protocolOpSequence = reader.beginSequence();
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readString();
            if (matchedDN.length() == 0) {
                matchedDN = null;
            }
            if ((diagnosticMessage = reader.readString()).length() == 0) {
                diagnosticMessage = null;
            }
            String[] referralURLs = null;
            ASN1OctetString serverSASLCredentials = null;
            block7: while (protocolOpSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                switch (type) {
                    case -93: {
                        ArrayList<String> refList = new ArrayList<String>(1);
                        ASN1StreamReaderSequence refSequence = reader.beginSequence();
                        while (refSequence.hasMoreElements()) {
                            refList.add(reader.readString());
                        }
                        referralURLs = new String[refList.size()];
                        refList.toArray(referralURLs);
                        continue block7;
                    }
                    case -121: {
                        serverSASLCredentials = new ASN1OctetString(type, reader.readBytes());
                        continue block7;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_BIND_RESULT_INVALID_ELEMENT.get(StaticUtils.toHex(type)));
            }
            Control[] controls = NO_CONTROLS;
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(1);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                controls = new Control[controlList.size()];
                controlList.toArray(controls);
            }
            return new BindResult(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, controls, serverSASLCredentials);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_BIND_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public ASN1OctetString getServerSASLCredentials() {
        return this.serverSASLCredentials;
    }

    @Override
    public void toString(StringBuilder buffer) {
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("BindResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        buffer.append(", hasServerSASLCredentials=");
        buffer.append(this.serverSASLCredentials != null);
        Control[] responseControls = this.getResponseControls();
        if (responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

