/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.Setup;
import com.sun.tdk.signaturetest.SignatureTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.core.context.TestOptions;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SetupAndTest
extends Result {
    public static final String REFERENCE_OPTION = "-Reference";
    public static final String TEST_OPTION = "-Test";
    private final List<String> setupOptions = new ArrayList<String>();
    private final List<String> testOptions = new ArrayList<String>();

    public static void main(String[] args) {
        SetupAndTest t = new SetupAndTest();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    public boolean run(String[] args, PrintWriter log, PrintWriter ref) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        TestOptions to = AppContext.getContext().getBean(TestOptions.class);
        if (Option.HELP.accept(args[0])) {
            SetupAndTest.usage();
            this.notrun();
            return true;
        }
        this.addFlag(this.setupOptions, Option.STATIC.getKey());
        this.addFlag(this.testOptions, Option.STATIC.getKey());
        String optionsDecoder = "decodeOptions";
        parser.addOption(REFERENCE_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(TEST_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Out", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-CheckValue", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-NoCheckValue", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Mode", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOptions(bo.getOptions(), "decodeOptions");
        parser.addOptions(to.getOptions(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            if (args.length > 0 && Option.VERSION.accept(args[0])) {
                System.err.println(Version.getVersionInfo());
                return this.passed();
            }
            SetupAndTest.usage();
            log.println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (!parser.isOptionSpecified(Option.FILE_NAME.getKey())) {
            String tmpsigfile = null;
            try {
                File f = File.createTempFile("tmpsigfile", ".sig");
                f.deleteOnExit();
                tmpsigfile = f.getPath();
                this.addOption(this.setupOptions, Option.FILE_NAME.getKey(), tmpsigfile);
                this.addOption(this.testOptions, Option.FILE_NAME.getKey(), tmpsigfile);
            }
            catch (IOException ioe) {
                return this.failed(i18n.getString("SetupAndTest.error.message.tempfile"));
            }
        }
        log.println(i18n.getString("SetupAndTest.message.invoke.setup"));
        Setup setup = new Setup();
        setup.run(this.setupOptions.toArray(new String[0]), log, ref);
        if (setup.isPassed()) {
            log.println(i18n.getString("SetupAndTest.message.invoke.sigtest"));
            SignatureTest sigtest = new SignatureTest();
            sigtest.run(this.testOptions.toArray(new String[0]), log, ref);
            return sigtest.exit();
        }
        return setup.exit();
    }

    private void addOption(List<String> options, String optionName, String optionValue) {
        options.add(optionName);
        options.add(optionValue);
    }

    private void addFlag(List<String> options, String flag) {
        options.add(flag);
    }

    private void addOption(List<String> options, String optionName, String[] optionValues) {
        options.add(optionName);
        options.addAll(Arrays.asList(optionValues));
    }

    public void decodeOptions(String optionName, String[] args) {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        bo.readOptions(optionName, args);
        TestOptions to = AppContext.getContext().getBean(TestOptions.class);
        to.readOptions(optionName, args);
        if (Option.HELP.accept(optionName)) {
            SetupAndTest.usage();
        } else if (optionName.equalsIgnoreCase(REFERENCE_OPTION)) {
            this.addOption(this.setupOptions, Option.CLASSPATH.getKey(), args[0]);
        } else if (optionName.equalsIgnoreCase(TEST_OPTION)) {
            this.addOption(this.testOptions, Option.CLASSPATH.getKey(), args[0]);
        } else if (optionName.equalsIgnoreCase(Option.FILE_NAME.getKey()) || optionName.equalsIgnoreCase(Option.PACKAGE.getKey()) || optionName.equalsIgnoreCase(Option.PURE_PACKAGE.getKey()) || optionName.equalsIgnoreCase(Option.EXCLUDE.getKey()) || optionName.equalsIgnoreCase("-ApiVersion") || optionName.equalsIgnoreCase("-ClassCacheSize") || optionName.equalsIgnoreCase(Option.API_INCLUDE.getKey()) || optionName.equalsIgnoreCase(Option.API_EXCLUDE.getKey())) {
            this.addOption(this.setupOptions, optionName, args[0]);
            this.addOption(this.testOptions, optionName, args[0]);
        } else if (optionName.equalsIgnoreCase("-Verbose")) {
            this.addOption(this.setupOptions, optionName, args);
            this.addOption(this.testOptions, optionName, args);
        } else if (optionName.equalsIgnoreCase("-Out")) {
            this.addOption(this.testOptions, optionName, args[0]);
        } else if (optionName.equalsIgnoreCase("-Mode")) {
            this.addOption(this.testOptions, optionName, args[0]);
        } else if (optionName.equalsIgnoreCase(Option.FORMATPLAIN.getKey()) || optionName.equalsIgnoreCase(Option.FORMATHUMAN.getKey()) || optionName.equalsIgnoreCase(Option.FORMATHUMAN.getAlias()) || optionName.equalsIgnoreCase(Option.BACKWARD.getKey()) || optionName.equalsIgnoreCase(Option.BACKWARD.getAlias()) || optionName.equalsIgnoreCase("-CheckValue")) {
            this.addFlag(this.testOptions, optionName);
        }
    }

    public static void usage() {
        String nl = System.getProperty("line.separator");
        String sb = i18n.getString("SetupAndTest.usage.version", "4.1") + nl + i18n.getString("SetupAndTest.usage.start") + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("SetupAndTest.usage.reference", REFERENCE_OPTION) + nl + i18n.getString("SetupAndTest.usage.test", TEST_OPTION) + nl + i18n.getString("SetupAndTest.usage.package", Option.PACKAGE) + nl + i18n.getString("SetupAndTest.usage.out", "-Out") + nl + i18n.getString("SignatureTest.usage.backward", new Object[]{Option.BACKWARD.getKey(), Option.BACKWARD.getAlias()}) + nl + i18n.getString("SignatureTest.usage.human", new Object[]{Option.FORMATHUMAN.getKey(), Option.FORMATHUMAN.getAlias()}) + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("SetupAndTest.usage.filename", Option.FILE_NAME) + nl + i18n.getString("SetupAndTest.usage.packagewithoutsubpackages", Option.PURE_PACKAGE) + nl + i18n.getString("SetupAndTest.usage.exclude", Option.EXCLUDE) + nl + i18n.getString("SetupAndTest.usage.verbose", new Object[]{"-Verbose", "nowarn"}) + nl + i18n.getString("SetupAndTest.usage.checkvalue", "-CheckValue") + nl + i18n.getString("SignatureTest.usage.mode", "-Mode") + nl + i18n.getString("SetupAndTest.usage.formatplain", Option.FORMATPLAIN) + nl + i18n.getString("SetupAndTest.usage.classcachesize", new Object[]{"-ClassCacheSize", 1024}) + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("SetupAndTest.helpusage.version", Option.VERSION) + nl + i18n.getString("SetupAndTest.usage.help", Option.HELP) + nl + i18n.getString("Sigtest.usage.delimiter");
        System.err.println(sb);
    }
}

