/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.configurable;

import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Assertable;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.FeatureReturningFalse;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Registrar;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.SingleCheckAssertable;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -6880902064949040518L;
    private int registeredClassesCnt = -1;
    private int registeredInstancesCnt = -1;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void registerFeatureClassReturningFalseTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(configurable);
            }

            void assertSizeAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                int cnt = config.getConfiguration().getClasses().size();
                JAXRSCommonClient.assertEqualsInt(cnt, 1 + JAXRSClientIT.this.registeredClassesCnt, "unexpected number of registered classes found:", cnt, this.getLocation());
                JAXRSCommonClient.logMsg("Found", cnt, "features");
            }
        };
        Object[] classes = new Class[]{FeatureReturningFalse.class, FeatureReturningFalse.class};
        this.checkConfig(assertable, classes);
    }

    @Test
    public void registerFeatureClassReturningFalseWithPriorityTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(configurable);
            }

            void assertSizeAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                int cnt = config.getConfiguration().getClasses().size();
                JAXRSCommonClient.assertEqualsInt(cnt, 1 + JAXRSClientIT.this.registeredClassesCnt, "unexpected number of registered classes found:", cnt, this.getLocation());
                JAXRSCommonClient.logMsg("Found", cnt, "features");
            }
        };
        Registrar registrar = new Registrar(){
            int priority = 0;

            @Override
            public void register(Configurable<?> config, Object registerable) {
                config.register((Class)registerable, ++this.priority);
            }
        };
        Object[] classes = new Class[]{FeatureReturningFalse.class, FeatureReturningFalse.class};
        this.checkConfig(registrar, assertable, classes);
    }

    @Test
    public void registerFeatureInstanceReturningFalseTest() throws JAXRSCommonClient.Fault {
        FeatureReturningFalse feature = new FeatureReturningFalse();
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(configurable);
            }

            void assertSizeAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                int cnt = config.getConfiguration().getInstances().size();
                JAXRSCommonClient.assertEqualsInt(cnt, 1 + JAXRSClientIT.this.registeredInstancesCnt, "unexpected number of registered instances found:", cnt, this.getLocation());
                JAXRSCommonClient.logMsg("Found", cnt, "features");
            }
        };
        Object[] features = new Object[]{feature, feature};
        this.checkConfig(assertable, features);
    }

    @Test
    public void registerClassContractsTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(configurable);
            }

            void assertSizeAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                int cnt = config.getConfiguration().getClasses().size();
                JAXRSCommonClient.assertEqualsInt(cnt, 1 + JAXRSClientIT.this.registeredClassesCnt, "unexpected number of registered classes found:", cnt, this.getLocation());
                JAXRSCommonClient.logMsg("Found", cnt, "features");
            }
        };
        Registrar registrar = new Registrar(){
            int priority = 0;

            @Override
            public void register(Configurable<?> config, Object registerable) {
                config.register((Class)registerable, ++this.priority);
            }
        };
        Object[] classes = new Class[]{FeatureReturningFalse.class, FeatureReturningFalse.class};
        this.checkConfig(registrar, assertable, classes);
    }

    protected void checkConfig(Assertable assertable, Object[] registerables) throws JAXRSCommonClient.Fault {
        this.checkConfig(new Registrar(), assertable, registerables);
    }

    protected void checkConfig(Registrar registrar, Assertable assertable, Object[] registerables) throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        Configuration config = client.getConfiguration();
        this.registeredClassesCnt = config.getClasses().size();
        this.registeredInstancesCnt = config.getInstances().size();
        JAXRSClientIT.logMsg("Already registered", this.registeredClassesCnt, "classes");
        JAXRSClientIT.logMsg("Already registered", this.registeredInstancesCnt, "instances");
        this.register(registrar, (Configurable<?>)client, registerables[0]);
        assertable.check1OnClient(client);
        assertable.incrementLocation();
        WebTarget target = client.target("http://tck.cts:888");
        this.register(registrar, (Configurable<?>)target, registerables[1]);
        assertable.check2OnTarget(target);
        assertable.incrementLocation();
    }

    protected void register(Registrar registrar, Configurable<?> config, Object registerable) {
        registrar.register(config, registerable);
    }
}

