/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.contextprovider;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.ContextResolver;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@Timeout(value=1L, unit=TimeUnit.HOURS)
@ExtendWith(value={ArquillianExtension.class})
public final class JsonbContextProviderIT {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_contextprovider_jsonb_web.war");
        archive.addClasses(new Class[]{JsonbContextProviderIT.class});
        return archive;
    }

    @Test
    public final void shouldUseApplicationProvidedJsonbInstance() throws URISyntaxException {
        try (Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new CustomJsonbProvider(RuntimeType.CLIENT))).build();){
            String origin = String.format("Origin(%d)", JsonbContextProviderIT.mockInt());
            POJO requestPojo = new POJO();
            requestPojo.setSeenBy(origin);
            URI effectiveUri = UriBuilder.fromUri((URI)this.baseUrl.toURI()).path("echo").build(new Object[0]);
            POJO responsePojo = (POJO)client.target(effectiveUri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.entity((Object)requestPojo, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke(POJO.class);
            String expectedWaypoints = String.join((CharSequence)",", origin, "CustomSerializer(CLIENT)", "CustomDeserializer(SERVER)", "EchoResource", "CustomSerializer(SERVER)", "CustomDeserializer(CLIENT)");
            MatcherAssert.assertThat((Object)responsePojo.getSeenBy(), (Matcher)Matchers.is((Object)expectedWaypoints));
        }
    }

    private static final int mockInt() {
        return (int)Math.round(2.147483647E9 * Math.random());
    }

    @ApplicationPath(value="")
    public static class EchoApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Collections.singleton(EchoResource.class);
        }

        public Set<Object> getSingletons() {
            return Collections.singleton(new CustomJsonbProvider(RuntimeType.SERVER));
        }

        @Path(value="echo")
        public static class EchoResource {
            @POST
            @Consumes(value={"application/json"})
            @Produces(value={"application/json"})
            public POJO echo(POJO pojo) {
                pojo.setSeenBy(String.join((CharSequence)",", pojo.getSeenBy(), "EchoResource"));
                return pojo;
            }
        }
    }

    public static final class POJO {
        private String seenBy;

        public final String getSeenBy() {
            return this.seenBy;
        }

        public final void setSeenBy(String seenBy) {
            this.seenBy = seenBy;
        }
    }

    public static final class CustomJsonbProvider
    implements ContextResolver<Jsonb> {
        private final RuntimeType runtimeType;

        private CustomJsonbProvider(RuntimeType runtimeType) {
            this.runtimeType = runtimeType;
        }

        public final Jsonb getContext(Class<?> type) {
            if (!POJO.class.isAssignableFrom(type)) {
                return null;
            }
            return JsonbBuilder.create((JsonbConfig)new JsonbConfig().withSerializers(new JsonbSerializer[]{new CustomSerializer()}).withDeserializers(new JsonbDeserializer[]{new CustomDeserializer()}));
        }

        private final class CustomDeserializer
        implements JsonbDeserializer<POJO> {
            private CustomDeserializer() {
            }

            public final POJO deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
                POJO pojo = new POJO();
                pojo.setSeenBy(String.format("%s,CustomDeserializer(%s)", parser.getObject().getString("seenBy"), CustomJsonbProvider.this.runtimeType));
                return pojo;
            }
        }

        private final class CustomSerializer
        implements JsonbSerializer<POJO> {
            private CustomSerializer() {
            }

            public final void serialize(POJO pojo, JsonGenerator generator, SerializationContext ctx) {
                generator.writeStartObject();
                generator.write("seenBy", String.format("%s,CustomSerializer(%s)", pojo.getSeenBy(), CustomJsonbProvider.this.runtimeType));
                generator.writeEnd();
            }
        }
    }
}

