/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.SecurityContextImpl;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.ContextOperation;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.RequestFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.RequestTemplateFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.ResponseFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.ResponseTemplateFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.illegalstate.TemplateFilter;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -8112756483664393579L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_container_requestcontext_illegalstate_web/resource");
        this.setPrintEntity(true);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/container/requestcontext/illegalstate/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_container_requestcontext_illegalstate_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, RequestFilter.class, ContextOperation.class, RequestTemplateFilter.class, ResponseFilter.class, ResponseTemplateFilter.class, TemplateFilter.class, PrintingErrorHandler.class, SecurityContextImpl.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void setMethodTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IllegalSteateException has been thrown");
        this.invokeRequestAndCheckResponse(ContextOperation.SETMETHOD);
    }

    @Test
    public void setRequestUriOneUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IllegalSteateException has been thrown");
        this.invokeRequestAndCheckResponse(ContextOperation.SETREQUESTURI1);
    }

    @Test
    public void setRequestUriTwoUrisTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IllegalSteateException has been thrown");
        this.invokeRequestAndCheckResponse(ContextOperation.SETREQUESTURI2);
    }

    @Test
    public void abortWithTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IllegalSteateException has been thrown");
        this.invokeRequestAndCheckResponse(ContextOperation.ABORTWITH);
    }

    @Test
    public void setEntityStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IllegalSteateException has been thrown");
        this.invokeRequestAndCheckResponse(ContextOperation.SETENTITYSTREAM);
    }

    @Test
    public void setSecurityContextTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IllegalSteateException has been thrown");
        this.invokeRequestAndCheckResponse(ContextOperation.SETSECURITYCONTEXT);
    }

    protected void invokeRequestAndCheckResponse(ContextOperation operation) throws JAXRSCommonClient.Fault {
        String op = operation.name();
        String request = this.buildRequest(JAXRSCommonClient.Request.GET, op.toLowerCase());
        String header = "OPERATION:" + op;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header);
        this.invoke();
    }
}

