/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.resource.valueofandfromstring;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.resource.valueofandfromstring.EnumWithFromStringAndValueOf;
import ee.jakarta.tck.ws.rs.spec.resource.valueofandfromstring.ParamEntityWithFromStringAndValueOf;
import ee.jakarta.tck.ws.rs.spec.resource.valueofandfromstring.Resource;
import ee.jakarta.tck.ws.rs.spec.resource.valueofandfromstring.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final String DATA = "ASDFGHJKLQWERTYUIOPPPPPPP";

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_resource_valueofandfromstring_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/resource/valueofandfromstring/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_resource_valueofandfromstring_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, EnumWithFromStringAndValueOf.class, ParamEntityWithFromStringAndValueOf.class, ParamEntityPrototype.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void enumHeaderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "param:ASDFGHJKLQWERTYUIOPPPPPPP");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/enumheader"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.FROMSTRING.name());
        this.invoke();
    }

    @Test
    public void enumCookieTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Cookie: param=ASDFGHJKLQWERTYUIOPPPPPPP");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/enumcookie"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.FROMSTRING.name());
        this.invoke();
    }

    @Test
    public void enumMaxtrixTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/enummatrix;param=ASDFGHJKLQWERTYUIOPPPPPPP"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.FROMSTRING.name());
        this.invoke();
    }

    @Test
    public void enumQueryTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/enumquery?param=ASDFGHJKLQWERTYUIOPPPPPPP"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.FROMSTRING.name());
        this.invoke();
    }

    @Test
    public void enumPathTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/enumpath/ASDFGHJKLQWERTYUIOPPPPPPP"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.FROMSTRING.name());
        this.invoke();
    }

    @Test
    public void entityHeaderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "param:ASDFGHJKLQWERTYUIOPPPPPPP");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/entityheader"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.VALUEOF.name());
        this.invoke();
    }

    @Test
    public void entityCookieTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Cookie: param=ASDFGHJKLQWERTYUIOPPPPPPP");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/entitycookie"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.VALUEOF.name());
        this.invoke();
    }

    @Test
    public void entityMaxtrixTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/entitymatrix;param=ASDFGHJKLQWERTYUIOPPPPPPP"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.VALUEOF.name());
        this.invoke();
    }

    @Test
    public void entityQueryTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/entityquery?param=ASDFGHJKLQWERTYUIOPPPPPPP"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.VALUEOF.name());
        this.invoke();
    }

    @Test
    public void entityPathTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/entitypath/ASDFGHJKLQWERTYUIOPPPPPPP"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EnumWithFromStringAndValueOf.VALUEOF.name());
        this.invoke();
    }
}

