/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jdom.Element;
import org.jdom.xpath.XPath;

public class EMMACTSConfig
extends Task {
    private EMMAInfo standAlone;
    private EMMAInfo appClient;
    private EMMAInfo appClient2;
    private EMMAInfo ejbEmbedded;
    private File tshome;
    private File j2eehome;
    private File emmaPropsFile;
    private File tsPropsFile;
    private File tsPropsFileOut;
    private File emmaJar;
    private File buildFile;
    private File buildFileOut;
    private Properties emmaProps = new Properties();
    private Properties tsJTEProps = new Properties();

    public void setTshome(File tshome) {
        this.tshome = tshome;
    }

    public void setJ2eehome(File j2eehome) {
        this.j2eehome = j2eehome;
    }

    public void execute() throws BuildException {
        this.checkPreConditions();
        this.setProps();
        this.getEmmaConfigData();
        this.editTsJte();
    }

    private void checkPreConditions() throws BuildException {
        if (this.tshome == null || !this.tshome.isDirectory()) {
            throw new BuildException("TS_HOME is not set or is not an existing directory \"" + this.tshome + "\"");
        }
        if (this.j2eehome == null || !this.j2eehome.isDirectory()) {
            throw new BuildException("J2EE_HOME is not set or is not an existing directory \"" + this.j2eehome + "\"");
        }
    }

    private void setProps() throws BuildException {
        FileInputStream emmaPropsStream = null;
        FileInputStream tsPropsStream = null;
        try {
            this.emmaJar = new File(this.tshome, "lib" + File.separator + "emma.jar");
            if (!this.emmaJar.isFile()) {
                throw new BuildException("EMMA jar does not exist at \"" + this.emmaJar.getPath() + "\"");
            }
            this.emmaPropsFile = new File(this.tshome, "internal" + File.separator + "coverage" + File.separator + "emma.properties");
            if (!this.emmaPropsFile.isFile()) {
                throw new BuildException("EMMA properties file does not exist at \"" + this.emmaPropsFile.getPath() + "\"");
            }
            this.tsPropsFileOut = new File(this.tshome, "bin" + File.separator + "ts.jte");
            this.tsPropsFile = new File(this.tshome, "bin" + File.separator + "ts.jte.original");
            if (!this.tsPropsFile.isFile()) {
                throw new BuildException("TS JTEproperties file does not exist at \"" + this.tsPropsFile.getPath() + "\"");
            }
            emmaPropsStream = new FileInputStream(this.emmaPropsFile);
            this.emmaProps.load(emmaPropsStream);
            tsPropsStream = new FileInputStream(this.tsPropsFile);
            this.tsJTEProps.load(tsPropsStream);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                emmaPropsStream.close();
                tsPropsStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void parseCoverageData(Properties p) throws BuildException {
        this.standAlone = new EMMAInfo(p.getProperty("standalone"));
        this.appClient = new EMMAInfo(p.getProperty("appclient"));
        this.appClient2 = new EMMAInfo(p.getProperty("appclient2"));
        this.ejbEmbedded = new EMMAInfo(p.getProperty("ejbembedded"));
    }

    private void getEmmaConfigData() throws BuildException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.emmaPropsFile);
            Properties props = new Properties();
            props.load(in);
            this.parseCoverageData(props);
            this.log("Read EMMA configuration data from file \"" + this.emmaPropsFile + "\"", 2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void editTsJte() throws BuildException {
        this.updatePathProp("implementation.classes.ri");
        this.updatePathProp("implementation.classes");
        this.editClientVM("command.testExecute");
        this.editClientVM("command.testExecuteAppClient");
        this.editClientVM("command.testExecuteAppClient2");
        this.editClientVM("command.testExecuteEjbEmbed");
        this.writeTsJte();
    }

    private void updatePathProp(String pathProp) throws BuildException {
        String path = this.tsJTEProps.getProperty(pathProp);
        if (path == null) {
            throw new BuildException("The ts.jte property \"" + pathProp + "\" does not exist.");
        }
        int index = path.indexOf("emma.jar");
        if (index == -1) {
            this.tsJTEProps.setProperty(pathProp, path + "${pathsep}" + this.emmaJar.getPath());
            this.log("Added \"" + this.emmaJar.getPath() + "\" to path \"" + pathProp + "\" in ts.jte", 3);
        }
    }

    private void editClientVM(String vm) throws BuildException {
        String vmCommand = this.tsJTEProps.getProperty(vm);
        if (vmCommand == null) {
            throw new BuildException("The ts.jte property \"" + vm + "\" does not exist.");
        }
        int index = vmCommand.indexOf("emma");
        if (index == -1) {
            StringBuffer buf = new StringBuffer(vmCommand);
            int index2 = buf.indexOf("-D");
            String emmaInfo = vm.equals("command.testExecuteAppClient") || vm.equals("command.testExecuteAppClient2") ? "-Xbootclasspath/a:${ts.home}/lib/emma.jar -Demma.coverage.out.file=" + this.getFile(vm) + " -Demma.rt.control.port=" + this.getPort(vm) : "-Demma.coverage.out.file=" + this.getFile(vm) + " -Demma.rt.control.port=" + this.getPort(vm);
            buf.insert(index2, emmaInfo + " ");
            this.tsJTEProps.setProperty(vm, buf.toString());
            this.log("Added \"" + emmaInfo + "\" to VM command \"" + vm + "\" in ts.jte", 3);
        }
    }

    private String getFile(String vm) {
        String result = "";
        if (vm.equals("command.testExecute")) {
            result = this.standAlone.getFile();
        } else if (vm.equals("command.testExecuteAppClient")) {
            result = this.appClient.getFile();
        } else if (vm.equals("command.testExecuteAppClient2")) {
            result = this.appClient2.getFile();
        } else if (vm.equals("command.testExecuteEjbEmbed")) {
            result = this.ejbEmbedded.getFile();
        }
        return result;
    }

    private String getPort(String vm) {
        String result = "";
        if (vm.equals("command.testExecute")) {
            result = this.standAlone.getPort();
        } else if (vm.equals("command.testExecuteAppClient")) {
            result = this.appClient.getPort();
        } else if (vm.equals("command.testExecuteAppClient2")) {
            result = this.appClient2.getPort();
        } else if (vm.equals("command.testExecuteEjbEmbed")) {
            result = this.ejbEmbedded.getPort();
        }
        return result;
    }

    private void writeTsJte() throws BuildException {
        FileOutputStream out = null;
        try {
            this.tsPropsFileOut.delete();
            out = new FileOutputStream(this.tsPropsFileOut);
            this.tsJTEProps.store(out, "EMMA Configged ts.jte File");
            this.log("Wrote EMMAed file \"" + this.tsPropsFileOut + "\"", 2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean jcovved(Element el) {
        boolean result = false;
        try {
            XPath xpath = XPath.newInstance((String)"sysproperty[@key='emma.coverage.out.file']");
            List javaElement = xpath.selectNodes((Object)el);
            result = javaElement.size() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static class EMMAInfo {
        private String file;
        private String port;

        public EMMAInfo(String info) throws BuildException {
            String[] a = info.split(":");
            if (a.length == 1) {
                this.port = a[0];
                this.file = "";
            } else if (a.length == 2) {
                this.file = a[0];
                this.port = a[1];
            } else {
                throw new BuildException("Badly formed EMMA data \"" + info + "\"");
            }
        }

        public String getPort() {
            return this.port;
        }

        public String getFile() {
            return this.file;
        }
    }
}

