/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.httpservletresponse;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.spec.httpservletresponse.HttpTestServlet;
import servlet.tck.spec.httpservletresponse.RedirectedTestServlet;

public class HttpServletResponseTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("HttpTestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_spec_httpservletresponse_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{HttpTestServlet.class, RedirectedTestServlet.class})).setWebXML(HttpServletResponseTests.class.getResource("servlet_spec_httpservletresponse_web.xml"));
    }

    @Test
    public void intHeaderTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("expected_headers", "header1: 12345");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_headers", "header2: 56789");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=intHeaderTest HTTP/1.1");
        this.invoke();
    }

    @Disabled
    @Test
    public void flushBufferTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_headers", "header1: 12345");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=flushBufferTest HTTP/1.1");
        this.invoke();
    }

    @Test
    public void sendErrorCommitTest() throws Exception {
        String testname = "sendErrorCommitTest";
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_headers", "header1: 12345");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1");
        this.invoke();
    }

    @Test
    public void sendRedirectCommitTest() throws Exception {
        String testname = "sendRedirectCommitTest";
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_headers", "header1: 12345");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "302");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1");
        this.invoke();
    }

    @Test
    public void sendRedirectClearBufferTest() throws Exception {
        String testname = "sendRedirectClearBufferTest";
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "302");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1");
        this.invoke();
    }
}

