/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ScrapeFailedBuildLog
extends Task {
    protected static final String NL = System.getProperty("line.separator", "\n");
    protected File buildlog;
    protected File secondarybuildlog;
    protected String proprietaryerrors;
    protected String proprietaryerrorsexist;
    protected String faileddir;
    protected String buildpassed;
    protected boolean inBuildFailed = false;
    protected boolean buildFailed = false;
    protected boolean proprietaryErrors = false;
    StringBuffer proprietaryErrorList = new StringBuffer();

    public void setBuildlog(File buildlog) {
        this.buildlog = buildlog;
    }

    public void setSecondaryBuildlog(File secondarybuildlog) {
        this.secondarybuildlog = secondarybuildlog;
    }

    public void setBuildpassed(String buildpassed) {
        this.buildpassed = buildpassed;
    }

    public void setFaileddir(String faileddir) {
        this.faileddir = faileddir;
    }

    public void setProprietaryerrorsexist(String proprietaryerrorsexist) {
        this.proprietaryerrorsexist = proprietaryerrorsexist;
    }

    public void setProprietaryerrors(String proprietaryerrors) {
        this.proprietaryerrors = proprietaryerrors;
    }

    public void execute() throws BuildException {
        this.checkPreconditions();
        this.processLog();
        this.processSecondaryBuildLog();
    }

    protected void processSecondaryBuildLog() {
        if (this.secondarybuildlog == null) {
            System.err.println("Secondary build log is null, skipping the check for proprietary APIs in the second build log.");
            return;
        }
        if (!this.secondarybuildlog.isFile()) {
            System.err.println("Secondary build log [\"" + this.secondarybuildlog + "\"] does not exist, skipping the check for proprietary APIs in the second build log.");
            return;
        }
        BufferedReader in = null;
        String line = null;
        try {
            in = new BufferedReader(new FileReader(this.secondarybuildlog));
            while ((line = in.readLine()) != null) {
                String proprietaryResult = this.checkLine0(line);
                if (proprietaryResult == null) continue;
                this.proprietaryErrorList.append(proprietaryResult + NL + NL);
            }
            if (this.proprietaryErrors) {
                this.project.setProperty(this.proprietaryerrorsexist, "true");
                this.project.setProperty(this.proprietaryerrors, this.proprietaryErrorList.toString());
            } else {
                this.project.setProperty(this.proprietaryerrorsexist, "false");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void checkPreconditions() throws BuildException {
        if (this.buildlog == null) {
            throw new BuildException("Error, \"buildlog\" attribute must be specified");
        }
        if (!this.buildlog.isFile()) {
            throw new BuildException("Error, build log file \"" + this.buildlog + "\" does not exist");
        }
        if (this.buildpassed == null || this.buildpassed.length() == 0) {
            throw new BuildException("Error, \"buildpassed\" attribute must be specified");
        }
        if (this.faileddir == null || this.faileddir.length() == 0) {
            throw new BuildException("Error, \"faileddir\" attribute must be specified");
        }
        if (this.proprietaryerrors == null || this.proprietaryerrors.length() == 0) {
            throw new BuildException("Error, \"proprietaryerrors\" attribute must be specified");
        }
        if (this.proprietaryerrorsexist == null || this.proprietaryerrorsexist.length() == 0) {
            throw new BuildException("Error, \"proprietaryerrorsexist\" attribute must be specified");
        }
    }

    protected void processLog() throws BuildException {
        BufferedReader in = null;
        String line = null;
        StringBuffer failedDirList = new StringBuffer();
        try {
            in = new BufferedReader(new FileReader(this.buildlog));
            while ((line = in.readLine()) != null) {
                String result = this.checkLine(line);
                String proprietaryResult = this.checkLine0(line);
                if (result != null) {
                    failedDirList.append(result + NL);
                }
                if (proprietaryResult == null) continue;
                this.proprietaryErrorList.append(proprietaryResult + NL + NL);
            }
            if (this.buildFailed) {
                this.project.setProperty(this.buildpassed, "false");
                this.project.setProperty(this.faileddir, failedDirList.toString());
            } else {
                this.project.setProperty(this.buildpassed, "true");
            }
            if (this.proprietaryErrors) {
                this.project.setProperty(this.proprietaryerrorsexist, "true");
                this.project.setProperty(this.proprietaryerrors, this.proprietaryErrorList.toString());
            } else {
                this.project.setProperty(this.proprietaryerrorsexist, "false");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    protected String checkLine0(String line) {
        String result = null;
        String searchString = "[ts.javac]";
        String searchString2 = "proprietary API";
        int index = line.indexOf(searchString);
        int index2 = line.indexOf(searchString2);
        if (index != -1 && index2 != -1) {
            this.proprietaryErrors = true;
            result = line;
        }
        return result;
    }

    protected String checkLine(String line) {
        String result = null;
        String searchString = "[dosubdirs]";
        String searchString2 = "BUILD FAILED";
        int index = line.indexOf(searchString);
        int index2 = line.indexOf(searchString2);
        if (index != -1 && index2 != -1) {
            this.inBuildFailed = true;
            this.buildFailed = true;
            result = line;
        } else if (this.inBuildFailed && index != -1) {
            result = line;
        } else {
            this.inBuildFailed = false;
        }
        return result;
    }
}

