/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ExtensionImpl;
import com.sun.ts.tests.websocket.common.impl.ExtensionParameterImpl;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.ExtensionsServerEndpointConfig;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.OriginConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.WSCExtensionsServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.WSCGetEndpointInstanceServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.WSCSubprotocolServer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Extension;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 3657966075180214792L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_server_serverendpointconfig_configurator_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator"});
        archive.addClasses(new Class[]{IOUtil.class, StringUtil.class});
        archive.addClasses(new Class[]{ExtensionImpl.class, ExtensionParameterImpl.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_server_serverendpointconfig_configurator_web");
    }

    @Test
    public void checkOriginTest() throws Exception {
        this.invoke("origin", (Object)"reset", "");
        this.invoke("origin", (Object)"get", "", false);
        String origin = this.getResponseAsString();
        WSCClientIT.assertTrue(OriginConfigurator.NULL.equals(origin) || origin.contains(this._hostname), "Unexpected origin received", origin);
    }

    @Test
    public void checkOriginReturnsFalseTest() throws Exception {
        this.invoke("originreturnsfalseconfig", (Object)"false", "false");
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("originreturnsfalse"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "anything");
        try {
            this.logExceptionOnInvoke = false;
            this.invoke();
            new Exception("First attempt for handshake should return false due to origin");
        }
        catch (Exception e) {
            WSCClientIT.logMsg("thrown exception as expected when checkOrigin == false");
        }
        this.invoke("originreturnsfalseconfig", (Object)"true", "true");
        this.invoke("originreturnsfalse", (Object)"anything", "anything");
    }

    @Test
    public void getEndpointInstanceTest() throws Exception {
        String search = WSCGetEndpointInstanceServer.class.getName() + "Additional information passed to instance";
        this.invoke("endpointinstance", (Object)"anything", search);
        this.invoke("endpointinstance", (Object)"anything", search);
    }

    @Test
    public void getNegotiatedExtensionsRequestedTest() throws Exception {
        List<ExtensionImpl> extensions = WSCExtensionsServer.getRequestedExtension();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().extensions(extensions).build();
        this.setClientEndpointConfig(config);
        this.invoke("extensions", (Object)"requested", ExtensionImpl.toString(extensions));
    }

    @Test
    public void getNegotiatedExtensionsInstalledTest() throws Exception {
        List<ExtensionImpl> extensions = WSCExtensionsServer.getRequestedExtension();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().extensions(extensions).build();
        this.setClientEndpointConfig(config);
        List<Extension> installed = new ExtensionsServerEndpointConfig().getExtensions();
        String search = ExtensionImpl.toString(installed);
        search = search.substring(0, search.length() - 1);
        this.invoke("extensions", (Object)"installed", search);
    }

    @Test
    public void getNegotiatedExtensionsResultedTest() throws Exception {
        List<ExtensionImpl> extensions = WSCExtensionsServer.getRequestedExtension();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().extensions(extensions).build();
        this.setClientEndpointConfig(config);
        this.invoke("extensions", (Object)"resulted", ExtensionImpl.toString(extensions));
    }

    @Test
    public void getNegotiatedExtensionsOrderedByRequestTest() throws Exception {
        List<ExtensionImpl> extensions = WSCExtensionsServer.getOrderedExtensions();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().extensions(extensions).build();
        this.setClientEndpointConfig(config);
        this.invoke("extensions", (Object)"resultedinorder", ExtensionImpl.toString(extensions));
    }

    @Test
    public void getNegotiatedSubprotocolRequestedTest() throws Exception {
        List<String> subprotocols = WSCSubprotocolServer.getRequestedSubprotocols();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().preferredSubprotocols(subprotocols).build();
        this.setClientEndpointConfig(config);
        this.invoke("subprotocols", (Object)"requested", StringUtil.collectionToString(subprotocols));
    }

    @Test
    public void getNegotiatedSubprotocolSupportedTest() throws Exception {
        List<String> subprotocols = WSCSubprotocolServer.getRequestedSubprotocols();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().preferredSubprotocols(subprotocols).build();
        this.setClientEndpointConfig(config);
        this.invoke("subprotocols", (Object)"supported", StringUtil.collectionToString(WSCSubprotocolServer.getSupportedSubprotocols()));
    }

    @Test
    public void getNegotiatedSubprotocolResultedTest() throws Exception {
        List<String> subprotocols = WSCSubprotocolServer.getRequestedSubprotocols();
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().preferredSubprotocols(subprotocols).build();
        this.setClientEndpointConfig(config);
        this.invoke("subprotocols", (Object)"resulted", StringUtil.WEBSOCKET_SUBPROTOCOLS[2]);
    }

    @Test
    public void getNegotiatedSubprotocolResultedIsEmptyTest() throws Exception {
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().preferredSubprotocols(Arrays.asList(StringUtil.WEBSOCKET_SUBPROTOCOLS[6])).build();
        this.setClientEndpointConfig(config);
        this.invoke("subprotocols", (Object)"resulted", "{}");
    }

    @Test
    public void modifyHandshakeAfterCheckOriginTest() throws Exception {
        this.invoke("modifyhandshake", (Object)"origin", "true");
    }

    @Test
    public void modifyHandshakeConfigTest() throws Exception {
        this.invoke("modifyhandshake", (Object)"config", "true");
    }

    @Test
    public void modifyHandshakeRequestTest() throws Exception {
        this.invoke("modifyhandshake", (Object)"request", "true");
    }

    @Test
    public void modifyHandshakeResponseTest() throws Exception {
        this.invoke("modifyhandshake", (Object)"response", "true");
    }

    @Test
    public void getContainerDefaultConfiguratorTest() throws Exception {
        this.invoke("containerdefaultconfiguratorA", (Object)"anything", "");
        String containerdefaultconfiguratorIdA = this.getResponseAsString();
        this.invoke("containerdefaultconfiguratorB", (Object)"anything", "");
        String containerdefaultconfiguratorIdB = this.getResponseAsString();
        WSCClientIT.assertEquals(containerdefaultconfiguratorIdA, containerdefaultconfiguratorIdB, "Different instances returned for container default configurator");
    }
}

