/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessagereturntype;

import com.sun.ts.tests.websocket.common.client.ByteBufferClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -5623230069104999740L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_ee_websocketmessagereturntype_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessagereturntype"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_ee_websocketmessagereturntype_web");
    }

    @Test
    public void dataTypesTest() throws Exception {
        this.invokeDataTypeSequence("true", "boolean");
        this.invokeDataTypeSequence("123", "byte");
        this.invokeDataTypeSequence(String.valueOf(Short.MAX_VALUE), "short");
        this.invokeDataTypeSequence(String.valueOf(Short.MIN_VALUE), "int");
        this.invokeDataTypeSequence(String.valueOf(Short.MIN_VALUE), "long");
        this.invokeDataTypeSequence(String.valueOf(123.456f), "float");
        this.invokeDataTypeSequence(String.valueOf(789.012), "double");
        this.invokeDataTypeSequence(String.valueOf('A'), "char");
    }

    @Test
    public void textEncoderTest() throws Exception {
        this.invokeSequence("textEncoderTest", "textencoder");
    }

    @Test
    public void textStreamEncoderTest() throws Exception {
        this.invokeSequence("textStreamEncoderTest", "textstreamencoder");
    }

    @Test
    public void binaryEncoderTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("binaryEncoderTest", "binaryencoder");
    }

    @Test
    public void binaryStreamEncoderTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("binaryStreamEncoderTest", "binarystreamencoder");
    }

    @Test
    public void byteArrayTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("byteArrayTest", "bytearray");
    }

    @Test
    public void byteBufferTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("byteBufferTest", "bytebuffer");
    }

    @Test
    public void directByteBufferTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("byteBufferTest", "directbytebuffer");
    }

    private void invokeSequence(String search, String ... sequence) throws Exception {
        for (int i = 0; i != sequence.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(sequence[i]));
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, search);
            this.setProperty(WebSocketCommonClient.Property.CONTENT, search);
            this.invoke();
        }
    }

    private void invokeDataTypeSequence(String search, String type) throws Exception {
        String[] sequence = new String[]{"primitive" + type, "full" + type};
        this.invokeSequence(search, sequence);
    }
}

