/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.unmarshallerhandler;

import jakarta.xml.bind.UnmarshallerHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.SAXException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import javasoft.sqe.tests.api.jakarta.xml.bind.ErrorCollector;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class UnmarshallerHandler_CTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        UnmarshallerHandler_CTTests test = new UnmarshallerHandler_CTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status getResult001( ) {
        ErrorCollector eh = new ErrorCollector();

        try {
            JAXBContext jc = getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();

            eh.setParent(u.getEventHandler());
            u.setSchema(schema);
            u.setEventHandler(eh);

            UnmarshallerHandler uh = u.getUnmarshallerHandler();

            // emulate SAX parsing of the document:
            // <test:root 
            //      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            //      xmlns:test="api/UnmarshallerHandler"
            //      xsi:schemaLocation="api/UnmarshallerHandler UnmarshallerHandler.xsd"
            // >a</test:root>
            uh.startDocument();
             uh.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
              uh.startPrefixMapping("test", "api/UnmarshallerHandler");
               uh.startElement("api/UnmarshallerHandler", "root", "test:root", new AttributesImpl());
                uh.characters(new char[] {'a'}, 0, 1);
               uh.endElement("api/UnmarshallerHandler", "root", "test:root");
              uh.endPrefixMapping("test");
             uh.endPrefixMapping("xsi");
            uh.endDocument();

            Object obj = uh.getResult();

            if (obj == null) {
                return Status.failed("uh.getResult() returns null");
            }

            if (! (obj instanceof JAXBElement)) {
                return Status.failed("uh.getResult() doesn't return an instance of JAXBElement: " + obj);
            }

            JAXBElement<String> root = (JAXBElement<String>)obj;

            if (!root.getValue().equals("a")) {
                return Status.failed("uh.getResult() returns unexpected root object: "
                                   + root.getValue() + ", expected is 'a'");
            }

            return Status.passed("OKAY");

        } catch (SAXException se) {
            return Status.failed(se.toString());
        } catch (JAXBException jaxbe) {
            if (!eh.hasEvents()) {
                return Status.failed("no error events are handled but " + jaxbe + " is thrown");
            }
            return Status.failed(jaxbe.toString());
        } finally {
            eh.printEvents(ref);
        }
    }

    public Status getResult002( ) {
        ErrorCollector eh = new ErrorCollector();

        try {
            JAXBContext jc = getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();

            eh.setParent(u.getEventHandler());
            u.setSchema(schema);
            u.setEventHandler(eh);

            UnmarshallerHandler uh = u.getUnmarshallerHandler();

            Object obj = uh.getResult();

            return Status.failed("getResult() called before endDocument event does not " 
                               + "throw IllegalStateException, it returns " + obj);

        } catch (IllegalStateException ise) {
            return Status.passed("OKAY");
        } catch (JAXBException jaxbe) {
            if (!eh.hasEvents()) {
                return Status.failed("no error events are handled but " + jaxbe + " is thrown");
            }
            return Status.failed(jaxbe.toString());
        } finally {
            eh.printEvents(ref);
        }
    }

    public Status getResult003( ) {
        ErrorCollector eh = new ErrorCollector();

        try {
            JAXBContext jc = getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();

            eh.setParent(u.getEventHandler());
            u.setSchema(schema);
            u.setEventHandler(eh);

            UnmarshallerHandler uh = u.getUnmarshallerHandler();

            // emulate SAX parsing of the document:
            // <test:root 
            //      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            //      xmlns:test="api/UnmarshallerHandler"
            //      xsi:schemaLocation="api/UnmarshallerHandler UnmarshallerHandler.xsd"
            // >a</test:root>
            uh.startDocument();
             uh.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
              uh.startPrefixMapping("test", "api/UnmarshallerHandler");
               uh.startElement("api/UnmarshallerHandler", "root", "test:root", new AttributesImpl());
                uh.characters(new char[] {'a'}, 0, 1);
               uh.endElement("api/UnmarshallerHandler", "root", "test:root");
              uh.endPrefixMapping("test");
             uh.endPrefixMapping("xsi");
            // uh.endDocument();

            Object obj = uh.getResult();

            return Status.failed("getResult() called before endDocument event does not " 
                               + "throw IllegalStateException, it returns " + obj);

        } catch (IllegalStateException ise) {
            return Status.passed("OKAY");
        } catch (SAXException se) {
            return Status.failed(se.toString());
        } catch (JAXBException jaxbe) {
            if (!eh.hasEvents()) {
                return Status.failed("no error events are handled but " + jaxbe + " is thrown");
            }
            return Status.failed(jaxbe.toString());
        } finally {
            eh.printEvents(ref);
        }
    }


}

