/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.services.Connector;
import com.sun.javatest.services.Message;
import com.sun.javatest.services.MessageHandler;
import com.sun.javatest.services.ServiceExecutor;
import com.sun.javatest.services.ServiceProperties;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Service
implements MessageHandler {
    protected ServiceProperties props;
    protected Connector conn;
    protected String id;
    protected String descr;
    protected Logger log;

    public abstract ServiceExecutor getDefaultServiceExecutor();

    public abstract Message prepareMessage(Message.MessageType var1) throws MalformedParamsException;

    @Override
    public void handleMessage(Message msg) {
    }

    public boolean start() throws NotConnectedException, ServiceError {
        Message msg;
        if (this.conn == null || !this.conn.connected()) {
            throw new NotConnectedException("Not connected to executor");
        }
        try {
            msg = this.prepareMessage(Message.MessageType.START);
        }
        catch (MalformedParamsException e) {
            this.logMalformedException(e, Message.MessageType.START);
            return false;
        }
        Message response = this.conn.send(msg);
        if (response.getType() == Message.MessageType.ERROR) {
            throw new ServiceError(response.getContent().toString());
        }
        if (response.getType() != Message.MessageType.STARTED) {
            this.logBadMsgTypeException(response.getType(), Message.MessageType.STARTED);
            return false;
        }
        return true;
    }

    public boolean stop() throws NotConnectedException, ServiceError {
        Message msg;
        if (this.conn == null || !this.conn.connected()) {
            throw new NotConnectedException("Not connected to executor");
        }
        try {
            msg = this.prepareMessage(Message.MessageType.STOP);
        }
        catch (MalformedParamsException e) {
            this.logMalformedException(e, Message.MessageType.STOP);
            return false;
        }
        Message response = this.conn.send(msg);
        if (response.getType() == Message.MessageType.ERROR) {
            throw new ServiceError(response.getContent().toString());
        }
        if (response.getType() != Message.MessageType.STOPPED) {
            this.logBadMsgTypeException(response.getType(), Message.MessageType.STOPPED);
            return false;
        }
        return true;
    }

    public boolean isAlive() throws NotConnectedException, ServiceError {
        Message msg;
        if (this.conn == null || !this.conn.connected()) {
            throw new NotConnectedException("Not connected to executor");
        }
        try {
            msg = this.prepareMessage(Message.MessageType.IS_ALIVE);
        }
        catch (MalformedParamsException e) {
            this.logMalformedException(e, Message.MessageType.IS_ALIVE);
            return false;
        }
        Message response = this.conn.send(msg);
        if (response.getType() == Message.MessageType.ERROR) {
            throw new ServiceError(response.getContent().toString());
        }
        if (response.getType() != Message.MessageType.ALIVE && response.getType() != Message.MessageType.NOT_ALIVE) {
            this.logBadMsgTypeException(response.getType(), Message.MessageType.ALIVE);
            this.logBadMsgTypeException(response.getType(), Message.MessageType.NOT_ALIVE);
            return false;
        }
        return response.getType() == Message.MessageType.ALIVE;
    }

    public InputStream getInputStream() throws NotConnectedException {
        if (this.conn == null || !this.conn.connected()) {
            throw new NotConnectedException("Not connected to executor");
        }
        return this.conn.getServiceOutputStream();
    }

    public InputStream getErrorStream() throws NotConnectedException {
        if (this.conn == null || !this.conn.connected()) {
            throw new NotConnectedException("Not connected to executor");
        }
        return this.conn.getServiceErrorStream();
    }

    public void setConnector(Connector conn) {
        this.conn = conn;
    }

    public Connector getConnector() {
        return this.conn;
    }

    public void setProperties(ServiceProperties props) {
        this.props = props;
    }

    public ServiceProperties getProperties() {
        return this.props;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setDescription(String descr) {
        this.descr = descr;
    }

    public String getDescription() {
        return this.descr;
    }

    Logger createLog(Parameters params) {
        TestSuite ts = params.getTestSuite();
        WorkDirectory wd = params.getWorkDirectory();
        String name = "service-" + this.id + "-log";
        try {
            this.log = ts.createLog(wd, null, name);
        }
        catch (TestSuite.DuplicateLogNameFault ex) {
            try {
                this.log = ts.getLog(wd, name);
            }
            catch (TestSuite.NoSuchLogFault noSuchLogFault) {
                // empty catch block
            }
        }
        return this.log;
    }

    public Logger getLog() {
        return this.log;
    }

    private void logMalformedException(MalformedParamsException e, Message.MessageType t) {
        String msg = "Message malformed.\n";
        msg = msg + "Message type: " + t.toString() + "\n";
        msg = msg + "Parameters used:\n";
        Map<String, String> params = e.getParams();
        for (String s : params.keySet()) {
            msg = msg + s + '=' + params.get(s);
        }
        this.log.log(Level.SEVERE, msg);
    }

    private void logBadMsgTypeException(Message.MessageType received, Message.MessageType expected) {
        String msg = "Wrong response msg type: \n";
        msg = msg + "Received :" + received.toString() + "\n";
        msg = msg + "Expected :" + expected.toString() + "\n";
        this.log.log(Level.SEVERE, msg);
    }

    public static class MalformedParamsException
    extends Exception {
        private String descr;
        private Map<String, String> params;

        public MalformedParamsException(String s, Map<String, String> params) {
            this.descr = s;
            this.params = params;
        }

        public String getDescription() {
            return this.descr;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }

    public static class ServiceError
    extends Exception {
        public ServiceError(String msg) {
            super(msg);
        }
    }

    public static class NotConnectedException
    extends Exception {
        public NotConnectedException(String msg) {
            super(msg);
        }
    }
}

