/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.OptionalLong;

public class ExcludeListUpdateHandler {
    private File localFile;
    private OptionalLong localFileLastModified = OptionalLong.empty();
    private URL remoteURL;
    private OptionalLong remoteURLLastModified = OptionalLong.empty();

    public ExcludeListUpdateHandler(URL remoteURL, File localFile) {
        if (remoteURL == null || localFile == null) {
            throw new NullPointerException();
        }
        this.remoteURL = remoteURL;
        this.localFile = localFile;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public long getLocalFileLastModified() {
        if (!this.localFileLastModified.isPresent()) {
            this.localFileLastModified = OptionalLong.of(this.localFile.lastModified());
        }
        return this.localFileLastModified.getAsLong();
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public long getRemoteURLLastModified() throws IOException {
        if (!this.remoteURLLastModified.isPresent()) {
            URLConnection c = this.remoteURL.openConnection();
            c.connect();
            this.remoteURLLastModified = OptionalLong.of(c.getLastModified());
            c.getInputStream().close();
        }
        return this.remoteURLLastModified.getAsLong();
    }

    public boolean isUpdateAvailable() throws IOException {
        this.getLocalFileLastModified();
        this.getRemoteURLLastModified();
        return this.remoteURLLastModified.getAsLong() > this.localFileLastModified.getAsLong();
    }

    public void update() throws IOException {
        this.update(this.remoteURL.openConnection());
    }

    public void updateIfNewer() throws IOException {
        URLConnection c = this.remoteURL.openConnection();
        c.getContentLength();
        c.connect();
        long remoteURLLastModified = c.getLastModified();
        this.remoteURLLastModified = OptionalLong.of(remoteURLLastModified);
        if (remoteURLLastModified > this.getLocalFileLastModified()) {
            this.update(c);
        } else {
            c.getInputStream().close();
        }
    }

    private void update(URLConnection c) throws IOException {
        int n;
        c.connect();
        int totalBytes = c.getContentLength();
        BufferedInputStream in = new BufferedInputStream(c.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.localFile));
        int bytesSoFar = 0;
        byte[] data = new byte[4096];
        while ((n = ((InputStream)in).read(data)) != -1) {
            ((OutputStream)out).write(data, 0, n);
            int n2 = Math.max((bytesSoFar += n) * 100 / totalBytes, 100);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

