/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.util.XMLWriter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;

abstract class COFItem {
    BeanInfo bi = null;
    LinkedHashMap<String, String> itemAttributes = this.getItemAttributes();
    LinkedHashMap<String, String> itemElements = this.getItemElements();
    String itemTagName = this.getItemTagName();
    PropertyDescriptor[] pds = null;

    COFItem() {
    }

    private String[] getAttributeProperties() {
        return this.itemAttributes == null ? null : this.itemAttributes.keySet().toArray(new String[this.itemAttributes.size()]);
    }

    LinkedHashMap<String, String> getItemAttributes() {
        return null;
    }

    LinkedHashMap<String, String> getItemElements() {
        return null;
    }

    String getItemTagName() {
        return null;
    }

    Object getProperty(String name) {
        if (this.bi == null) {
            try {
                this.bi = Introspector.getBeanInfo(this.getClass());
                this.pds = this.bi.getPropertyDescriptors();
                Arrays.sort(this.pds, (o1, o2) -> {
                    PropertyDescriptor pd1 = (PropertyDescriptor)o1;
                    PropertyDescriptor pd2 = (PropertyDescriptor)o2;
                    return pd1.getName().compareTo(pd2.getName());
                });
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        if (this.pds == null) {
            return null;
        }
        Object result = null;
        int propIndex = Arrays.binarySearch(this.pds, name, (o1, o2) -> {
            PropertyDescriptor pd = (PropertyDescriptor)o1;
            String propName = (String)o2;
            return pd.getName().compareTo(propName);
        });
        if (propIndex < 0 || propIndex >= this.pds.length) {
            return null;
        }
        try {
            Method readMethod = this.pds[propIndex].getReadMethod();
            if (readMethod == null) {
                System.err.println("Error occured for property '" + name + "' - no read method defined. Please contact developers.");
                return null;
            }
            result = readMethod.invoke((Object)this, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String[] getPropOrder() {
        return this.itemElements == null ? null : this.itemElements.keySet().toArray(new String[this.itemElements.size()]);
    }

    void write(XMLWriter out) throws IOException {
        if (this.itemTagName == null) {
            return;
        }
        out.startTag(this.itemTagName);
        if (this.itemAttributes != null) {
            String[] attrOrder;
            for (String s : attrOrder = this.getAttributeProperties()) {
                out.writeAttr(this.itemAttributes.get(s).toString(), (String)this.getProperty(s));
            }
        }
        if (this.itemElements != null) {
            String[] propOrder = this.getPropOrder();
            for (String s : propOrder) {
                Object propValue = this.getProperty(s);
                if (propValue instanceof COFItem) {
                    COFItem item = (COFItem)propValue;
                    item.write(out);
                    continue;
                }
                if (propValue instanceof Collection) {
                    this.writeCollection(out, s);
                    continue;
                }
                if (propValue == null) continue;
                out.startTag(this.itemElements.get(s).toString());
                this.write(out, propValue);
                out.endTag(this.itemElements.get(s).toString());
            }
        }
        out.endTag(this.itemTagName);
    }

    protected void write(XMLWriter out, Object o) throws IOException {
        if (o instanceof String) {
            out.write((String)o);
        } else if (o instanceof Date) {
            out.writeDate((Date)o);
        } else {
            out.write(o.toString());
        }
    }

    void writeCollection(XMLWriter out, String propName) throws IOException {
        Collection col = (Collection)this.getProperty(propName);
        for (Object value : col) {
            if (value instanceof COFItem) {
                ((COFItem)value).write(out);
                continue;
            }
            out.startTag(this.itemElements.get(propName).toString());
            this.write(out, value);
            out.endTag(this.itemElements.get(propName).toString());
        }
    }
}

