/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.eavp.viz.datastructures.VizObject.IManagedUpdateable;
import org.eclipse.eavp.viz.datastructures.VizObject.IManagedUpdateableListener;
import org.eclipse.eavp.viz.datastructures.VizObject.SubscriptionType;
import org.eclipse.eavp.viz.service.IVizService;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IUpdateable;
import org.eclipse.january.form.IUpdateableListener;
import org.eclipse.january.geometry.Geometry;
import org.eclipse.january.geometry.GeometryFactory;

@XmlRootElement(name="GeometryComponent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GeometryComponent
extends ICEObject
implements Component,
IUpdateableListener,
IManagedUpdateableListener {
    @XmlTransient
    private ArrayList<IUpdateableListener> listeners = new ArrayList();
    @XmlTransient
    private Geometry geometry = GeometryFactory.eINSTANCE.createGeometry();
    @XmlTransient
    private IVizService service;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.notifyListeners();
    }

    @Override
    public void setId(int id) {
        super.setId(id);
        this.notifyListeners();
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry newGeometry) {
        this.geometry = newGeometry;
        this.geometry.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                GeometryComponent.this.notifyListeners();
            }
        });
        this.notifyListeners();
    }

    public void setService(IVizService service) {
        this.service = service;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || !(otherObject instanceof GeometryComponent)) {
            return false;
        }
        if (!super.equals(otherObject)) {
            return false;
        }
        GeometryComponent geometryComponent = (GeometryComponent)otherObject;
        return this.geometry.equals(geometryComponent.geometry);
    }

    public void copy(GeometryComponent iceObject) {
        if (iceObject == null) {
            return;
        }
        super.copy(iceObject);
        Geometry otherGeometry = iceObject.getGeometry();
        if (otherGeometry != null) {
            this.setGeometry((Geometry)otherGeometry.clone());
        } else {
            this.geometry = null;
        }
        this.notifyListeners();
    }

    @Override
    public Object clone() {
        GeometryComponent geometryComponent = new GeometryComponent();
        geometryComponent.copy(this);
        return geometryComponent;
    }

    @Override
    protected void notifyListeners() {
        GeometryComponent geometryComponent = this;
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).update(geometryComponent);
            ++i;
        }
    }

    @Override
    public void update(String updatedKey, String newValue) {
    }

    @Override
    public void register(IUpdateableListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void update(IUpdateable component) {
        this.notifyListeners();
    }

    public void update(IManagedUpdateable component, SubscriptionType[] type) {
        this.notifyListeners();
    }

    public ArrayList<SubscriptionType> getSubscriptions(IManagedUpdateable source) {
        ArrayList<SubscriptionType> types = new ArrayList<SubscriptionType>();
        types.add(SubscriptionType.ALL);
        return types;
    }
}

