/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.IEntry;
import org.eclipse.january.form.IUpdateable;
import org.eclipse.january.form.IUpdateableListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="AbstractEntry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractEntry
implements IEntry {
    @XmlTransient
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int uniqueId = 1;
    protected String objectName = "ICE Entry";
    protected String objectDescription = "ICE Entry";
    @XmlTransient
    protected ArrayList<IUpdateableListener> listeners = new ArrayList();
    @XmlAttribute
    protected String value = "";
    @XmlAttribute
    protected String errorMessage = null;
    @XmlAttribute
    protected String defaultValue = "";
    @XmlAttribute
    protected String contextId = "default";
    @XmlElement(name="Comment")
    protected String comment = "";
    @XmlAttribute
    protected String tag = "";
    @XmlAttribute
    protected boolean isReady = true;
    @XmlAttribute
    protected boolean isModified = false;
    @XmlAttribute
    protected boolean isRequired = true;
    @XmlAttribute
    protected boolean isSecret = false;

    @Override
    public void setId(int id) {
        if (id >= 0) {
            this.uniqueId = id;
            this.notifyListeners();
        }
    }

    @Override
    @XmlAttribute
    public int getId() {
        return this.uniqueId;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.objectName = name;
            this.notifyListeners();
        }
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.objectName;
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.objectDescription = description;
            this.notifyListeners();
        }
    }

    @Override
    @XmlAttribute
    public String getDescription() {
        return this.objectDescription;
    }

    public void copy(AbstractEntry entity) {
        if (entity == null) {
            return;
        }
        this.objectDescription = entity.objectDescription;
        this.objectName = entity.objectName;
        this.uniqueId = entity.uniqueId;
        this.comment = entity.comment;
        this.defaultValue = entity.defaultValue;
        this.value = entity.value;
        this.isModified = entity.isModified;
        this.isReady = entity.isReady;
        this.isRequired = entity.isRequired;
        this.tag = entity.tag;
        this.contextId = entity.contextId;
    }

    protected void notifyListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Thread notifierThread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < AbstractEntry.this.listeners.size()) {
                        AbstractEntry.this.listeners.get(i).update(AbstractEntry.this);
                        ++i;
                    }
                }
            };
            notifierThread.start();
        }
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean equals(Object otherObject) {
        boolean retVal = false;
        AbstractEntry castedOtherObject = null;
        if (otherObject != null && otherObject instanceof AbstractEntry) {
            if (this == otherObject) {
                retVal = true;
            } else {
                castedOtherObject = (AbstractEntry)otherObject;
                retVal = this.uniqueId == castedOtherObject.uniqueId && this.objectName.equals(castedOtherObject.objectName) && this.objectDescription.equals(castedOtherObject.objectDescription) && (this.defaultValue != null ? this.defaultValue.equals(castedOtherObject.defaultValue) : castedOtherObject.defaultValue == null) && (this.tag != null ? this.tag.equals(castedOtherObject.tag) : castedOtherObject.tag == null) && (this.comment != null ? this.comment.equals(castedOtherObject.comment) : castedOtherObject.comment == null) && this.isReady == castedOtherObject.isReady && this.isModified == castedOtherObject.isModified && this.isRequired == castedOtherObject.isRequired && (this.contextId != null ? this.contextId.equals(castedOtherObject.contextId) : castedOtherObject.contextId == null);
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + this.uniqueId;
        hash = 31 * hash + (this.objectName == null ? 0 : this.objectName.hashCode());
        hash = 31 * hash + (this.objectDescription == null ? 0 : this.objectDescription.hashCode());
        hash = 31 * hash + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        hash = 31 * hash + (this.comment == null ? 0 : this.comment.hashCode());
        hash = 31 * hash + (this.tag == null ? 0 : this.tag.hashCode());
        hash = 31 * hash + (this.contextId == null ? 0 : this.contextId.hashCode());
        hash = 31 * hash + new Boolean(this.isReady).hashCode();
        hash = 31 * hash + new Boolean(this.isRequired).hashCode();
        hash = 31 * hash + new Boolean(this.isModified).hashCode();
        hash = 31 * hash + (this.value == null ? 0 : this.value.hashCode());
        return hash;
    }

    @Override
    public void update(String updatedKey, String newValue) {
    }

    @Override
    public void register(IUpdateableListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregister(IUpdateableListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean setValue(String newValue) {
        if (this.value != null && this.value.equals(newValue)) {
            return true;
        }
        if (newValue != null) {
            this.value = newValue;
            this.isModified = true;
            this.notifyListeners();
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean setValue(String ... var1);

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getValue(int index) {
        return this.getValue();
    }

    @Override
    public abstract String[] getValues();

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
        if (this.value == null || this.value.isEmpty()) {
            this.value = this.defaultValue;
        }
    }

    @Override
    public abstract List<String> getAllowedValues();

    @Override
    public abstract void setAllowedValues(List<String> var1);

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    @Override
    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public void setSecret(boolean secret) {
        this.isSecret = secret;
    }

    @Override
    public abstract void update(IUpdateable var1);

    @Override
    public String getContext() {
        return this.contextId;
    }

    @Override
    public void setContext(String id) {
        this.contextId = id;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

