/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.january.DatasetException;
import org.eclipse.january.INameable;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.RunningAverage;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.SliceNDIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyMaths {
    private static final String DUPLICATE_AXIS_ERROR = "Axis arguments must be unique";
    private static final String TOO_MANY_AXES_ERROR = "Number of axes cannot be greater than the rank";
    protected static final Logger logger = LoggerFactory.getLogger(LazyMaths.class);

    private LazyMaths() {
    }

    private static int[] requireSortedAxes(ILazyDataset data, int[] axes) {
        int rank = data.getRank();
        if (axes == null || axes.length == 0) {
            axes = new int[rank];
            int i = 0;
            while (i < rank) {
                axes[i] = i;
                ++i;
            }
        } else {
            Arrays.sort(axes);
            if (rank < axes.length) {
                logger.error(TOO_MANY_AXES_ERROR);
                throw new IllegalArgumentException(TOO_MANY_AXES_ERROR);
            }
            int axisIndex = 0;
            while (axisIndex < axes.length) {
                if (axes.length > 1 && axisIndex > 0 && axes[axisIndex] == axes[axisIndex - 1]) {
                    logger.error(DUPLICATE_AXIS_ERROR);
                    throw new IllegalArgumentException(DUPLICATE_AXIS_ERROR);
                }
                axes[axisIndex] = ShapeUtils.checkAxis(rank, axes[axisIndex]);
                ++axisIndex;
            }
        }
        return axes;
    }

    private static Dataset maxmin(ILazyDataset data, MathOperation operation, int ... axes) throws DatasetException {
        axes = LazyMaths.requireSortedAxes(data, axes);
        int[] ignoreAxes = new int[data.getRank() - axes.length];
        int k = 0;
        int i = 0;
        while (i < data.getRank()) {
            if (Arrays.binarySearch(axes, i) < 0) {
                ignoreAxes[k++] = i;
            }
            ++i;
        }
        int[] oldShape = data.getShape();
        SliceND sa = new SliceND(oldShape);
        SliceNDIterator it = new SliceNDIterator(sa, ignoreAxes);
        INameable result = null;
        while (it.hasNext()) {
            SliceND currentSlice = it.getCurrentSlice();
            IDataset slice = data.getSlice(currentSlice);
            if (result == null) {
                result = DatasetUtils.convertToDataset(slice);
                continue;
            }
            operation.execute((IDataset)result, slice, (Dataset)result);
        }
        if (result != null) {
            result.setName(operation.getOperationName());
            result.squeeze();
        }
        return result;
    }

    public static Dataset max(ILazyDataset data, int ... axes) throws DatasetException {
        if (data instanceof Dataset) {
            Dataset tmp = (Dataset)data;
            axes = LazyMaths.requireSortedAxes(data, axes);
            int i = axes.length - 1;
            while (i >= 0) {
                tmp = tmp.max(axes[i], new boolean[0]);
                --i;
            }
            return tmp;
        }
        return LazyMaths.maxmin(data, MathOperation.MAX, axes);
    }

    public static Dataset min(ILazyDataset data, int ... axes) throws DatasetException {
        if (data instanceof Dataset) {
            Dataset tmp = (Dataset)data;
            axes = LazyMaths.requireSortedAxes(data, axes);
            int i = axes.length - 1;
            while (i >= 0) {
                tmp = tmp.min(axes[i], new boolean[0]);
                --i;
            }
            return tmp;
        }
        return LazyMaths.maxmin(data, MathOperation.MIN, axes);
    }

    public static Dataset sum(ILazyDataset data, int axis) throws DatasetException {
        if (data instanceof Dataset) {
            return ((Dataset)data).sum(axis, new boolean[0]);
        }
        int[][] sliceInfo = new int[3][];
        int[] shape = data.getShape();
        Dataset result = LazyMaths.prepareDataset(axis, shape, sliceInfo);
        int[] start = sliceInfo[0];
        int[] stop = sliceInfo[1];
        int[] step = sliceInfo[2];
        int length = shape[axis];
        int i = 0;
        while (i < length) {
            start[axis] = i;
            stop[axis] = i + 1;
            result.iadd(data.getSlice(start, stop, step));
            ++i;
        }
        result.setShape(ShapeUtils.squeezeShape(shape, axis));
        return result;
    }

    public static Dataset sum(ILazyDataset data, int ... ignoreAxes) throws DatasetException {
        return LazyMaths.sum(data, true, ignoreAxes);
    }

    public static Dataset sum(ILazyDataset data, boolean ignore, int ... axes) throws DatasetException {
        Arrays.sort(axes);
        ILazyDataset rv = data;
        if (ignore) {
            ArrayList<Integer> goodAxes = new ArrayList<Integer>();
            int i = 0;
            while (i < data.getRank()) {
                boolean found = false;
                int j = 0;
                while (j < axes.length) {
                    if (i == axes[j]) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    goodAxes.add(i);
                }
                ++i;
            }
            i = 0;
            while (i < goodAxes.size()) {
                rv = LazyMaths.sum(rv, (Integer)goodAxes.get(i) - i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < axes.length) {
                rv = LazyMaths.sum(rv, axes[i] - i);
                ++i;
            }
        }
        return DatasetUtils.sliceAndConvertLazyDataset(rv);
    }

    public static Dataset product(ILazyDataset data, int axis) throws DatasetException {
        int[][] sliceInfo = new int[3][];
        int[] shape = data.getShape();
        Dataset result = LazyMaths.prepareDataset(axis, shape, sliceInfo);
        result.fill(1);
        int[] start = sliceInfo[0];
        int[] stop = sliceInfo[1];
        int[] step = sliceInfo[2];
        int length = shape[axis];
        int i = 0;
        while (i < length) {
            start[axis] = i;
            stop[axis] = i + 1;
            result.imultiply(data.getSlice(start, stop, step));
            ++i;
        }
        result.setShape(ShapeUtils.squeezeShape(shape, axis));
        return result;
    }

    public static Dataset mean(int start, int stop, ILazyDataset data, int ... ignoreAxes) throws DatasetException {
        int[] shape = data.getShape();
        PositionIterator iter = new PositionIterator(shape, ignoreAxes);
        int[] pos = iter.getPos();
        boolean[] omit = iter.getOmit();
        int rank = shape.length;
        int[] st = new int[rank];
        Arrays.fill(st, 1);
        int[] end = new int[rank];
        RunningAverage av = null;
        int c = 0;
        while (iter.hasNext() && c < stop) {
            if (c++ < start) continue;
            int i = 0;
            while (i < rank) {
                end[i] = omit[i] ? shape[i] : pos[i] + 1;
                ++i;
            }
            IDataset ds = data.getSlice(pos, end, st);
            if (av == null) {
                av = new RunningAverage(ds);
                continue;
            }
            av.update(ds);
        }
        return av != null ? av.getCurrentAverage().squeeze() : null;
    }

    public static Dataset mean(ILazyDataset data, int ... ignoreAxes) throws DatasetException {
        return LazyMaths.mean(0, 0x7FFFFFFE, data, ignoreAxes);
    }

    private static Dataset prepareDataset(int axis, int[] shape, int[][] sliceInfo) {
        int rank = shape.length;
        axis = ShapeUtils.checkAxis(rank, axis);
        sliceInfo[0] = new int[rank];
        sliceInfo[1] = (int[])shape.clone();
        sliceInfo[2] = new int[rank];
        Arrays.fill(sliceInfo[2], 1);
        int[] nshape = (int[])shape.clone();
        nshape[axis] = 1;
        return DatasetFactory.zeros(nshape);
    }

    private static interface IMathOperation {
        public void execute(IDataset var1, IDataset var2, Dataset var3);
    }

    private static enum MathOperation implements IMathOperation
    {
        MAX(new IMathOperation(){

            @Override
            public void execute(IDataset a, IDataset b, Dataset c) {
                Maths.maximum(a, b, c);
            }
        }, "maximum"),
        MIN(new IMathOperation(){

            @Override
            public void execute(IDataset a, IDataset b, Dataset c) {
                Maths.minimum(a, b, c);
            }
        }, "minimum");

        private final IMathOperation operation;
        private final String operationName;

        private MathOperation(IMathOperation operation, String operationName) {
            this.operation = operation;
            this.operationName = operationName;
        }

        @Override
        public void execute(IDataset a, IDataset b, Dataset c) {
            this.operation.execute(a, b, c);
        }

        public String getOperationName() {
            return this.operationName;
        }
    }
}

