/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.CodeGeneration;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.ls.core.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.FixMessages;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.text.edits.TextEditGroup;

public abstract class AbstractSerialVersionOperation
extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
    protected static final String LONG_SUFFIX = "L";
    public static final long SERIAL_VALUE = 1L;
    protected static final String DEFAULT_EXPRESSION = "1L";
    protected static final String NAME_FIELD = "serialVersionUID";
    private final ASTNode[] fNodes;
    private final ICompilationUnit fUnit;

    protected AbstractSerialVersionOperation(ICompilationUnit unit, ASTNode[] node) {
        this.fUnit = unit;
        this.fNodes = node;
    }

    protected abstract boolean addInitializer(VariableDeclarationFragment var1, ASTNode var2);

    protected abstract void addLinkedPositions(ASTRewrite var1, VariableDeclarationFragment var2, LinkedProposalModel var3);

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel positionGroups) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        VariableDeclarationFragment fragment = null;
        int i = 0;
        while (i < this.fNodes.length) {
            ASTNode node = this.fNodes[i];
            AST ast = node.getAST();
            fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(NAME_FIELD));
            FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
            declaration.setType((Type)ast.newPrimitiveType(PrimitiveType.LONG));
            declaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 26));
            if (this.addInitializer(fragment, node)) {
                String comment;
                if (fragment.getInitializer() != null) {
                    TextEditGroup editGroup = this.createTextEditGroup(FixMessages.SerialVersion_group_description, cuRewrite);
                    if (node instanceof AbstractTypeDeclaration) {
                        rewrite.getListRewrite(node, ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty()).insertAt((ASTNode)declaration, 0, editGroup);
                    } else if (node instanceof AnonymousClassDeclaration) {
                        rewrite.getListRewrite(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)declaration, 0, editGroup);
                    } else if (node instanceof ParameterizedType) {
                        ClassInstanceCreation creation;
                        AnonymousClassDeclaration anonymous;
                        ParameterizedType type = (ParameterizedType)node;
                        ASTNode parent = type.getParent();
                        if (parent instanceof ClassInstanceCreation && (anonymous = (creation = (ClassInstanceCreation)parent).getAnonymousClassDeclaration()) != null) {
                            rewrite.getListRewrite((ASTNode)anonymous, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)declaration, 0, editGroup);
                        }
                    } else {
                        Assert.isTrue((boolean)false);
                    }
                    this.addLinkedPositions(rewrite, fragment, positionGroups);
                }
                if ((comment = CodeGeneration.getFieldComment(this.fUnit, declaration.getType().toString(), NAME_FIELD, "\n")) != null && comment.length() > 0 && !"/**\n *\n */\n".equals(comment)) {
                    Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
                    declaration.setJavadoc(doc);
                }
            }
            ++i;
        }
        if (fragment == null) {
            return;
        }
        positionGroups.setEndPosition(rewrite.track(fragment));
    }
}

