/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.handlers.BundleUtils;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceExecuteCommandHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;

public final class InitHandler {
    public static final String JAVA_LS_INITIALIZATION_JOBS = "java-ls-initialization-jobs";
    private static final String BUNDLES_KEY = "bundles";
    public static final String SETTINGS_KEY = "settings";
    private ProjectsManager projectsManager;
    private JavaClientConnection connection;
    private PreferenceManager preferenceManager;
    private static WorkspaceDiagnosticsHandler workspaceDiagnosticsHandler;

    public InitHandler(ProjectsManager manager, PreferenceManager preferenceManager, JavaClientConnection connection) {
        this.projectsManager = manager;
        this.connection = connection;
        this.preferenceManager = preferenceManager;
    }

    InitializeResult initialize(InitializeParams param) {
        JavaLanguageServerPlugin.logInfo("Initializing Java Language Server " + JavaLanguageServerPlugin.getVersion());
        if (param.getCapabilities() == null) {
            this.preferenceManager.updateClientPrefences(new ClientCapabilities());
        } else {
            this.preferenceManager.updateClientPrefences(param.getCapabilities());
        }
        Map<?, ?> initializationOptions = this.getInitializationOptions(param);
        ArrayList<IPath> rootPaths = new ArrayList<IPath>();
        Collection<String> workspaceFolders = this.getWorkspaceFolders(initializationOptions);
        if (workspaceFolders != null && !workspaceFolders.isEmpty()) {
            for (String uri : workspaceFolders) {
                IPath filePath = ResourceUtils.filePathFromURI(uri);
                if (filePath == null) continue;
                rootPaths.add(filePath);
            }
            this.preferenceManager.getClientPreferences().setWorkspaceFoldersSupported(true);
        } else {
            IPath filePath;
            String rootPath = param.getRootUri();
            if (rootPath == null && (rootPath = param.getRootPath()) != null) {
                JavaLanguageServerPlugin.logInfo("In LSP 3.0, InitializeParams.rootPath is deprecated in favour of InitializeParams.rootUri!");
            }
            if (rootPath != null && (filePath = ResourceUtils.filePathFromURI(rootPath)) != null) {
                rootPaths.add(filePath);
            }
        }
        if (rootPaths.isEmpty()) {
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            JavaLanguageServerPlugin.logInfo("No workspace folders or root uri was defined. Falling back on " + workspaceLocation);
            rootPaths.add(workspaceLocation);
        }
        if (initializationOptions instanceof Map && initializationOptions.get(SETTINGS_KEY) instanceof Map) {
            Object settings = initializationOptions.get(SETTINGS_KEY);
            Preferences prefs = Preferences.createFrom((Map)settings);
            this.preferenceManager.update(prefs);
        }
        this.triggerInitialization(rootPaths);
        this.addWorkspaceDiagnosticsHandler();
        Integer processId = param.getProcessId();
        if (processId != null) {
            JavaLanguageServerPlugin.getLanguageServer().setParentProcessId(processId.longValue());
        }
        try {
            Collection<String> bundleList = this.getBundleList(initializationOptions);
            BundleUtils.loadBundles(bundleList);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to load extension bundles ", e);
        }
        InitializeResult result = new InitializeResult();
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setCompletionProvider(new CompletionOptions(Boolean.TRUE, Arrays.asList(".", "@", "#")));
        if (!this.preferenceManager.getClientPreferences().isFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentFormattingProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isRangeFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentRangeFormattingProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isCodeLensDynamicRegistrationSupported()) {
            capabilities.setCodeLensProvider(new CodeLensOptions(true));
        }
        if (!this.preferenceManager.getClientPreferences().isSignatureHelpDynamicRegistrationSupported()) {
            capabilities.setSignatureHelpProvider(SignatureHelpHandler.createOptions());
        }
        if (!this.preferenceManager.getClientPreferences().isRenameDynamicRegistrationSupported()) {
            capabilities.setRenameProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isCodeActionDynamicRegistered()) {
            capabilities.setCodeActionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isExecuteCommandDynamicRegistrationSupported()) {
            Set<String> commands = WorkspaceExecuteCommandHandler.getCommands();
            capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(new ArrayList<String>(commands)));
        }
        if (!this.preferenceManager.getClientPreferences().isWorkspaceSymbolDynamicRegistered()) {
            capabilities.setWorkspaceSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            capabilities.setDocumentSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            capabilities.setDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            capabilities.setHoverProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isReferencesDynamicRegistered()) {
            capabilities.setReferencesProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDocumentHighlightDynamicRegistered()) {
            capabilities.setDocumentHighlightProvider(Boolean.TRUE);
        }
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setOpenClose(Boolean.TRUE);
        textDocumentSyncOptions.setSave(new SaveOptions(Boolean.TRUE));
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Incremental);
        if (this.preferenceManager.getClientPreferences().isWillSaveRegistered()) {
            textDocumentSyncOptions.setWillSave(Boolean.TRUE);
        }
        if (this.preferenceManager.getClientPreferences().isWillSaveWaitUntilRegistered()) {
            textDocumentSyncOptions.setWillSaveWaitUntil(Boolean.TRUE);
        }
        capabilities.setTextDocumentSync(textDocumentSyncOptions);
        result.setCapabilities(capabilities);
        return result;
    }

    private void triggerInitialization(final Collection<IPath> roots) {
        WorkspaceJob job = new WorkspaceJob("Initialize Workspace"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                InitHandler.this.connection.sendStatus(ServiceStatus.Starting, "Init...");
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)new ServerStatusMonitor(), (int)100);
                try {
                    InitHandler.this.projectsManager.setAutoBuilding(false);
                    InitHandler.this.projectsManager.initializeProjects(roots, (IProgressMonitor)subMonitor);
                    JavaLanguageServerPlugin.logInfo("Workspace initialized in " + (System.currentTimeMillis() - start) + "ms");
                    InitHandler.this.connection.sendStatus(ServiceStatus.Started, "Ready");
                }
                catch (OperationCanceledException e) {
                    InitHandler.this.connection.sendStatus(ServiceStatus.Error, "Initialization has been cancelled.");
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Initialization failed ", e);
                    InitHandler.this.connection.sendStatus(ServiceStatus.Error, e.getMessage());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return InitHandler.JAVA_LS_INITIALIZATION_JOBS.equals(family);
            }
        };
        job.setPriority(40);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private Map<?, ?> getInitializationOptions(InitializeParams params) {
        Object initializationOptions = params.getInitializationOptions();
        if (initializationOptions instanceof Map) {
            return (Map)initializationOptions;
        }
        return null;
    }

    private Collection<String> getWorkspaceFolders(Map<?, ?> initializationOptions) {
        Object folders;
        if (initializationOptions != null && (folders = initializationOptions.get("workspaceFolders")) instanceof Collection) {
            return (Collection)folders;
        }
        return null;
    }

    private Collection<String> getBundleList(Map<?, ?> initializationOptions) {
        Object bundleObject;
        if (initializationOptions != null && (bundleObject = initializationOptions.get(BUNDLES_KEY)) instanceof Collection) {
            return (Collection)bundleObject;
        }
        return null;
    }

    public static void removeWorkspaceDiagnosticsHandler() {
        if (workspaceDiagnosticsHandler != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceDiagnosticsHandler);
            workspaceDiagnosticsHandler = null;
        }
    }

    public void addWorkspaceDiagnosticsHandler() {
        InitHandler.removeWorkspaceDiagnosticsHandler();
        workspaceDiagnosticsHandler = new WorkspaceDiagnosticsHandler(this.connection, this.projectsManager);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceDiagnosticsHandler, 1);
    }

    private class ServerStatusMonitor
    extends NullProgressMonitor {
        private static final long DELAY = 200L;
        private double totalWork;
        private String subtask;
        private double progress;
        private long lastReport = 0L;

        private ServerStatusMonitor() {
        }

        public void beginTask(String task, int totalWork) {
            this.totalWork = totalWork;
            this.sendProgress();
        }

        public void subTask(String name) {
            this.subtask = name;
            this.sendProgress();
        }

        public void worked(int work) {
            this.progress += (double)work;
            this.sendProgress();
        }

        private void sendProgress() {
            long currentTime = System.currentTimeMillis();
            if (this.lastReport == 0L || currentTime - this.lastReport > 200L) {
                this.lastReport = currentTime;
                String message = this.subtask == null || this.subtask.length() == 0 ? "" : " - " + this.subtask;
                InitHandler.this.connection.sendStatus(ServiceStatus.Starting, String.format("%.0f%%  Starting Java Language Server %s", this.progress / this.totalWork * 100.0, message));
            }
        }
    }
}

