/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.ls.core.internal.handlers.MapFlattener;
import org.junit.Assert;
import org.junit.Test;

public class MapFlattenerTest {
    @Test
    public void testGetString() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("foo", "bar");
        HashMap<String, Object> middle = new HashMap<String, Object>();
        config.put("java", middle);
        middle.put("thing", "value");
        HashMap<String, String> bottom = new HashMap<String, String>();
        middle.put("bottom", bottom);
        bottom.put("another", "thing");
        Assert.assertNull((String)"default", (Object)MapFlattener.getString(config, (String)"missing"));
        Assert.assertEquals((Object)"default", (Object)MapFlattener.getString(config, (String)"missing", (String)"default"));
        Assert.assertEquals((Object)"bar", (Object)MapFlattener.getString(config, (String)"foo"));
        Assert.assertEquals((Object)"value", (Object)MapFlattener.getString(config, (String)"java.thing"));
        Assert.assertEquals((Object)"thing", (Object)MapFlattener.getString(config, (String)"java.bottom.another"));
    }

    @Test
    public void testGetInt() throws Exception {
        HashMap<String, Serializable> config = new HashMap<String, Serializable>();
        config.put("foo", Integer.valueOf(1));
        HashMap<String, Object> middle = new HashMap<String, Object>();
        config.put("java", middle);
        middle.put("nope", "not an int");
        HashMap<String, String> bottom = new HashMap<String, String>();
        middle.put("bottom", bottom);
        bottom.put("another", "3");
        Assert.assertEquals((long)0L, (long)MapFlattener.getInt(config, (String)"missing"));
        Assert.assertEquals((long)1L, (long)MapFlattener.getInt(config, (String)"foo"));
        Assert.assertEquals((long)2L, (long)MapFlattener.getInt(config, (String)"java.nope", (int)2));
        Assert.assertEquals((long)3L, (long)MapFlattener.getInt(config, (String)"java.bottom.another"));
    }

    @Test
    public void testGetBoolean() throws Exception {
        HashMap<String, Serializable> config = new HashMap<String, Serializable>();
        config.put("foo", Boolean.valueOf(true));
        HashMap<String, Object> middle = new HashMap<String, Object>();
        config.put("java", middle);
        middle.put("thing", "TRUE");
        HashMap<String, Boolean> bottom = new HashMap<String, Boolean>();
        middle.put("bottom", bottom);
        bottom.put("another", true);
        Assert.assertTrue((boolean)MapFlattener.getBoolean(config, (String)"foo"));
        Assert.assertTrue((boolean)MapFlattener.getBoolean(config, (String)"java.thing"));
        Assert.assertTrue((boolean)MapFlattener.getBoolean(config, (String)"java.default", (boolean)true));
        Assert.assertFalse((boolean)MapFlattener.getBoolean(config, (String)"java.missing"));
        Assert.assertTrue((boolean)MapFlattener.getBoolean(config, (String)"java.bottom.another"));
    }

    @Test
    public void testGetList() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("foo", "['a', 'b']");
        HashMap middle = new HashMap();
        config.put("java", middle);
        HashMap<String, String> bottom = new HashMap<String, String>();
        middle.put("bottom", bottom);
        bottom.put("another", "c, d");
        List foo = MapFlattener.getList(config, (String)"foo");
        Assert.assertNotNull((Object)foo);
        Assert.assertEquals((Object)"a", foo.get(0));
        Assert.assertEquals((Object)"b", foo.get(1));
        List nope = MapFlattener.getList(config, (String)"java");
        Assert.assertNull((Object)nope);
        ArrayList def = new ArrayList();
        Assert.assertSame(def, (Object)MapFlattener.getList(config, (String)"java", def));
        List bar = MapFlattener.getList(config, (String)"java.bottom.another");
        Assert.assertNotNull((Object)bar);
        Assert.assertEquals((Object)"c", bar.get(0));
        Assert.assertEquals((Object)"d", bar.get(1));
    }

    @Test
    public void testGetValue() throws Exception {
        HashMap<String, Serializable> config = new HashMap<String, Serializable>();
        config.put("foo", Integer.valueOf(1));
        HashMap middle = new HashMap();
        config.put("java", middle);
        HashMap<String, Integer> bottom = new HashMap<String, Integer>();
        middle.put("bottom", bottom);
        bottom.put("another", 2);
        Assert.assertSame(bottom, (Object)MapFlattener.getValue(config, (String)"java.bottom"));
    }
}

