/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.ls.core.internal.Util;
import org.eclipse.jdt.ls.core.internal.javadoc.AbstractJavadocConverterTest;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2MarkdownConverter;
import org.junit.Assert;
import org.junit.Test;

public class JavaDoc2MarkdownConverterTest
extends AbstractJavadocConverterTest {
    private static final String MARKDOWN_0 = "This Javadoc contains some `code`, a link to `IOException` and a table\n\n    | header 1 | header 2 |\n    | -------- | -------- |\n    | data 1   | data 2   |\n\n\nliterally <b>literal</b> and now a list:\n\n *  **Coffee**\n    \n     *  Mocha\n     *  Latte\n *  Tea\n    \n     *  Darjeeling\n     *  Early Grey\n\n *  **Parameters:**\n    \n     *  **param1** the first parameter\n     *  **param2** the 2nd parameter\n     *  **param3**\n *  **Returns:**\n    \n     *  some kind of result\n *  **Throws:**\n    \n     *  NastyException a nasty exception\n     *  IOException another nasty exception\n *  **Author:**\n    \n     *  [Ralf](mailto:foo@bar.com)\n     *  [Andrew](mailto:bar@foo.com)\n *  **Since:**\n    \n     *  1.0\n     *  0\n *  @unknown\n    \n     *  unknown tag\n *  @unknown\n    \n     *  another unknown tag";

    @Test
    public void testBoundaries() throws IOException {
        Assert.assertTrue((boolean)new JavaDoc2MarkdownConverter("").getAsString().isEmpty());
        Assert.assertNull((Object)new JavaDoc2MarkdownConverter(null).getAsString());
        Assert.assertNull((Object)new JavaDoc2MarkdownConverter(null).getAsReader());
        Assert.assertNull((Object)new JavaDoc2MarkdownConverter(null).getAsString());
        Assert.assertNull((Object)new JavaDoc2MarkdownConverter(null).getAsReader());
    }

    @Test
    public void testGetAsString() throws IOException {
        String result = new JavaDoc2MarkdownConverter("This Javadoc  contains some <code> code </code>, a link to {@link IOException} and a table \n<table>\n  <thead><tr><th>header 1</th><th>header 2</th></tr></thead>\n  <tbody><tr><td>data 1</td><td>data 2</td></tr></tbody>\n  </table>\n<br> literally {@literal <b>literal</b>} and now a list:\n  <ul><li><b>Coffee</b>   <ul>    <li>Mocha</li>    <li>Latte</li>   </ul>  </li>  <li>Tea   <ul>    <li>Darjeeling</li>    <li>Early Grey</li>   </ul>  </li></ul>\n @param param1 the first parameter\n @param param2 \n the 2nd parameter\n @param param3 \n @since 1.0\n @since .0\n @author <a href=\"mailto:foo@bar.com\">Ralf</a>\n @author <a href=\"mailto:bar@foo.com\">Andrew</a>\n @exception NastyException a\n nasty exception\n @throws \nIOException another nasty exception\n @return some kind of result\n @unknown unknown tag\n @unknown another unknown tag\n").getAsString();
        Assert.assertEquals((Object)Util.convertToIndependentLineDelimiter(MARKDOWN_0), (Object)Util.convertToIndependentLineDelimiter(result));
    }

    @Test
    public void testGetAsReader() throws IOException {
        JavaDoc2MarkdownConverter converter = new JavaDoc2MarkdownConverter("This Javadoc  contains some <code> code </code>, a link to {@link IOException} and a table \n<table>\n  <thead><tr><th>header 1</th><th>header 2</th></tr></thead>\n  <tbody><tr><td>data 1</td><td>data 2</td></tr></tbody>\n  </table>\n<br> literally {@literal <b>literal</b>} and now a list:\n  <ul><li><b>Coffee</b>   <ul>    <li>Mocha</li>    <li>Latte</li>   </ul>  </li>  <li>Tea   <ul>    <li>Darjeeling</li>    <li>Early Grey</li>   </ul>  </li></ul>\n @param param1 the first parameter\n @param param2 \n the 2nd parameter\n @param param3 \n @since 1.0\n @since .0\n @author <a href=\"mailto:foo@bar.com\">Ralf</a>\n @author <a href=\"mailto:bar@foo.com\">Andrew</a>\n @exception NastyException a\n nasty exception\n @throws \nIOException another nasty exception\n @return some kind of result\n @unknown unknown tag\n @unknown another unknown tag\n");
        Reader reader1 = converter.getAsReader();
        Reader reader2 = converter.getAsReader();
        Assert.assertNotSame((Object)reader1, (Object)reader2);
    }
}

