/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.core.GavLabel;
import org.eclipse.jkube.kit.build.service.docker.ArchiveService;
import org.eclipse.jkube.kit.build.service.docker.BuildService;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.RunService;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.ServiceHubFactory;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.ExecException;
import org.eclipse.jkube.kit.build.service.docker.access.PortMapping;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogDispatcher;
import org.eclipse.jkube.kit.build.service.docker.helper.StartContainerExecutor;
import org.eclipse.jkube.kit.build.service.docker.helper.Task;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.RunImageConfiguration;
import org.eclipse.jkube.kit.config.image.WaitConfiguration;
import org.eclipse.jkube.kit.config.image.WatchImageConfiguration;
import org.eclipse.jkube.kit.config.image.WatchMode;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;

public class WatchService {
    private final ArchiveService archiveService;
    private final BuildService buildService;
    private final DockerAccess dockerAccess;
    private final QueryService queryService;
    private final RunService runService;
    private final KitLogger log;

    public WatchService(ArchiveService archiveService, BuildService buildService, DockerAccess dockerAccess, QueryService queryService, RunService runService, KitLogger log) {
        this.archiveService = archiveService;
        this.buildService = buildService;
        this.dockerAccess = dockerAccess;
        this.queryService = queryService;
        this.runService = runService;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void watch(WatchContext context, JKubeConfiguration buildContext, List<ImageConfiguration> images) throws IOException {
        ScheduledExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadScheduledExecutor();
            for (ImageConfiguration imageConfig : this.runService.getImagesConfigsInOrder(this.queryService, images)) {
                String imageId = this.queryService.getImageId(imageConfig.getName());
                String containerId = this.runService.lookupContainer(imageConfig.getName());
                ImageWatcher watcher = new ImageWatcher(imageConfig, context, imageId, containerId);
                long interval = watcher.getInterval();
                WatchMode watchMode = watcher.getWatchMode(imageConfig);
                this.log.info("Watching %s %s", new Object[]{imageConfig.getName(), watchMode != null ? " using " + watchMode.getDescription() : ""});
                ArrayList<String> tasks = new ArrayList<String>();
                if (imageConfig.getBuildConfiguration() != null && imageConfig.getBuildConfiguration().getAssembly() != null) {
                    if (watcher.isCopy()) {
                        String containerBaseDir = imageConfig.getBuildConfiguration().getAssembly().getTargetDir();
                        this.schedule(executor, this.createCopyWatchTask(watcher, context.getBuildContext(), containerBaseDir), interval);
                        tasks.add("copying artifacts");
                    }
                    if (watcher.isBuild()) {
                        this.schedule(executor, this.createBuildWatchTask(watcher, context.getBuildContext(), watchMode == WatchMode.both, buildContext), interval);
                        tasks.add("rebuilding");
                    }
                }
                if (watcher.isRun() && watcher.getContainerId() != null) {
                    this.schedule(executor, this.createRestartWatchTask(watcher), interval);
                    tasks.add("restarting");
                }
                if (tasks.isEmpty()) continue;
                this.log.info("%s: Watch for %s", new Object[]{imageConfig.getDescription(), String.join((CharSequence)" and ", tasks)});
            }
            this.log.info("Waiting ...", new Object[0]);
            if (!context.isKeepRunning()) {
                this.runService.addShutdownHookForStoppingContainers(context.isKeepContainer(), context.isRemoveVolumes(), context.isAutoCreateCustomNetworks());
            }
            this.wait();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
            Thread.currentThread().interrupt();
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private void schedule(ScheduledExecutorService executor, Runnable runnable, long interval) {
        executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private Runnable createCopyWatchTask(final ImageWatcher watcher, final JKubeConfiguration jKubeConfiguration, final String containerBaseDir) throws IOException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, jKubeConfiguration);
        return new Runnable(){

            @Override
            public void run() {
                List entries = files.getUpdatedEntriesAndRefresh();
                if (!entries.isEmpty()) {
                    try {
                        WatchService.this.log.info("%s: Assembly changed. Copying changed files to container ...", new Object[]{imageConfig.getDescription()});
                        File changedFilesArchive = WatchService.this.archiveService.createChangedFilesArchive(entries, files.getAssemblyDirectory(), imageConfig.getName(), jKubeConfiguration);
                        WatchService.this.dockerAccess.copyArchive(watcher.getContainerId(), changedFilesArchive, containerBaseDir);
                        WatchService.this.callPostExec(watcher);
                    }
                    catch (IOException | ExecException e) {
                        WatchService.this.log.error("%s: Error when copying files to container %s: %s", new Object[]{imageConfig.getDescription(), watcher.getContainerId(), e.getMessage()});
                    }
                }
            }
        };
    }

    private void callPostExec(ImageWatcher watcher) throws DockerAccessException, ExecException {
        if (watcher.getPostExec() != null) {
            String containerId = watcher.getContainerId();
            this.runService.execInContainer(containerId, watcher.getPostExec(), watcher.getImageConfiguration());
        }
    }

    private Runnable createBuildWatchTask(final ImageWatcher watcher, JKubeConfiguration mojoParameters, final boolean doRestart, final JKubeConfiguration buildContext) throws IOException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, mojoParameters);
        if (files.isEmpty()) {
            this.log.error("No assembly files for %s. Are you sure you invoked together with the `package` goal?", new Object[]{imageConfig.getDescription()});
            throw new IOException("No files to watch found for " + imageConfig);
        }
        return new Runnable(){

            @Override
            public void run() {
                List entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && !entries.isEmpty()) {
                    try {
                        WatchService.this.log.info("%s: Assembly changed. Rebuild ...", new Object[]{imageConfig.getDescription()});
                        if (watcher.getWatchContext().getImageCustomizer() != null) {
                            WatchService.this.log.info("%s: Customizing the image ...", new Object[]{imageConfig.getDescription()});
                            watcher.getWatchContext().getImageCustomizer().execute(imageConfig);
                        }
                        WatchService.this.buildService.buildImage(imageConfig, null, buildContext);
                        String name = imageConfig.getName();
                        watcher.setImageId(WatchService.this.queryService.getImageId(name));
                        if (doRestart) {
                            WatchService.this.restartContainer(watcher);
                        }
                    }
                    catch (Exception e) {
                        WatchService.this.log.error("%s: Error when rebuilding - %s", new Object[]{imageConfig.getDescription(), e});
                    }
                }
            }
        };
    }

    private Runnable createRestartWatchTask(final ImageWatcher watcher) {
        final String imageName = watcher.getImageName();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String currentImageId = WatchService.this.queryService.getImageId(imageName);
                    String oldValue = watcher.getAndSetImageId(currentImageId);
                    if (!currentImageId.equals(oldValue)) {
                        WatchService.this.restartContainer(watcher);
                    }
                }
                catch (Exception e) {
                    WatchService.this.log.warn("%s: Error when restarting image - %s", new Object[]{watcher.getImageConfiguration().getDescription(), e});
                }
            }
        };
    }

    private void restartContainer(ImageWatcher watcher) throws Exception {
        Task<ImageWatcher> restarter = watcher.getWatchContext().getContainerRestarter();
        if (restarter == null) {
            restarter = this.defaultContainerRestartTask();
        }
        restarter.execute(watcher);
    }

    private Task<ImageWatcher> defaultContainerRestartTask() {
        return watcher -> {
            ImageConfiguration imageConfig = watcher.getImageConfiguration();
            PortMapping mappedPorts = this.runService.createPortMapping(imageConfig.getRunConfiguration(), watcher.getWatchContext().getBuildContext().getProject().getProperties());
            String id = watcher.getContainerId();
            String optionalPreStop = this.getPreStopCommand(imageConfig);
            if (optionalPreStop != null) {
                this.runService.execInContainer(id, optionalPreStop, watcher.getImageConfiguration());
            }
            this.runService.stopPreviouslyStartedContainer(id, false, false);
            StartContainerExecutor helper = StartContainerExecutor.builder().dispatcher(((ImageWatcher)watcher).watchContext.dispatcher).follow(((ImageWatcher)watcher).watchContext.follow).log(this.log).portMapping(mappedPorts).gavLabel(((ImageWatcher)watcher).watchContext.getGavLabel()).projectProperties(((ImageWatcher)watcher).watchContext.buildContext.getProject().getProperties()).basedir(((ImageWatcher)watcher).watchContext.buildContext.getProject().getBaseDirectory()).imageConfig(imageConfig).hub(((ImageWatcher)watcher).watchContext.hub).logOutputSpecFactory(((ImageWatcher)watcher).watchContext.serviceHubFactory.getLogOutputSpecFactory()).showLogs(((ImageWatcher)watcher).watchContext.showLogs).containerNamePattern(((ImageWatcher)watcher).watchContext.containerNamePattern).buildDate(((ImageWatcher)watcher).watchContext.buildTimestamp).build();
            String containerId = helper.startContainers();
            watcher.setContainerId(containerId);
        };
    }

    private String getPreStopCommand(ImageConfiguration imageConfig) {
        return Optional.ofNullable(imageConfig.getRunConfiguration()).map(RunImageConfiguration::getWait).map(WaitConfiguration::getExec).map(WaitConfiguration.ExecConfiguration::getPreStop).orElse(null);
    }

    public static class WatchContext
    implements Serializable {
        private JKubeConfiguration buildContext;
        private WatchMode watchMode;
        private int watchInterval;
        private boolean keepRunning;
        private String watchPostGoal;
        private String watchPostExec;
        private GavLabel gavLabel;
        private boolean keepContainer;
        private boolean removeVolumes;
        private boolean autoCreateCustomNetworks;
        private Task<ImageConfiguration> imageCustomizer;
        private Task<ImageWatcher> containerRestarter;
        private transient ServiceHub hub;
        private transient ServiceHubFactory serviceHubFactory;
        private transient LogDispatcher dispatcher;
        private boolean follow;
        private String showLogs;
        private Date buildTimestamp;
        private String containerNamePattern;

        public static WatchContextBuilder builder() {
            return new WatchContextBuilder();
        }

        public WatchContextBuilder toBuilder() {
            return new WatchContextBuilder().buildContext(this.buildContext).watchMode(this.watchMode).watchInterval(this.watchInterval).keepRunning(this.keepRunning).watchPostGoal(this.watchPostGoal).watchPostExec(this.watchPostExec).gavLabel(this.gavLabel).keepContainer(this.keepContainer).removeVolumes(this.removeVolumes).autoCreateCustomNetworks(this.autoCreateCustomNetworks).imageCustomizer(this.imageCustomizer).containerRestarter(this.containerRestarter).hub(this.hub).serviceHubFactory(this.serviceHubFactory).dispatcher(this.dispatcher).follow(this.follow).showLogs(this.showLogs).buildTimestamp(this.buildTimestamp).containerNamePattern(this.containerNamePattern);
        }

        public WatchContext(JKubeConfiguration buildContext, WatchMode watchMode, int watchInterval, boolean keepRunning, String watchPostGoal, String watchPostExec, GavLabel gavLabel, boolean keepContainer, boolean removeVolumes, boolean autoCreateCustomNetworks, Task<ImageConfiguration> imageCustomizer, Task<ImageWatcher> containerRestarter, ServiceHub hub, ServiceHubFactory serviceHubFactory, LogDispatcher dispatcher, boolean follow, String showLogs, Date buildTimestamp, String containerNamePattern) {
            this.buildContext = buildContext;
            this.watchMode = watchMode;
            this.watchInterval = watchInterval;
            this.keepRunning = keepRunning;
            this.watchPostGoal = watchPostGoal;
            this.watchPostExec = watchPostExec;
            this.gavLabel = gavLabel;
            this.keepContainer = keepContainer;
            this.removeVolumes = removeVolumes;
            this.autoCreateCustomNetworks = autoCreateCustomNetworks;
            this.imageCustomizer = imageCustomizer;
            this.containerRestarter = containerRestarter;
            this.hub = hub;
            this.serviceHubFactory = serviceHubFactory;
            this.dispatcher = dispatcher;
            this.follow = follow;
            this.showLogs = showLogs;
            this.buildTimestamp = buildTimestamp;
            this.containerNamePattern = containerNamePattern;
        }

        public WatchContext() {
        }

        public JKubeConfiguration getBuildContext() {
            return this.buildContext;
        }

        public WatchMode getWatchMode() {
            return this.watchMode;
        }

        public int getWatchInterval() {
            return this.watchInterval;
        }

        public boolean isKeepRunning() {
            return this.keepRunning;
        }

        public String getWatchPostGoal() {
            return this.watchPostGoal;
        }

        public String getWatchPostExec() {
            return this.watchPostExec;
        }

        public GavLabel getGavLabel() {
            return this.gavLabel;
        }

        public boolean isKeepContainer() {
            return this.keepContainer;
        }

        public boolean isRemoveVolumes() {
            return this.removeVolumes;
        }

        public boolean isAutoCreateCustomNetworks() {
            return this.autoCreateCustomNetworks;
        }

        public Task<ImageConfiguration> getImageCustomizer() {
            return this.imageCustomizer;
        }

        public Task<ImageWatcher> getContainerRestarter() {
            return this.containerRestarter;
        }

        public ServiceHub getHub() {
            return this.hub;
        }

        public ServiceHubFactory getServiceHubFactory() {
            return this.serviceHubFactory;
        }

        public LogDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public boolean isFollow() {
            return this.follow;
        }

        public String getShowLogs() {
            return this.showLogs;
        }

        public Date getBuildTimestamp() {
            return this.buildTimestamp;
        }

        public String getContainerNamePattern() {
            return this.containerNamePattern;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WatchContext)) {
                return false;
            }
            WatchContext other = (WatchContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JKubeConfiguration this$buildContext = this.getBuildContext();
            JKubeConfiguration other$buildContext = other.getBuildContext();
            if (this$buildContext == null ? other$buildContext != null : !this$buildContext.equals(other$buildContext)) {
                return false;
            }
            WatchMode this$watchMode = this.getWatchMode();
            WatchMode other$watchMode = other.getWatchMode();
            if (this$watchMode == null ? other$watchMode != null : !this$watchMode.equals(other$watchMode)) {
                return false;
            }
            if (this.getWatchInterval() != other.getWatchInterval()) {
                return false;
            }
            if (this.isKeepRunning() != other.isKeepRunning()) {
                return false;
            }
            String this$watchPostGoal = this.getWatchPostGoal();
            String other$watchPostGoal = other.getWatchPostGoal();
            if (this$watchPostGoal == null ? other$watchPostGoal != null : !this$watchPostGoal.equals(other$watchPostGoal)) {
                return false;
            }
            String this$watchPostExec = this.getWatchPostExec();
            String other$watchPostExec = other.getWatchPostExec();
            if (this$watchPostExec == null ? other$watchPostExec != null : !this$watchPostExec.equals(other$watchPostExec)) {
                return false;
            }
            GavLabel this$gavLabel = this.getGavLabel();
            GavLabel other$gavLabel = other.getGavLabel();
            if (this$gavLabel == null ? other$gavLabel != null : !((Object)this$gavLabel).equals(other$gavLabel)) {
                return false;
            }
            if (this.isKeepContainer() != other.isKeepContainer()) {
                return false;
            }
            if (this.isRemoveVolumes() != other.isRemoveVolumes()) {
                return false;
            }
            if (this.isAutoCreateCustomNetworks() != other.isAutoCreateCustomNetworks()) {
                return false;
            }
            Task<ImageConfiguration> this$imageCustomizer = this.getImageCustomizer();
            Task<ImageConfiguration> other$imageCustomizer = other.getImageCustomizer();
            if (this$imageCustomizer == null ? other$imageCustomizer != null : !this$imageCustomizer.equals(other$imageCustomizer)) {
                return false;
            }
            Task<ImageWatcher> this$containerRestarter = this.getContainerRestarter();
            Task<ImageWatcher> other$containerRestarter = other.getContainerRestarter();
            if (this$containerRestarter == null ? other$containerRestarter != null : !this$containerRestarter.equals(other$containerRestarter)) {
                return false;
            }
            if (this.isFollow() != other.isFollow()) {
                return false;
            }
            String this$showLogs = this.getShowLogs();
            String other$showLogs = other.getShowLogs();
            if (this$showLogs == null ? other$showLogs != null : !this$showLogs.equals(other$showLogs)) {
                return false;
            }
            Date this$buildTimestamp = this.getBuildTimestamp();
            Date other$buildTimestamp = other.getBuildTimestamp();
            if (this$buildTimestamp == null ? other$buildTimestamp != null : !((Object)this$buildTimestamp).equals(other$buildTimestamp)) {
                return false;
            }
            String this$containerNamePattern = this.getContainerNamePattern();
            String other$containerNamePattern = other.getContainerNamePattern();
            return !(this$containerNamePattern == null ? other$containerNamePattern != null : !this$containerNamePattern.equals(other$containerNamePattern));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WatchContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JKubeConfiguration $buildContext = this.getBuildContext();
            result = result * 59 + ($buildContext == null ? 43 : $buildContext.hashCode());
            WatchMode $watchMode = this.getWatchMode();
            result = result * 59 + ($watchMode == null ? 43 : $watchMode.hashCode());
            result = result * 59 + this.getWatchInterval();
            result = result * 59 + (this.isKeepRunning() ? 79 : 97);
            String $watchPostGoal = this.getWatchPostGoal();
            result = result * 59 + ($watchPostGoal == null ? 43 : $watchPostGoal.hashCode());
            String $watchPostExec = this.getWatchPostExec();
            result = result * 59 + ($watchPostExec == null ? 43 : $watchPostExec.hashCode());
            GavLabel $gavLabel = this.getGavLabel();
            result = result * 59 + ($gavLabel == null ? 43 : ((Object)$gavLabel).hashCode());
            result = result * 59 + (this.isKeepContainer() ? 79 : 97);
            result = result * 59 + (this.isRemoveVolumes() ? 79 : 97);
            result = result * 59 + (this.isAutoCreateCustomNetworks() ? 79 : 97);
            Task<ImageConfiguration> $imageCustomizer = this.getImageCustomizer();
            result = result * 59 + ($imageCustomizer == null ? 43 : $imageCustomizer.hashCode());
            Task<ImageWatcher> $containerRestarter = this.getContainerRestarter();
            result = result * 59 + ($containerRestarter == null ? 43 : $containerRestarter.hashCode());
            result = result * 59 + (this.isFollow() ? 79 : 97);
            String $showLogs = this.getShowLogs();
            result = result * 59 + ($showLogs == null ? 43 : $showLogs.hashCode());
            Date $buildTimestamp = this.getBuildTimestamp();
            result = result * 59 + ($buildTimestamp == null ? 43 : ((Object)$buildTimestamp).hashCode());
            String $containerNamePattern = this.getContainerNamePattern();
            result = result * 59 + ($containerNamePattern == null ? 43 : $containerNamePattern.hashCode());
            return result;
        }

        public static class WatchContextBuilder {
            private JKubeConfiguration buildContext;
            private WatchMode watchMode;
            private int watchInterval;
            private boolean keepRunning;
            private String watchPostGoal;
            private String watchPostExec;
            private GavLabel gavLabel;
            private boolean keepContainer;
            private boolean removeVolumes;
            private boolean autoCreateCustomNetworks;
            private Task<ImageConfiguration> imageCustomizer;
            private Task<ImageWatcher> containerRestarter;
            private ServiceHub hub;
            private ServiceHubFactory serviceHubFactory;
            private LogDispatcher dispatcher;
            private boolean follow;
            private String showLogs;
            private Date buildTimestamp;
            private String containerNamePattern;

            WatchContextBuilder() {
            }

            public WatchContextBuilder buildContext(JKubeConfiguration buildContext) {
                this.buildContext = buildContext;
                return this;
            }

            public WatchContextBuilder watchMode(WatchMode watchMode) {
                this.watchMode = watchMode;
                return this;
            }

            public WatchContextBuilder watchInterval(int watchInterval) {
                this.watchInterval = watchInterval;
                return this;
            }

            public WatchContextBuilder keepRunning(boolean keepRunning) {
                this.keepRunning = keepRunning;
                return this;
            }

            public WatchContextBuilder watchPostGoal(String watchPostGoal) {
                this.watchPostGoal = watchPostGoal;
                return this;
            }

            public WatchContextBuilder watchPostExec(String watchPostExec) {
                this.watchPostExec = watchPostExec;
                return this;
            }

            public WatchContextBuilder gavLabel(GavLabel gavLabel) {
                this.gavLabel = gavLabel;
                return this;
            }

            public WatchContextBuilder keepContainer(boolean keepContainer) {
                this.keepContainer = keepContainer;
                return this;
            }

            public WatchContextBuilder removeVolumes(boolean removeVolumes) {
                this.removeVolumes = removeVolumes;
                return this;
            }

            public WatchContextBuilder autoCreateCustomNetworks(boolean autoCreateCustomNetworks) {
                this.autoCreateCustomNetworks = autoCreateCustomNetworks;
                return this;
            }

            public WatchContextBuilder imageCustomizer(Task<ImageConfiguration> imageCustomizer) {
                this.imageCustomizer = imageCustomizer;
                return this;
            }

            public WatchContextBuilder containerRestarter(Task<ImageWatcher> containerRestarter) {
                this.containerRestarter = containerRestarter;
                return this;
            }

            public WatchContextBuilder hub(ServiceHub hub) {
                this.hub = hub;
                return this;
            }

            public WatchContextBuilder serviceHubFactory(ServiceHubFactory serviceHubFactory) {
                this.serviceHubFactory = serviceHubFactory;
                return this;
            }

            public WatchContextBuilder dispatcher(LogDispatcher dispatcher) {
                this.dispatcher = dispatcher;
                return this;
            }

            public WatchContextBuilder follow(boolean follow) {
                this.follow = follow;
                return this;
            }

            public WatchContextBuilder showLogs(String showLogs) {
                this.showLogs = showLogs;
                return this;
            }

            public WatchContextBuilder buildTimestamp(Date buildTimestamp) {
                this.buildTimestamp = buildTimestamp;
                return this;
            }

            public WatchContextBuilder containerNamePattern(String containerNamePattern) {
                this.containerNamePattern = containerNamePattern;
                return this;
            }

            public WatchContext build() {
                return new WatchContext(this.buildContext, this.watchMode, this.watchInterval, this.keepRunning, this.watchPostGoal, this.watchPostExec, this.gavLabel, this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, this.imageCustomizer, this.containerRestarter, this.hub, this.serviceHubFactory, this.dispatcher, this.follow, this.showLogs, this.buildTimestamp, this.containerNamePattern);
            }

            public String toString() {
                return "WatchService.WatchContext.WatchContextBuilder(buildContext=" + this.buildContext + ", watchMode=" + this.watchMode + ", watchInterval=" + this.watchInterval + ", keepRunning=" + this.keepRunning + ", watchPostGoal=" + this.watchPostGoal + ", watchPostExec=" + this.watchPostExec + ", gavLabel=" + this.gavLabel + ", keepContainer=" + this.keepContainer + ", removeVolumes=" + this.removeVolumes + ", autoCreateCustomNetworks=" + this.autoCreateCustomNetworks + ", imageCustomizer=" + this.imageCustomizer + ", containerRestarter=" + this.containerRestarter + ", hub=" + this.hub + ", serviceHubFactory=" + this.serviceHubFactory + ", dispatcher=" + this.dispatcher + ", follow=" + this.follow + ", showLogs=" + this.showLogs + ", buildTimestamp=" + this.buildTimestamp + ", containerNamePattern=" + this.containerNamePattern + ")";
            }
        }
    }

    public class ImageWatcher {
        private final ImageConfiguration imageConfig;
        private final WatchContext watchContext;
        private final WatchMode mode;
        private final AtomicReference<String> imageIdRef;
        private final AtomicReference<String> containerIdRef;
        private final long interval;
        private final String postGoal;
        private String postExec;

        public ImageWatcher(ImageConfiguration imageConfig, WatchContext watchContext, String imageId, String containerIdRef) {
            this.imageConfig = imageConfig;
            this.watchContext = watchContext;
            this.imageIdRef = new AtomicReference<String>(imageId);
            this.containerIdRef = new AtomicReference<String>(containerIdRef);
            this.interval = this.getWatchInterval(imageConfig);
            this.mode = this.getWatchMode(imageConfig);
            this.postGoal = this.getPostGoal(imageConfig);
            this.postExec = this.getPostExec(imageConfig);
        }

        public String getContainerId() {
            return this.containerIdRef.get();
        }

        public long getInterval() {
            return this.interval;
        }

        public String getPostGoal() {
            return this.postGoal;
        }

        public boolean isCopy() {
            return this.mode.isCopy();
        }

        public boolean isBuild() {
            return this.mode.isBuild();
        }

        public boolean isRun() {
            return this.mode.isRun();
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public void setImageId(String imageId) {
            this.imageIdRef.set(imageId);
        }

        public void setContainerId(String containerId) {
            this.containerIdRef.set(containerId);
        }

        public String getImageName() {
            return this.imageConfig.getName();
        }

        public String getAndSetImageId(String currentImageId) {
            return this.imageIdRef.getAndSet(currentImageId);
        }

        public String getPostExec() {
            return this.postExec;
        }

        public WatchContext getWatchContext() {
            return this.watchContext;
        }

        private int getWatchInterval(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            int interval = watchConfig != null ? watchConfig.getInterval() : this.watchContext.getWatchInterval();
            return interval < 100 ? 100 : interval;
        }

        private String getPostExec(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostExec() != null ? watchConfig.getPostExec() : this.watchContext.getWatchPostExec();
        }

        private String getPostGoal(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostGoal() != null ? watchConfig.getPostGoal() : this.watchContext.getWatchPostGoal();
        }

        private WatchMode getWatchMode(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            WatchMode mode = watchConfig != null ? watchConfig.getMode() : null;
            return mode != null ? mode : this.watchContext.getWatchMode();
        }
    }
}

