/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.doc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;

public class ClasspathIncludeProcessor
extends IncludeProcessor {
    public boolean handles(String target) {
        return target.startsWith("classpath:");
    }

    public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
        List<String> content = this.readContent(target);
        for (int i = content.size() - 1; i >= 0; --i) {
            String line = content.get(i);
            if (line.trim().equals("")) {
                line = " ";
            }
            reader.push_include(line, target, target, 1, attributes);
        }
    }

    private List<String> readContent(String target) {
        String resourcePath = target.substring("classpath:".length());
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);
        if (is == null) {
            throw new IllegalArgumentException("No resource " + target + " could be found in the classpath");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return lines;
    }
}

