/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.JsonFactory;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class CredentialHelperClient {
    static final String SECRET_KEY = "Secret";
    static final String USERNAME_KEY = "Username";
    static final String TOKEN_USERNAME = "<token>";
    private final String credentialHelperName;
    private final KitLogger log;

    public CredentialHelperClient(KitLogger log, String credentialsStore) {
        this.log = log;
        this.credentialHelperName = "docker-credential-" + credentialsStore;
    }

    public String getName() {
        return this.credentialHelperName;
    }

    public String getVersion() {
        try {
            return new VersionCommand().getVersion();
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting the version of the configured credential helper", e);
        }
    }

    public AuthConfig getAuthConfig(String registryToLookup) throws IOException {
        try {
            JsonObject creds = new GetCommand().getCredentialNode(registryToLookup);
            if (creds == null) {
                creds = new GetCommand().getCredentialNode(EnvUtil.ensureRegistryHttpUrl((String)registryToLookup));
            }
            return this.toAuthConfig(creds);
        }
        catch (IOException e) {
            throw new IOException("Error getting the credentials for " + registryToLookup + " from the configured credential helper", e);
        }
    }

    AuthConfig toAuthConfig(JsonObject credential) {
        if (credential == null) {
            return null;
        }
        String password = credential.get(SECRET_KEY).getAsString();
        String userKey = credential.get(USERNAME_KEY).getAsString();
        if (TOKEN_USERNAME.equals(userKey)) {
            return new AuthConfig(null, null, null, null, password);
        }
        return new AuthConfig(userKey, password, null, null);
    }

    private class GetCommand
    extends ExternalCommand {
        private final List<String> reply;

        GetCommand() {
            super(CredentialHelperClient.this.log);
            this.reply = new LinkedList<String>();
        }

        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "get"};
        }

        protected void processLine(String line) {
            this.reply.add(line);
        }

        public JsonObject getCredentialNode(String registryToLookup) throws IOException {
            try {
                this.execute(registryToLookup);
            }
            catch (IOException ex) {
                if (this.getStatusCode() == 1) {
                    return null;
                }
                throw ex;
            }
            JsonObject credentials = JsonFactory.newJsonObject((String)String.join((CharSequence)"\n", this.reply));
            if (!credentials.has(CredentialHelperClient.SECRET_KEY) || !credentials.has(CredentialHelperClient.USERNAME_KEY)) {
                return null;
            }
            return credentials;
        }
    }

    private class VersionCommand
    extends ExternalCommand {
        private String version;

        VersionCommand() {
            super(CredentialHelperClient.this.log);
        }

        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "version"};
        }

        protected void processLine(String line) {
            this.log.verbose("Credentials helper reply for \"%s\" is %s", new Object[]{CredentialHelperClient.this.credentialHelperName, line});
            this.version = line;
        }

        public String getVersion() throws IOException {
            this.execute();
            if (this.version == null) {
                this.log.verbose("The credentials helper \"%s\" didn't return a version string", new Object[]{CredentialHelperClient.this.credentialHelperName});
            }
            return this.version;
        }
    }
}

