/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.polarsys.kitalpha.cadence.core.api.CadenceLauncher;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.composer.Activator;
import org.polarsys.kitalpha.composer.api.CodeManagerCadenceLaunchConfiguration;
import org.polarsys.kitalpha.composer.api.ICodeManagerWorkflowConstants;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.ParameterError;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerInputFactory;
import org.polarsys.kitalpha.composer.api.configuration.ICodeManagerInput;
import org.polarsys.kitalpha.composer.api.library.LibraryRuntimeHelper;
import org.polarsys.kitalpha.composer.extension.points.IGenerator;
import org.polarsys.kitalpha.composer.extension.points.IGeneratorWithProgress;
import org.polarsys.kitalpha.composer.extension.points.IRefinery;
import org.polarsys.kitalpha.composer.extension.points.IRefineryWithProgress;
import org.polarsys.kitalpha.composer.extension.points.IStrategy;
import org.polarsys.kitalpha.composer.extension.points.IStrategyWithProgress;
import org.polarsys.kitalpha.composer.metamodel.allocation.base.Root;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public final class CodeManagerLauncher
implements ICodeManagerWorkflowConstants {
    private static final String ALLOCATION_MODEL_PARAM_DESCRIPTION = "Root of the allocation model";
    private static final String ALLOCATION_MODEL_PARAM_NAME = "allocationModel";
    private static final String GENERATION_DIRECTORY_PATH_PARAM_DESCRIPTION = "The path of the directory that contains the genereted files";
    private static final String GENERATION_DIRECTORY_PATH_PARAM_NAME = "generationDirectoryPath";
    private static final String SEMANTIC_MODEL_PARAM_DESCRIPTION = "The semantic model";
    private static final String SEMANTIC_MODEL_PARAM_NAME = "semanticModel";
    private static Map<String, ParameterError> wrongParams = null;

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, List<EObject> eObjects, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = CodeManagerLauncher.createLaunchConfiguration(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, CodeManagerInputFactory.create(eObjects), cadenceConfig, save);
        return CodeManagerLauncher.launchWithProgress(codeManagerConfiguration, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, org.eclipse.emf.ecore.resource.Resource resource, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = CodeManagerLauncher.createLaunchConfiguration(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, CodeManagerInputFactory.create(resource), cadenceConfig, save);
        return CodeManagerLauncher.launchWithProgress(codeManagerConfiguration, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, EObject modelRoot_p, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = CodeManagerLauncher.createLaunchConfiguration(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, CodeManagerInputFactory.create(modelRoot_p), cadenceConfig, save);
        return CodeManagerLauncher.launchWithProgress(codeManagerConfiguration, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, ResourceSet resourceSet, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = CodeManagerLauncher.createLaunchConfiguration(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, CodeManagerInputFactory.create(resourceSet), cadenceConfig, save);
        return CodeManagerLauncher.launchWithProgress(codeManagerConfiguration, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, List<EObject> eObjects, boolean save) {
        return CodeManagerLauncher.launch(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, eObjects, new CodeManagerCadenceLaunchConfiguration(), save);
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, org.eclipse.emf.ecore.resource.Resource resource, boolean save) {
        return CodeManagerLauncher.launch(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, resource, new CodeManagerCadenceLaunchConfiguration(), save);
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, EObject modelRoot_p, boolean save) {
        return CodeManagerLauncher.launch(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, modelRoot_p, new CodeManagerCadenceLaunchConfiguration(), save);
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, ResourceSet resourceSet, boolean save) {
        return CodeManagerLauncher.launch(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, resourceSet, new CodeManagerCadenceLaunchConfiguration(), save);
    }

    private static void saveAllocationModel(org.eclipse.emf.ecore.resource.Resource business_model, EObject alloc_model, IPath path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        String modelname = business_model.getURI().toPlatformString(true);
        URI fileURI = URI.createPlatformResourceURI((String)modelname.replaceAll(business_model.getURI().fileExtension(), alloc_model.eClass().getEPackage().getName().toString()), (boolean)true);
        org.eclipse.emf.ecore.resource.Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)alloc_model);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            ILog log = Activator.getDefault().getLog();
            log.log((IStatus)new Status(4, "org.polarsys.kitalpha.composer.core", "Error while generating code", (Throwable)e));
        }
    }

    public static String getParameterErrorsTrace(Map<String, ParameterError> parametersMap) {
        String result = "bad value for: ";
        Set<String> keys = parametersMap.keySet();
        for (String key : keys) {
            result = String.valueOf(result) + key + "->" + parametersMap.get(key).getReason() + ",";
        }
        int end = result.lastIndexOf(",");
        return result.substring(0, end);
    }

    public static IStatus launchWithProgress(CodeManagerConfiguration configuration, IProgressMonitor progressMonitor) {
        CodeManagerCadenceLaunchConfiguration cadenceConfig = configuration.getCodeManagerCadenceLaunchConfiguration();
        int totalWork = cadenceConfig.getBeforeStrategyActivities().getActivitiesID().size() + 1 + cadenceConfig.getBeforeRefineryActivities().getActivitiesID().size() + 1 + cadenceConfig.getBeforeGenerationActivities().getActivitiesID().size() + 1 + cadenceConfig.getAfterGenerationActivities().getActivitiesID().size();
        if (configuration.getInput().isMultipleObjectsInput()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)totalWork);
            return CodeManagerLauncher.launchFromEObjectsList(configuration, subMonitor);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)(totalWork *= configuration.getInput().getRootsInputs().size()));
        for (EObject eObject : configuration.getInput().getRootsInputs()) {
            IStatus status = CodeManagerLauncher.launchFromRootEObject(eObject, configuration, subMonitor);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private static IStatus launchFromRootEObject(EObject object, CodeManagerConfiguration configuration, SubMonitor subMonitor) {
        try {
            ArrayList<EObject> selectedObjects = new ArrayList<EObject>(1);
            selectedObjects.add(object);
            IStatus status = CodeManagerLauncher.beforeStrategyWorkflow(configuration, (IProgressMonitor)subMonitor, selectedObjects);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            Root allocRoot = CodeManagerLauncher.strategyLauncher(configuration.getStrategy(), configuration.getStrategyParameters(), object, (IProgressMonitor)subMonitor.newChild(1));
            status = CodeManagerLauncher.beforeRefineryWorkflow(configuration, (IProgressMonitor)subMonitor, selectedObjects, allocRoot);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            CodeManagerLauncher.setLibrariesHelper(configuration);
            allocRoot = CodeManagerLauncher.refineryLauncher(configuration.getRefinery(), configuration.getRefineryParameters(), allocRoot, (IProgressMonitor)subMonitor.newChild(1));
            status = CodeManagerLauncher.beforeGeneratorWorkflow(configuration, subMonitor, selectedObjects, allocRoot);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            CodeManagerLauncher.generatorLauncher(configuration.getGenerator(), configuration.getDestinationFolder(), configuration.getGeneratorParameters(), allocRoot, (IProgressMonitor)subMonitor.newChild(1));
            status = CodeManagerLauncher.afterGeneratorWorkflow(configuration, subMonitor, selectedObjects, allocRoot);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            if (allocRoot != null && configuration.isSaveAllocationModel()) {
                CodeManagerLauncher.saveAllocationModel(((EObject)selectedObjects.iterator().next()).eResource(), (EObject)allocRoot, configuration.getDestinationFolder());
            }
        }
        catch (Exception e) {
            ILog log = Activator.getDefault().getLog();
            Status status = new Status(4, "org.polarsys.kitalpha.composer.core", "Error while generating code", (Throwable)e);
            log.log((IStatus)status);
            return status;
        }
        return Status.OK_STATUS;
    }

    private static IStatus launchFromEObjectsList(CodeManagerConfiguration configuration, SubMonitor subMonitor) {
        List<EObject> selectedObjects = configuration.getInput().getListInput();
        if (selectedObjects.isEmpty()) {
            return Status.OK_STATUS;
        }
        try {
            IStatus status = CodeManagerLauncher.beforeStrategyWorkflow(configuration, (IProgressMonitor)subMonitor, selectedObjects);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            Root allocRoot = CodeManagerLauncher.strategyLauncher(configuration.getStrategy(), configuration.getStrategyParameters(), selectedObjects, (IProgressMonitor)subMonitor.newChild(1));
            status = CodeManagerLauncher.beforeRefineryWorkflow(configuration, (IProgressMonitor)subMonitor, selectedObjects, allocRoot);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            CodeManagerLauncher.setLibrariesHelper(configuration);
            allocRoot = CodeManagerLauncher.refineryLauncher(configuration.getRefinery(), configuration.getRefineryParameters(), allocRoot, (IProgressMonitor)subMonitor.newChild(1));
            status = CodeManagerLauncher.beforeGeneratorWorkflow(configuration, subMonitor, selectedObjects, allocRoot);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            CodeManagerLauncher.generatorLauncher(configuration.getGenerator(), configuration.getDestinationFolder(), configuration.getGeneratorParameters(), allocRoot, (IProgressMonitor)subMonitor.newChild(1));
            status = CodeManagerLauncher.afterGeneratorWorkflow(configuration, subMonitor, selectedObjects, allocRoot);
            if (!status.isOK()) {
                Activator.getDefault().getLog().log(status);
                return status;
            }
            if (allocRoot != null && configuration.isSaveAllocationModel()) {
                CodeManagerLauncher.saveAllocationModel(selectedObjects.iterator().next().eResource(), (EObject)allocRoot, configuration.getDestinationFolder());
            }
        }
        catch (Exception e) {
            ILog log = Activator.getDefault().getLog();
            Status status = new Status(4, "org.polarsys.kitalpha.composer.core", "Error while generating code", (Throwable)e);
            log.log((IStatus)status);
            return status;
        }
        return Status.OK_STATUS;
    }

    private static void setLibrariesHelper(CodeManagerConfiguration configuration) {
        LibraryRuntimeHelper.INSTANCE.setLibraries(configuration.getLibraries());
        String missing = configuration.getNoFound();
        if (missing == null || missing == "") {
            LibraryRuntimeHelper.INSTANCE.setMissing(configuration.getStrategy(), configuration.getStrategyParameters());
        } else {
            LibraryRuntimeHelper.INSTANCE.setMissing(missing);
        }
    }

    private static IStatus beforeStrategyWorkflow(CodeManagerConfiguration configuration, IProgressMonitor subMonitor, List<EObject> selectedObjects) throws Exception {
        GenericParameter semanticModel = new GenericParameter(SEMANTIC_MODEL_PARAM_NAME, selectedObjects, SEMANTIC_MODEL_PARAM_DESCRIPTION);
        GenericParameter generationPath = new GenericParameter(GENERATION_DIRECTORY_PATH_PARAM_NAME, (Object)configuration.getDestinationFolder().toString(), GENERATION_DIRECTORY_PATH_PARAM_DESCRIPTION);
        WorkflowActivityParameter beforeStrategyActvities = configuration.getCodeManagerCadenceLaunchConfiguration().getBeforeStrategyActivities();
        for (String activityID : beforeStrategyActvities.getActivitiesID()) {
            beforeStrategyActvities.addParameter(activityID, semanticModel);
            beforeStrategyActvities.addParameter(activityID, generationPath);
        }
        IStatus status = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.beforestrategy", (WorkflowActivityParameter)beforeStrategyActvities);
        subMonitor.worked(beforeStrategyActvities.getActivitiesID().size());
        return status;
    }

    private static IStatus beforeRefineryWorkflow(CodeManagerConfiguration configuration, IProgressMonitor subMonitor, List<EObject> selectedObjects, Root allocRoot_p) throws Exception {
        GenericParameter semanticModel = new GenericParameter(SEMANTIC_MODEL_PARAM_NAME, selectedObjects, SEMANTIC_MODEL_PARAM_DESCRIPTION);
        GenericParameter generationPath = new GenericParameter(GENERATION_DIRECTORY_PATH_PARAM_NAME, (Object)configuration.getDestinationFolder().toString(), GENERATION_DIRECTORY_PATH_PARAM_DESCRIPTION);
        GenericParameter allocationModel = new GenericParameter(ALLOCATION_MODEL_PARAM_NAME, (Object)allocRoot_p, ALLOCATION_MODEL_PARAM_DESCRIPTION);
        WorkflowActivityParameter beforeRefineryActivities = configuration.getCodeManagerCadenceLaunchConfiguration().getBeforeRefineryActivities();
        for (String activityID : beforeRefineryActivities.getActivitiesID()) {
            beforeRefineryActivities.addParameter(activityID, semanticModel);
            beforeRefineryActivities.addParameter(activityID, allocationModel);
            beforeRefineryActivities.addParameter(activityID, generationPath);
        }
        IStatus status = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.beforerefinery", (WorkflowActivityParameter)beforeRefineryActivities);
        subMonitor.worked(beforeRefineryActivities.getActivitiesID().size());
        return status;
    }

    private static IStatus beforeGeneratorWorkflow(CodeManagerConfiguration configuration, SubMonitor subMonitor, List<EObject> selectedObjects, Root allocRoot) throws Exception {
        GenericParameter semanticModel = new GenericParameter(SEMANTIC_MODEL_PARAM_NAME, selectedObjects, SEMANTIC_MODEL_PARAM_DESCRIPTION);
        GenericParameter generationPath = new GenericParameter(GENERATION_DIRECTORY_PATH_PARAM_NAME, (Object)configuration.getDestinationFolder().toString(), GENERATION_DIRECTORY_PATH_PARAM_DESCRIPTION);
        GenericParameter allocationModel = new GenericParameter(ALLOCATION_MODEL_PARAM_NAME, (Object)allocRoot, ALLOCATION_MODEL_PARAM_DESCRIPTION);
        WorkflowActivityParameter beforeGenerationActivities = configuration.getCodeManagerCadenceLaunchConfiguration().getBeforeGenerationActivities();
        for (String activityID : beforeGenerationActivities.getActivitiesID()) {
            beforeGenerationActivities.addParameter(activityID, semanticModel);
            beforeGenerationActivities.addParameter(activityID, allocationModel);
            beforeGenerationActivities.addParameter(activityID, generationPath);
        }
        IStatus status = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.beforegeneration", (WorkflowActivityParameter)beforeGenerationActivities);
        subMonitor.worked(beforeGenerationActivities.getActivitiesID().size());
        return status;
    }

    private static IStatus afterGeneratorWorkflow(CodeManagerConfiguration configuration, SubMonitor subMonitor, List<EObject> selectedObjects, Root allocRoot) throws Exception {
        GenericParameter semanticModel = new GenericParameter(SEMANTIC_MODEL_PARAM_NAME, selectedObjects, SEMANTIC_MODEL_PARAM_DESCRIPTION);
        GenericParameter generationPath = new GenericParameter(GENERATION_DIRECTORY_PATH_PARAM_NAME, (Object)configuration.getDestinationFolder().toString(), GENERATION_DIRECTORY_PATH_PARAM_DESCRIPTION);
        GenericParameter allocationModel = new GenericParameter(ALLOCATION_MODEL_PARAM_NAME, (Object)allocRoot, ALLOCATION_MODEL_PARAM_DESCRIPTION);
        WorkflowActivityParameter afterGenerationActivities = configuration.getCodeManagerCadenceLaunchConfiguration().getAfterGenerationActivities();
        for (String activityID : afterGenerationActivities.getActivitiesID()) {
            afterGenerationActivities.addParameter(activityID, semanticModel);
            afterGenerationActivities.addParameter(activityID, allocationModel);
            afterGenerationActivities.addParameter(activityID, generationPath);
        }
        IStatus status = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.aftergeneration", (WorkflowActivityParameter)afterGenerationActivities);
        subMonitor.worked(afterGenerationActivities.getActivitiesID().size());
        return status;
    }

    private static Root strategyLauncher(IStrategy strategy, Map<String, Parameter> strategyParameters, List<EObject> objects, IProgressMonitor progressMonitor) throws Exception {
        Root allocRoot_p = null;
        if (objects != null && strategy != null) {
            EObject root = null;
            if (!objects.isEmpty()) {
                root = EcoreUtil.getRootContainer((EObject)objects.iterator().next());
            }
            if (strategyParameters != null && (wrongParams = strategy.validateParameters(strategyParameters)) != null && !wrongParams.isEmpty()) {
                throw new Exception("strategy's parameters are not valid. " + CodeManagerLauncher.getParameterErrorsTrace(wrongParams));
            }
            allocRoot_p = strategy instanceof IStrategyWithProgress ? ((IStrategyWithProgress)strategy).allocateModelElements(root, strategyParameters, objects, progressMonitor) : strategy.allocateModelElements(root, strategyParameters, objects);
        }
        return allocRoot_p;
    }

    private static Root strategyLauncher(IStrategy strategy, Map<String, Parameter> strategyParameters, EObject root, IProgressMonitor progressMonitor) throws Exception {
        Root allocRoot_p = null;
        if (root != null && strategy != null) {
            if (strategyParameters != null && (wrongParams = strategy.validateParameters(strategyParameters)) != null && !wrongParams.isEmpty()) {
                throw new Exception("strategy's parameters are not valid. " + CodeManagerLauncher.getParameterErrorsTrace(wrongParams));
            }
            allocRoot_p = strategy instanceof IStrategyWithProgress ? ((IStrategyWithProgress)strategy).allocateModelElements(root, strategyParameters, progressMonitor) : strategy.allocateModelElements(root, strategyParameters);
        }
        return allocRoot_p;
    }

    private static Root refineryLauncher(IRefinery refinery, Map<String, Parameter> refineryParameters, Root allocRoot_p, IProgressMonitor progressMonitor) throws Exception {
        if (allocRoot_p != null && refinery != null) {
            if (refineryParameters != null && (wrongParams = refinery.validateParameters(refineryParameters)) != null && !wrongParams.isEmpty()) {
                throw new Exception("refinery's parameters are not valid. " + CodeManagerLauncher.getParameterErrorsTrace(wrongParams));
            }
            if (refinery instanceof IRefineryWithProgress) {
                ((IRefineryWithProgress)refinery).refineModelElements(allocRoot_p, refineryParameters, progressMonitor);
            } else {
                allocRoot_p = refinery.refineModelElements(allocRoot_p, refineryParameters);
            }
        }
        return allocRoot_p;
    }

    private static void generatorLauncher(IGenerator generator, IPath path_f, Map<String, Parameter> generatorParams_p, Root allocRoot_p, IProgressMonitor monitor) throws Exception {
        if (allocRoot_p != null && generator != null) {
            if (generatorParams_p != null && (wrongParams = generator.validateParameters(generatorParams_p)) != null && !wrongParams.isEmpty()) {
                throw new Exception("generator's parameters are not valid. " + CodeManagerLauncher.getParameterErrorsTrace(wrongParams));
            }
            if (generator instanceof IGeneratorWithProgress) {
                ((IGeneratorWithProgress)generator).generateCode(allocRoot_p, generatorParams_p, path_f, monitor);
            } else {
                generator.generateCode(allocRoot_p, generatorParams_p, path_f);
            }
        }
    }

    public static CodeManagerConfiguration createLaunchConfiguration(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, ICodeManagerInput input, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = new CodeManagerConfiguration();
        codeManagerConfiguration.setCodeManagerCadenceLaunchConfiguration(cadenceConfig);
        codeManagerConfiguration.setStrategy(strategy);
        codeManagerConfiguration.setStrategyParameters(strategyParams_p);
        codeManagerConfiguration.setRefinery(refinery);
        codeManagerConfiguration.setRefineryParameters(refineryParams_p);
        codeManagerConfiguration.setGenerator(generator);
        codeManagerConfiguration.setGeneratorParameters(generatorParams_p);
        codeManagerConfiguration.setDestinationFolder(path_p);
        codeManagerConfiguration.setInput(input);
        codeManagerConfiguration.setSaveAllocationModel(save);
        return codeManagerConfiguration;
    }

    public static CodeManagerConfiguration createLaunchConfiguration(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, List<Resource> libraries, String missingLib, ICodeManagerInput input, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = new CodeManagerConfiguration();
        codeManagerConfiguration.setCodeManagerCadenceLaunchConfiguration(cadenceConfig);
        codeManagerConfiguration.setStrategy(strategy);
        codeManagerConfiguration.setStrategyParameters(strategyParams_p);
        codeManagerConfiguration.setRefinery(refinery);
        codeManagerConfiguration.setRefineryParameters(refineryParams_p);
        codeManagerConfiguration.setGenerator(generator);
        codeManagerConfiguration.setGeneratorParameters(generatorParams_p);
        codeManagerConfiguration.setDestinationFolder(path_p);
        codeManagerConfiguration.setLibraries(libraries);
        codeManagerConfiguration.setNoFound(missingLib);
        codeManagerConfiguration.setInput(input);
        codeManagerConfiguration.setSaveAllocationModel(save);
        return codeManagerConfiguration;
    }

    public static IStatus launch(IStrategy strategy, Map<String, Parameter> strategyParams_p, IRefinery refinery, Map<String, Parameter> refineryParams_p, IGenerator generator, IPath path_p, Map<String, Parameter> generatorParams_p, List<Resource> libraries, String missingLib, org.eclipse.emf.ecore.resource.Resource resource, CodeManagerCadenceLaunchConfiguration cadenceConfig, boolean save) {
        CodeManagerConfiguration codeManagerConfiguration = CodeManagerLauncher.createLaunchConfiguration(strategy, strategyParams_p, refinery, refineryParams_p, generator, path_p, generatorParams_p, libraries, missingLib, CodeManagerInputFactory.create(resource), cadenceConfig, save);
        return CodeManagerLauncher.launchWithProgress(codeManagerConfiguration, (IProgressMonitor)new NullProgressMonitor());
    }
}

