/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.internal.configuration;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.configuration.ICodeManagerInput;
import org.polarsys.kitalpha.composer.api.configuration.IConfigurationMemento;

public class ConfigurationMemento
implements IConfigurationMemento {
    private static final String STRATEGY_PREFIX = "strategy";
    private static final String REFINERY_PREFIX = "refinery";
    private static final String GENERATOR_PREFIX = "generator";
    private static final String DESTINATION_FOLDER_PREFIX = "destinationFolder";
    private static final String IDENTIFIER_SEPARATOR = ".";

    @Override
    public void restore(CodeManagerConfiguration configuration) throws CoreException {
        String configurationKey = String.valueOf(configuration.getStrategy().getClass().getName()) + IDENTIFIER_SEPARATOR + configuration.getRefinery().getClass().getName() + configuration.getStrategy().getClass().getName();
        this.restore(configuration, configurationKey);
    }

    @Override
    public void restore(CodeManagerConfiguration configuration, String configurationKey) throws CoreException {
        ICodeManagerInput input = configuration.getInput();
        if (!input.isMultipleObjectsInput()) {
            HashSet<Resource> resources = new HashSet<Resource>();
            for (EObject root : input.getRootsInputs()) {
                if (root.eResource() == null) continue;
                resources.add(root.eResource());
            }
            for (Resource resource : resources) {
                IFile iFile = this.getFile(resource);
                if (iFile == null || !this.restore(configuration, (IResource)iFile, configurationKey)) {
                    continue;
                }
                break;
            }
        } else {
            for (EObject eObject : input.getListInput()) {
                boolean isRestored;
                IFile iFile;
                if (eObject.eResource() == null || (iFile = this.getFile(eObject.eResource())) == null || !(isRestored = this.restore(configuration, configurationKey, (IResource)iFile, eObject))) {
                    continue;
                }
                break;
            }
        }
    }

    private boolean restore(CodeManagerConfiguration configuration, String configurationKey, IResource resource, EObject eObject) throws CoreException {
        boolean isRestored = false;
        EObject current = eObject;
        while (current != null && !isRestored) {
            String uriFragment = current.eResource().getURIFragment(current);
            isRestored = this.restore(configuration, resource, String.valueOf(configurationKey) + IDENTIFIER_SEPARATOR + uriFragment);
            if (isRestored) continue;
            current = current.eContainer();
        }
        if (!isRestored) {
            isRestored = this.restore(configuration, resource, configurationKey);
        }
        return isRestored;
    }

    @Override
    public void save(CodeManagerConfiguration configuration) throws CoreException {
        String configurationKey = String.valueOf(configuration.getStrategy().getClass().getName()) + IDENTIFIER_SEPARATOR + configuration.getRefinery().getClass().getName() + configuration.getStrategy().getClass().getName();
        this.save(configuration, configurationKey);
    }

    @Override
    public void save(CodeManagerConfiguration configuration, String configurationKey) throws CoreException {
        ICodeManagerInput input = configuration.getInput();
        if (!input.isMultipleObjectsInput()) {
            HashSet<Resource> resources = new HashSet<Resource>();
            for (EObject root : input.getRootsInputs()) {
                if (root.eResource() == null) continue;
                resources.add(root.eResource());
            }
            for (Resource resource : resources) {
                IFile iFile = this.getFile(resource);
                if (iFile == null) continue;
                this.save(configuration, (IResource)iFile, configurationKey);
            }
        } else {
            for (EObject eObject : input.getListInput()) {
                if (eObject.eResource() == null) continue;
                String uriFragment = eObject.eResource().getURIFragment(eObject);
                IFile iFile = this.getFile(eObject.eResource());
                if (iFile == null) continue;
                this.save(configuration, (IResource)iFile, String.valueOf(configurationKey) + IDENTIFIER_SEPARATOR + uriFragment);
            }
        }
    }

    private boolean restore(CodeManagerConfiguration configuration, IResource resource, String keySuffix) throws CoreException {
        boolean isRestored = false;
        String prefix = keySuffix == null || keySuffix.length() == 0 ? DESTINATION_FOLDER_PREFIX : "destinationFolder." + keySuffix;
        String value = resource.getPersistentProperty(new QualifiedName(DESTINATION_FOLDER_PREFIX, prefix));
        if (value != null) {
            isRestored = true;
            configuration.setDestinationFolder((IPath)new Path(value));
        }
        prefix = keySuffix == null || keySuffix.length() == 0 ? STRATEGY_PREFIX : "strategy." + keySuffix;
        isRestored = this.restore(configuration.getStrategyParameters(), resource, prefix) || isRestored;
        prefix = keySuffix == null || keySuffix.length() == 0 ? REFINERY_PREFIX : "refinery." + keySuffix;
        isRestored = this.restore(configuration.getRefineryParameters(), resource, prefix) || isRestored;
        prefix = keySuffix == null || keySuffix.length() == 0 ? GENERATOR_PREFIX : "generator." + keySuffix;
        isRestored = this.restore(configuration.getGeneratorParameters(), resource, prefix) || isRestored;
        return isRestored;
    }

    private boolean restore(Map<String, Parameter> parameters, IResource resource, String prefix) throws CoreException {
        boolean isRestored = false;
        for (Map.Entry<String, Parameter> parameter : parameters.entrySet()) {
            String value = resource.getPersistentProperty(new QualifiedName(prefix, parameter.getKey()));
            if (value == null) continue;
            isRestored = true;
            parameter.getValue().setValue(value);
        }
        return isRestored;
    }

    private void save(CodeManagerConfiguration configuration, IResource resource, String keySuffix) throws CoreException {
        String prefix = keySuffix == null || keySuffix.length() == 0 ? DESTINATION_FOLDER_PREFIX : "destinationFolder." + keySuffix;
        String destinationFolder = configuration.getDestinationFolder() == null ? null : configuration.getDestinationFolder().toString();
        resource.setPersistentProperty(new QualifiedName(DESTINATION_FOLDER_PREFIX, prefix), destinationFolder);
        prefix = keySuffix == null || keySuffix.length() == 0 ? STRATEGY_PREFIX : "strategy." + keySuffix;
        this.save(configuration.getStrategyParameters(), resource, prefix);
        prefix = keySuffix == null || keySuffix.length() == 0 ? REFINERY_PREFIX : "refinery." + keySuffix;
        this.save(configuration.getRefineryParameters(), resource, prefix);
        prefix = keySuffix == null || keySuffix.length() == 0 ? GENERATOR_PREFIX : "generator." + keySuffix;
        this.save(configuration.getGeneratorParameters(), resource, prefix);
    }

    private void save(Map<String, Parameter> parameters, IResource resource, String prefix) throws CoreException {
        for (Map.Entry<String, Parameter> parameter : parameters.entrySet()) {
            resource.setPersistentProperty(new QualifiedName(prefix, parameter.getKey()), parameter.getValue().getValue());
        }
    }

    private IFile getFile(Resource resource) {
        if (resource.getURI() != null && resource.getURI().isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)));
        }
        return null;
    }
}

