/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.unfold;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.table.layer.IMAComponent;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.visualize.helpers.UnfoldRowObjectHelper;

public class MVPerspectiveManager
implements IMAComponent {
    private static final Log log = LogFactory.getLog(MVPerspectiveManager.class);
    protected IMABodyLayer bodyLayer;
    protected Collection<EObject> rawFoldedData;
    protected Set<EObject> cachedPrevFoldedData;
    protected Set<EObject> cachedFoldedData;
    protected Collection<EObject> rawUnfoldedData;
    protected Map<EObject, Collection<EObject>> cachedUnfoldedData;
    protected Set<EObject> dirtyFoldedData;
    protected List<IMAColumn> prevColumnList;
    protected Set<Integer> hiddenColumnIndexes;
    protected boolean folded;

    public MVPerspectiveManager(IMABodyLayer bodyLayer) {
        this.bodyLayer = bodyLayer;
        this.folded = true;
        this.cachedUnfoldedData = new HashMap<EObject, Collection<EObject>>();
        this.dirtyFoldedData = new HashSet<EObject>();
        this.prevColumnList = Collections.emptyList();
        this.hiddenColumnIndexes = Collections.emptySet();
    }

    public void switchPerspective(List<IMAColumn> columnList) {
        if (this.folded) {
            this.unfold(columnList);
        } else {
            this.fold();
        }
    }

    public void fold() {
        this.folded = true;
    }

    public void unfold(List<IMAColumn> columnList) {
        boolean dirtyDataPresent;
        Set<Integer> prevHiddenColumnIndexes = this.hiddenColumnIndexes;
        this.hiddenColumnIndexes = new HashSet<Integer>(this.bodyLayer.getColumnHideShowLayer().getHiddenColumnIndexes());
        boolean newVisibleColumns = !this.hiddenColumnIndexes.equals(prevHiddenColumnIndexes);
        boolean newDataPresent = !this.cachedFoldedData.equals(this.cachedPrevFoldedData);
        boolean bl = dirtyDataPresent = !this.dirtyFoldedData.isEmpty();
        if (newDataPresent || newVisibleColumns || dirtyDataPresent) {
            Collection<EObject> cachedNewFoldedData;
            boolean sameColumnConfig;
            boolean bl2 = sameColumnConfig = this.prevColumnList.size() == columnList.size();
            if (sameColumnConfig && !newVisibleColumns) {
                cachedNewFoldedData = new HashSet<EObject>(this.cachedFoldedData);
                cachedNewFoldedData.removeAll(this.cachedPrevFoldedData);
                if (dirtyDataPresent) {
                    for (EObject dirtyObject : this.dirtyFoldedData) {
                        Collection<EObject> prevUnfoldedData = this.cachedUnfoldedData.get(dirtyObject);
                        this.rawUnfoldedData.removeAll(prevUnfoldedData);
                    }
                    cachedNewFoldedData.addAll(this.dirtyFoldedData);
                    log.info((Object)("Dirty data present [" + this.dirtyFoldedData.size() + "] elements\n\t" + this.dirtyFoldedData));
                    this.dirtyFoldedData.clear();
                }
                log.info((Object)("Same column config -> compute only for new objects [" + cachedNewFoldedData.size() + "]"));
            } else {
                cachedNewFoldedData = this.rawFoldedData;
                this.rawUnfoldedData = new ArrayList<EObject>();
                log.info((Object)"diferent column config -> compute for everyone");
            }
            for (EObject foldedObject : cachedNewFoldedData) {
                Set<EObject> unfoldedObjects = UnfoldRowObjectHelper.createUnfoldedObjects(foldedObject, columnList, this.hiddenColumnIndexes);
                this.rawUnfoldedData.addAll(unfoldedObjects);
                this.cachedUnfoldedData.put(foldedObject, unfoldedObjects);
            }
            log.info((Object)("New cached data [" + cachedNewFoldedData.size() + "] elements\n\t" + cachedNewFoldedData));
            this.cachedPrevFoldedData = this.cachedFoldedData;
            this.prevColumnList = columnList;
        } else {
            log.info((Object)"No dirty state -> No unfold");
        }
        this.folded = false;
    }

    public void addDirtyElement(EObject element) {
        this.dirtyFoldedData.add(element);
    }

    public boolean isFolded() {
        return this.folded;
    }

    public Collection<EObject> getCurrentPerspectiveData() {
        return this.folded ? this.rawFoldedData : this.rawUnfoldedData;
    }

    public void dataChanged(Collection<EObject> newData) {
        this.cachedPrevFoldedData = this.cachedFoldedData == null ? Collections.emptySet() : this.cachedFoldedData;
        this.rawFoldedData = newData;
        this.cachedFoldedData = new HashSet<EObject>(this.rawFoldedData);
    }

    public void elementChanged(EObject element) {
        Collection<EObject> prevUnfoldedData = this.cachedUnfoldedData.get(element);
        this.rawUnfoldedData.removeAll(prevUnfoldedData);
        Set<EObject> newUnfoldedData = UnfoldRowObjectHelper.createUnfoldedObjects(element, this.prevColumnList, this.hiddenColumnIndexes);
        this.cachedUnfoldedData.put(element, newUnfoldedData);
        this.rawUnfoldedData.addAll(newUnfoldedData);
        log.info((Object)("Element changed [" + element + "]"));
    }

    public Collection<EObject> getUnfoldedObjectsForRoot(EObject root) {
        Collection<EObject> unfoldedObjects = this.cachedUnfoldedData.get(root);
        return unfoldedObjects == null ? Collections.emptySet() : unfoldedObjects;
    }

    public void dispose() {
    }
}

