/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.listeners;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.listeners.SiriusHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public final class SiriusViewpointActivationManager
implements ViewpointManager.OverallListener {
    public void hasBeenDeactivated(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), false);
    }

    public void hasBeenActivated(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), true);
    }

    private URI getURI(Resource res) {
        return URIHelper.createURI((Resource)res);
    }

    public void hasBeenFiltered(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), false);
    }

    public void hasBeenDisplayed(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), true);
    }

    private void updateActiveViewpoint(Object ctx, URI vpURI, boolean activate) {
        ViewpointSelectionCallback callback = new ViewpointSelectionCallback();
        Session session = SiriusHelper.getSession((ResourceSet)ctx);
        if (session == null) {
            return;
        }
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint vp = (org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint)domain.getResourceSet().getEObject(vpURI, true);
        Viewpoint genericVp = (Viewpoint)domain.getResourceSet().getEObject(Activator.GENERIC_VP_URI, true);
        Set<Viewpoint> viewpoints = SiriusHelper.getViewpoints(vp);
        if (viewpoints.isEmpty()) {
            return;
        }
        HashSet<Viewpoint> newSelectedViewpoints = new HashSet<Viewpoint>();
        Set<Viewpoint> newDeselectedViewpoints = SiriusHelper.EMPTY_SET;
        newSelectedViewpoints.add(genericVp);
        if (activate) {
            newSelectedViewpoints.addAll(viewpoints);
        } else {
            newDeselectedViewpoints = viewpoints;
        }
        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)callback, newSelectedViewpoints, newDeselectedViewpoints, (IProgressMonitor)new NullProgressMonitor());
        this.execute(domain, (RecordingCommand)command);
    }

    public void execute(TransactionalEditingDomain domain, RecordingCommand command) {
        domain.getCommandStack().execute((Command)command);
    }
}

