/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.ecore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractFeature;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AnnotatableElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Annotation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Association_Types;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Attribute;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Cardinalities;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Detail;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.EMFResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Enumeration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalClassAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalSuperClass;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalClassAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalSuperClass;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Operation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Parameter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Value;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ViewpointClassifier;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ViewpointResources;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.VpdescFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.ecore.ConflictingNameResloveStrategy;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.utils.EcoreElementsUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.utils.ReverseUtil;

public class ReverseFromEcoreEngine {
    private static final EPackage.Registry REGISTRY = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    private static final String eMDE_ANNOTATION_1 = "http://www.polarsys.org/kitalpha/emde/1.0.0/constraint";
    private static final String eMDE_ANNOTATION_2 = "http://www.polarsys.org/kitalpha/emde/1.0.0/constraintMapping";
    private Map<EClass, Class> reverseClassesMapping_ = new HashMap<EClass, Class>();
    private Map<EEnum, Enumeration> reverseEnumerationsMapping_ = new HashMap<EEnum, Enumeration>();
    private Map<EModelElement, AnnotatableElement> annotationElementMapping_ = new HashMap<EModelElement, AnnotatableElement>();
    private boolean flattenEPackages;
    private boolean addSeperator;
    private ConflictingNameResloveStrategy nameConflictResolveStrategy;
    private EPackage ePackage;
    private Viewpoint viewpoint;
    private IProgressMonitor monitor;
    private List<EPackage> targetApplicationEPackages = new ArrayList<EPackage>();
    private final String ECORE_NSURI_PATTERN = "http://www.eclipse.org/emf/\\d{4}/Ecore";
    private final String EMDE_NSURI_PATTERN = "http://www.polarsys.org/kitalpha/emde/(\\d+(\\.\\d+(\\.\\d+)))";
    private List<EClassifier> eClassifiersToReverse;

    public boolean reverse(EPackage ePackage, Viewpoint viewpoint, IProgressMonitor monitor) throws IOException {
        this.ePackage = ePackage;
        this.viewpoint = viewpoint;
        this.monitor = monitor;
        this.loadTargetApplicationEPackages();
        this.initEClassifiersToReverse(this.ePackage);
        int stepCount = this.reversibleElementCount() + 10;
        monitor.beginTask("Reverse from Ecore model", stepCount);
        this.registerToReverseAnnotation((EModelElement)ePackage, (AnnotatableElement)viewpoint.getVP_Data());
        this.reverseEnumeration();
        this.reverseClasses();
        this.reverseClassesContent();
        this.reverseAllAnnotations();
        this.saveResource();
        monitor.done();
        return true;
    }

    private void initEClassifiersToReverse(EPackage ePackage) {
        if (this.eClassifiersToReverse == null) {
            this.eClassifiersToReverse = new UniqueEList();
        } else {
            this.eClassifiersToReverse.clear();
        }
        this.collectEClassifiers(ePackage);
    }

    private void collectEClassifiers(EPackage ePackage) {
        EList eSubpackages;
        EList eClassifiers = ePackage.getEClassifiers();
        if (!eClassifiers.isEmpty()) {
            if (this.eClassifiersToReverse.isEmpty()) {
                this.eClassifiersToReverse.addAll((Collection<EClassifier>)eClassifiers);
            } else {
                for (EClassifier eClassifier : eClassifiers) {
                    for (EClassifier eClassifier2 : this.eClassifiersToReverse) {
                        if (!eClassifier.getName().toUpperCase().equals(eClassifier2.getName().toUpperCase())) continue;
                        String newEClassifierName = this.getNewEClassifierName(eClassifier);
                        eClassifier.setName(newEClassifierName);
                        break;
                    }
                    this.eClassifiersToReverse.add(eClassifier);
                }
            }
        }
        if (this.flattenEPackages && !(eSubpackages = ePackage.getESubpackages()).isEmpty()) {
            for (EPackage subEPackage : eSubpackages) {
                this.collectEClassifiers(subEPackage);
            }
        }
    }

    private String getNewEClassifierName(EClassifier eClassifier) {
        String oldEClassfierName;
        String ePackageName = eClassifier.getEPackage().getName();
        String newEClassifierName = oldEClassfierName = eClassifier.getName();
        switch (this.nameConflictResolveStrategy) {
            case PrefixByEPackageName: {
                newEClassifierName = String.valueOf(ePackageName) + (this.addSeperator ? "_" : "") + oldEClassfierName;
                break;
            }
            case SufixByEPackageName: {
                newEClassifierName = String.valueOf(oldEClassfierName) + (this.addSeperator ? "_" : "") + ePackageName;
                break;
            }
            case PrefixByIncrementalValue: {
                break;
            }
            case SufixByIncrementalValue: {
                break;
            }
        }
        return newEClassifierName;
    }

    private void reverseEnumeration() {
        for (EClassifier eClassifier : this.eClassifiersToReverse) {
            if (!(eClassifier instanceof EEnum)) continue;
            EEnum eEnum = (EEnum)eClassifier;
            String enumName = eEnum.getName();
            this.monitorProgress(String.valueOf(enumName) + " (EEnum)");
            Enumeration enumeration = VpdescFactory.eINSTANCE.createEnumeration();
            enumeration.setName(enumName);
            this.viewpoint.getVP_Data().getVP_Enumerations().add((Object)enumeration);
            for (EEnumLiteral eLiteral : eEnum.getELiterals()) {
                Value value = VpdescFactory.eINSTANCE.createValue();
                value.setLiteral(eLiteral.getLiteral());
                value.setName(eLiteral.getName());
                enumeration.getOwnedValues().add((Object)value);
            }
            this.addEnumerationMapEntry(eEnum, enumeration);
            this.registerToReverseAnnotation((EModelElement)eEnum, (AnnotatableElement)enumeration);
        }
    }

    private void reverseClasses() {
        for (EClassifier eClassifier : this.eClassifiersToReverse) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            String className = eClass.getName();
            this.monitorProgress(String.valueOf(className) + " (EClass)");
            boolean isAbstract = eClass.isAbstract();
            Class clazz = VpdescFactory.eINSTANCE.createClass();
            clazz.setName(className);
            clazz.setAbstract(isAbstract);
            this.viewpoint.getVP_Data().getVP_Classes().add((Object)clazz);
            this.addClassMapEntry(eClass, clazz);
            this.reverseeMDEExtension(eClass, clazz);
            this.registerToReverseAnnotation((EModelElement)eClass, (AnnotatableElement)clazz);
        }
    }

    private void reverseClassesContent() {
        for (EClassifier eClassifier : this.eClassifiersToReverse) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            Class vpClass = this.reverseClassesMapping_.get(eClass);
            this.reverseInheritanceRelationships(vpClass, eClass);
            this.reverseAssociationsRelationships(vpClass, eClass);
            this.reverseOperations(vpClass, eClass);
            this.reverseAttributes(vpClass, eClass);
        }
    }

    private void reverseAllAnnotations() {
        for (Map.Entry<EModelElement, AnnotatableElement> iEntry : this.annotationElementMapping_.entrySet()) {
            EModelElement eElement = iEntry.getKey();
            AnnotatableElement vpElement = iEntry.getValue();
            this.reverseAnnotation(vpElement, eElement);
        }
    }

    private void saveResource() throws IOException {
        this.viewpoint.eResource().save(Collections.EMPTY_MAP);
    }

    private void reverseeMDEExtension(EClass eClass, Class vpClass) {
        EAnnotation annotation = eClass.getEAnnotation(eMDE_ANNOTATION_1);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)"ExtendedElement");
            String[] stringArray = value.trim().split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier eClassifier;
                EPackage ePackage;
                String val = stringArray[n2];
                URI uri = URI.createURI((String)val);
                String fragment = uri.fragment();
                if (fragment.startsWith("//")) {
                    fragment = fragment.substring(2);
                }
                if ((ePackage = REGISTRY.getEPackage((uri = uri.trimFragment()).toString())) != null && (eClassifier = ePackage.getEClassifier(fragment)) != null) {
                    EClass taEClass = EcoreElementsUtil.transformEClassToNsUriEClass((EClass)eClassifier);
                    vpClass.getExtends().add((Object)taEClass);
                }
                ++n2;
            }
        }
    }

    private boolean isLocalEType(ENamedElement eAttribute, EClassifier eClassifier) {
        if (eClassifier instanceof EEnum) {
            EObject enum_root_container = EcoreUtil.getRootContainer((EObject)eClassifier, (boolean)true);
            EObject eAttribute_root_container = EcoreUtil.getRootContainer((EObject)eAttribute, (boolean)true);
            return eAttribute_root_container.equals(enum_root_container);
        }
        return false;
    }

    private void reverseAnnotation(AnnotatableElement vpElement, EModelElement eElement) {
        for (EAnnotation eAnnotation : eElement.getEAnnotations()) {
            if (eAnnotation.getSource() != null && this.isEMDEAnnotation(eAnnotation)) continue;
            Annotation annotation = VpdescFactory.eINSTANCE.createAnnotation();
            String source = eAnnotation.getSource();
            annotation.setSource(source != null ? source : "");
            for (Map.Entry eDetail : eAnnotation.getDetails()) {
                String key = (String)eDetail.getKey();
                String value = (String)eDetail.getValue();
                Detail detail = VpdescFactory.eINSTANCE.createDetail();
                detail.setKey(key != null ? key : "");
                detail.setValue(value != null ? value : "");
                annotation.getOwned_details().add((Object)detail);
            }
            vpElement.getOwned_annotations().add((Object)annotation);
        }
    }

    private boolean isEMDEAnnotation(EAnnotation eAnnotation) {
        return eAnnotation.getSource().equals(eMDE_ANNOTATION_1) || eAnnotation.getSource().equals(eMDE_ANNOTATION_2);
    }

    private void reverseAttributes(Class vpClass, EClass eClass) {
        for (EAttribute eAttribute : eClass.getEAttributes()) {
            Attribute genAttribute = VpdescFactory.eINSTANCE.createAttribute();
            this.reverseAbstractFeatureProperties((AbstractFeature)genAttribute, (EStructuralFeature)eAttribute);
            vpClass.getVP_Class_Attributes().add((Object)genAttribute);
            String attributeName = eAttribute.getName();
            genAttribute.setName(attributeName);
            int lowerCase = eAttribute.getLowerBound();
            int upperCase = eAttribute.getUpperBound();
            Cardinalities cardinalities = this.transformCardnalities(lowerCase, upperCase);
            genAttribute.setCardinality(cardinalities);
            Object attribute_dataType = eAttribute.getEAttributeType();
            if (this.isLocalEType((ENamedElement)eAttribute, (EClassifier)attribute_dataType)) {
                if (attribute_dataType instanceof EEnum) {
                    Enumeration enumeration = this.reverseEnumerationsMapping_.get((EEnum)attribute_dataType);
                    if (enumeration == null) {
                        throw new RuntimeException("Enumeration " + ((EEnum)attribute_dataType).getName() + " was not imported correctely");
                    }
                    LocalAttributeType localtype = VpdescFactory.eINSTANCE.createLocalAttributeType();
                    localtype.setType(enumeration);
                    genAttribute.setOwned_type((AbstractAttributeType)localtype);
                }
            } else {
                attribute_dataType = attribute_dataType instanceof EEnum ? EcoreElementsUtil.transformEEnumToNsUriEEnum((EEnum)attribute_dataType) : EcoreElementsUtil.transformEDataTypeToNsUriEDataType(attribute_dataType);
                ExternalAttributeType type = VpdescFactory.eINSTANCE.createExternalAttributeType();
                type.setType(attribute_dataType);
                genAttribute.setOwned_type((AbstractAttributeType)type);
                this.reverseAdditionalExternalData(attribute_dataType.getEPackage());
            }
            this.monitorProgress(String.valueOf(eClass.getName()) + " : " + attributeName);
            this.registerToReverseAnnotation((EModelElement)eAttribute, (AnnotatableElement)genAttribute);
        }
    }

    private void reverseOperations(Class vpClass, EClass eClass) {
        for (EOperation eOperation : eClass.getEOperations()) {
            AbstractType operationType;
            Operation operation = VpdescFactory.eINSTANCE.createOperation();
            operation.setName(eOperation.getName());
            EClassifier eOperationEType = eOperation.getEType();
            if (eOperationEType != null && (operationType = this.getAbstractTypeFrom(eOperationEType)) != null) {
                Cardinalities cardinalties = this.transformCardnalities(eOperation.getLowerBound(), eOperation.getUpperBound());
                if (cardinalties != null) {
                    operationType.setCardinality(cardinalties);
                }
                operation.setOperation_type(operationType);
            }
            for (EParameter eParameter : eOperation.getEParameters()) {
                AbstractType parameterType;
                Parameter parameter = VpdescFactory.eINSTANCE.createParameter();
                parameter.setName(eParameter.getName());
                EClassifier eParameterEType = eParameter.getEType();
                if (!this.isLocalEType((ENamedElement)eParameter, eParameterEType)) {
                    if (eParameterEType instanceof EClass) {
                        eParameterEType = EcoreElementsUtil.transformEClassToNsUriEClass((EClass)eParameterEType);
                    }
                    if (eParameterEType instanceof EDataType) {
                        eParameterEType = EcoreElementsUtil.transformEDataTypeToNsUriEDataType((EDataType)eParameterEType);
                    }
                }
                if (eParameterEType != null && (parameterType = this.getAbstractTypeFrom(eParameterEType)) != null) {
                    Cardinalities cardinalties = this.transformCardnalities(eParameter.getLowerBound(), eParameter.getUpperBound());
                    if (cardinalties != null) {
                        parameterType.setCardinality(cardinalties);
                    }
                    parameter.setParameter_type(parameterType);
                }
                operation.getParameters().add((Object)parameter);
            }
            vpClass.getVP_Class_Operations().add((Object)operation);
            this.registerToReverseAnnotation((EModelElement)eOperation, (AnnotatableElement)operation);
        }
    }

    private AbstractType getAbstractTypeFrom(EClassifier eClassifier) {
        ExternalType operationType = null;
        if (eClassifier instanceof EClass) {
            EClass eOperation_EClassType = (EClass)eClassifier;
            Class vpClassType = this.reverseClassesMapping_.get(eOperation_EClassType);
            if (vpClassType != null) {
                operationType = VpdescFactory.eINSTANCE.createLocalType();
                ((LocalType)operationType).setType((ViewpointClassifier)vpClassType);
            } else {
                operationType = VpdescFactory.eINSTANCE.createExternalType();
                EClass externalEClass = EcoreElementsUtil.transformEClassToNsUriEClass(eOperation_EClassType);
                operationType.setType((EClassifier)externalEClass);
                this.reverseAdditionalExternalData(externalEClass.getEPackage());
            }
        } else if (eClassifier instanceof EEnum) {
            EEnum eOperation_eEnumType = (EEnum)eClassifier;
            Enumeration enumeration = this.reverseEnumerationsMapping_.get(eOperation_eEnumType);
            if (enumeration != null) {
                operationType = VpdescFactory.eINSTANCE.createLocalType();
                ((LocalType)operationType).setType((ViewpointClassifier)enumeration);
            } else {
                operationType = VpdescFactory.eINSTANCE.createExternalType();
                operationType.setType((EClassifier)eOperation_eEnumType);
                this.reverseAdditionalExternalData(eOperation_eEnumType.getEPackage());
            }
        } else {
            operationType = VpdescFactory.eINSTANCE.createExternalType();
            eClassifier = EcoreElementsUtil.transformEDataTypeToNsUriEDataType((EDataType)eClassifier);
            operationType.setType(eClassifier);
            this.reverseAdditionalExternalData(eClassifier.getEPackage());
        }
        return operationType;
    }

    private void reverseAbstractFeatureProperties(AbstractFeature abstractFeature, EStructuralFeature eFeature) {
        if (abstractFeature != null && eFeature != null) {
            abstractFeature.setChangeable(eFeature.isChangeable());
            abstractFeature.setDerived(eFeature.isDerived());
            abstractFeature.setOrdered(eFeature.isOrdered());
            abstractFeature.setTransient(eFeature.isTransient());
            abstractFeature.setUnique(eFeature.isUnique());
            abstractFeature.setUnsettable(eFeature.isUnsettable());
            abstractFeature.setVolatile(eFeature.isVolatile());
            if (abstractFeature instanceof Attribute) {
                Attribute attribute = (Attribute)abstractFeature;
                EAttribute eAttribute = (EAttribute)eFeature;
                attribute.setIsId(eAttribute.isID());
            }
        }
    }

    private void reverseAssociationsRelationships(Class vpClass, EClass eClass) {
        for (EReference iEReference : eClass.getEReferences()) {
            EClassifier refType = iEReference.getEType();
            LocalClassAssociation association = null;
            if (refType instanceof EClass) {
                EClass eClassRefType = (EClass)refType;
                Class vpClassType = this.reverseClassesMapping_.get(eClassRefType);
                if (vpClassType != null) {
                    association = VpdescFactory.eINSTANCE.createLocalClassAssociation();
                    association.setLocalTarget(vpClassType);
                } else {
                    association = VpdescFactory.eINSTANCE.createExternalClassAssociation();
                    EClass externalEClass = EcoreElementsUtil.transformEClassToNsUriEClass(eClassRefType);
                    ((ExternalClassAssociation)association).setExternalTarget(externalEClass);
                    this.reverseAdditionalExternalData(externalEClass.getEPackage());
                }
            }
            if (association != null) {
                association.setName(iEReference.getName());
                association.setCardinality(this.transformCardnalities(iEReference.getLowerBound(), iEReference.getUpperBound()));
                association.setType(iEReference.isContainment() ? Association_Types.CONTAINMENT : Association_Types.REFERENCE);
                vpClass.getVP_Classes_Associations().add((Object)association);
            }
            if (association != null) {
                this.reverseAbstractFeatureProperties((AbstractFeature)association, (EStructuralFeature)iEReference);
            }
            this.monitorProgress(String.valueOf(eClass.getName()) + " : " + association.getName());
            this.registerToReverseAnnotation((EModelElement)iEReference, (AnnotatableElement)association);
        }
    }

    private Cardinalities transformCardnalities(int lowerBound, int upperBound) {
        switch (lowerBound) {
            case 0: {
                switch (upperBound) {
                    case 1: {
                        return Cardinalities.NOTHING_OR_ONE;
                    }
                    case -1: {
                        return Cardinalities.NOTHING_OR_MANY;
                    }
                }
                break;
            }
            case 1: {
                switch (upperBound) {
                    case 1: {
                        return Cardinalities.ONLY_ONE;
                    }
                    case -1: {
                        return Cardinalities.ONE_OR_MANY;
                    }
                }
            }
        }
        return Cardinalities.NOTHING_OR_MANY;
    }

    private void reverseInheritanceRelationships(Class vpClass, EClass eClass) {
        for (EClass iEClass : eClass.getESuperTypes()) {
            if (this.reverseClassesMapping_.containsKey(iEClass)) {
                Class clazz = this.reverseClassesMapping_.get(iEClass);
                LocalSuperClass localSuperClass = VpdescFactory.eINSTANCE.createLocalSuperClass();
                localSuperClass.setSuperClass(clazz);
                vpClass.getInheritences().add((Object)localSuperClass);
            } else if (!ReverseUtil.isGeneratedInheritance(vpClass, iEClass, this.ePackage.eResource())) {
                EClass externalEClass = EcoreElementsUtil.transformEClassToNsUriEClass(iEClass);
                ExternalSuperClass externalSuperClass = VpdescFactory.eINSTANCE.createExternalSuperClass();
                externalSuperClass.setSuperClass(externalEClass);
                vpClass.getInheritences().add((Object)externalSuperClass);
                this.reverseAdditionalExternalData(externalEClass.getEPackage());
            }
            this.monitorProgress(String.valueOf(vpClass.getName()) + " Super type (" + iEClass.getName() + ")");
        }
    }

    private void reverseAdditionalExternalData(EPackage externalEPackage) {
        if (!this.isEPackageFromTargetApplication(externalEPackage)) {
            Data data = this.viewpoint.getVP_Data();
            data.getAdditionalExternalData().add((Object)externalEPackage);
            this.addEMFResource(externalEPackage);
        }
    }

    private void addEMFResource(EPackage ePackage) {
        URI uri;
        ViewpointResources viewpointResources = this.viewpoint.getViewpointResources();
        if (viewpointResources == null) {
            viewpointResources = VpdescFactory.eINSTANCE.createViewpointResources();
            this.viewpoint.setViewpointResources(viewpointResources);
        }
        if ((uri = ePackage.eResource().getURI()) != null) {
            boolean addResource = true;
            String uri_s = uri.toString();
            EList usedResources = viewpointResources.getUseResource();
            if (usedResources != null && !usedResources.isEmpty()) {
                for (AbstractResource abstractResource : usedResources) {
                    String emfResourceUri;
                    if (!(abstractResource instanceof EMFResource) || !(emfResourceUri = ((EMFResource)abstractResource).getUri()).equals(uri_s)) continue;
                    addResource = false;
                    break;
                }
            }
            if (addResource) {
                EMFResource emfResource = VpdescFactory.eINSTANCE.createEMFResource();
                emfResource.setUri(uri_s);
                this.viewpoint.getViewpointResources().getUseResource().add((Object)emfResource);
            }
        }
    }

    private boolean isEPackageFromTargetApplication(EPackage ePackage) {
        if (this.targetApplicationEPackages.contains(ePackage)) {
            return true;
        }
        for (EPackage iEPackage : this.targetApplicationEPackages) {
            EPackage rootEPackage;
            boolean found;
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)iEPackage);
            if (!(rootContainer instanceof EPackage) || !(found = this.findEPackageInTargetApplicationMetaModels(rootEPackage = (EPackage)rootContainer, ePackage))) continue;
            return true;
        }
        return false;
    }

    private boolean findEPackageInTargetApplicationMetaModels(EPackage rootEPackage, EPackage wantedEPackage) {
        if (rootEPackage.getNsURI().equals(wantedEPackage.getNsURI())) {
            return true;
        }
        EList eSubpackages = rootEPackage.getESubpackages();
        if (eSubpackages != null && eSubpackages.size() > 0) {
            if (eSubpackages.contains((Object)wantedEPackage)) {
                return true;
            }
            Iterator iterator = eSubpackages.iterator();
            if (iterator.hasNext()) {
                EPackage iEPackage = (EPackage)iterator.next();
                if (iEPackage.getNsURI().equals(wantedEPackage.getNsURI())) {
                    return true;
                }
                return this.findEPackageInTargetApplicationMetaModels(iEPackage, wantedEPackage);
            }
        }
        return false;
    }

    private void loadTargetApplicationEPackages() {
        ArrayList<String> regexNsUris;
        List<EPackage> ePackages;
        String targetApplication = VpDslConfigurationHelper.getTargetApplication((Object)this.viewpoint);
        Map nsUris = TargetApplicationExtensionManager.getTargetApplicationMetaModels((String)targetApplication);
        List stringNsUris = (List)nsUris.get("String");
        if (stringNsUris != null && (ePackages = ReverseUtil.getEPackagesByNsUri(stringNsUris)) != null && ePackages.size() > 0) {
            this.targetApplicationEPackages.addAll(ePackages);
        }
        if ((regexNsUris = (ArrayList<String>)nsUris.get("Regex")) == null) {
            regexNsUris = new ArrayList<String>();
        }
        regexNsUris.add("http://www.eclipse.org/emf/\\d{4}/Ecore");
        regexNsUris.add("http://www.polarsys.org/kitalpha/emde/(\\d+(\\.\\d+(\\.\\d+)))");
        if (regexNsUris != null && (ePackages = ReverseUtil.getEPackagesByNsUriRegex(regexNsUris)) != null && ePackages.size() > 0) {
            this.targetApplicationEPackages.addAll(ePackages);
        }
    }

    private void registerToReverseAnnotation(EModelElement eElement, AnnotatableElement vpElement) {
        this.annotationElementMapping_.put(eElement, vpElement);
    }

    private void monitorProgress(String current) {
        this.monitor.subTask(current);
        this.monitor.worked(1);
    }

    private int reversibleElementCount() {
        int result = 0;
        for (EClassifier iEClassifier : this.eClassifiersToReverse) {
            if (!(iEClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)iEClassifier;
            ++result;
            result += eClass.getEReferences().size();
            result += eClass.getEAttributes().size();
            result += eClass.getESuperTypes().size();
            result += eClass.getEOperations().size();
            result += eClass.getEAnnotations().size();
            if (eClass.getEAnnotation(eMDE_ANNOTATION_1) != null) {
                --result;
            }
            if (eClass.getEAnnotation(eMDE_ANNOTATION_2) == null) continue;
            --result;
        }
        return result;
    }

    private void addEnumerationMapEntry(EEnum source, Enumeration generated) {
        if (this.reverseEnumerationsMapping_.containsKey(source)) {
            if (!this.reverseEnumerationsMapping_.get(source).equals(generated)) {
                throw new RuntimeException();
            }
        } else {
            this.reverseEnumerationsMapping_.put(source, generated);
        }
    }

    private void addClassMapEntry(EClass source, Class generated) {
        if (this.reverseClassesMapping_.containsKey(source)) {
            if (!this.reverseClassesMapping_.get(source).equals(generated)) {
                throw new RuntimeException();
            }
        } else {
            this.reverseClassesMapping_.put(source, generated);
        }
    }

    public boolean isFlattenEPackages() {
        return this.flattenEPackages;
    }

    public void setFlattenEPackages(boolean flattenEPackages) {
        this.flattenEPackages = flattenEPackages;
    }

    public boolean isAddSeperator() {
        return this.addSeperator;
    }

    public void setAddSeperator(boolean addSeperator) {
        this.addSeperator = addSeperator;
    }

    public ConflictingNameResloveStrategy getNameConflictResolveStrategy() {
        return this.nameConflictResolveStrategy;
    }

    public void setNameConflictResolveStrategy(ConflictingNameResloveStrategy nameConflictResolveStrategy) {
        this.nameConflictResolveStrategy = nameConflictResolveStrategy;
    }
}

