/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.internal.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.composer.Activator;
import org.polarsys.kitalpha.composer.api.profiles.ComposerProfile;
import org.polarsys.kitalpha.composer.api.profiles.IComposerProfileRegistry;
import org.polarsys.kitalpha.composer.api.profiles.IProfileDelta;
import org.polarsys.kitalpha.composer.api.profiles.IProfileRegistryChangeListener;
import org.polarsys.kitalpha.composer.api.profiles.ParameterProfileElement;
import org.polarsys.kitalpha.composer.api.profiles.ParameterizedProfileElement;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.internal.profiles.ProfileDelta;
import org.polarsys.kitalpha.composer.internal.profiles.ProfileRegistryChangeEvent;

public class ComposerProfileRegistry
implements IComposerProfileRegistry {
    private static final String BINDING_MM_URI_CHILD = "businessMetamodelNsUriDeclaration";
    private Map<String, Set<ComposerProfile>> registeredProfiles;
    private boolean enableNotification = true;
    private Set<IProfileRegistryChangeListener> listeners = new HashSet<IProfileRegistryChangeListener>();

    public ComposerProfileRegistry() {
        this.registeredProfiles = new HashMap<String, Set<ComposerProfile>>();
        this.loadFromExtensions();
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)new ComposerProfileRegistryListener(), "org.polarsys.kitalpha.composer.core");
    }

    @Override
    public void register(ComposerProfile profile) {
        Set<ComposerProfile> profiles = this.registeredProfiles.get(profile.getAllocationBinding());
        if (profiles == null) {
            profiles = new HashSet<ComposerProfile>();
            this.registeredProfiles.put(profile.getAllocationBinding(), profiles);
        }
        if (profiles.add(profile)) {
            IProfileDelta[] deltas = new IProfileDelta[]{new ProfileDelta(0, profile)};
            this.fireRegistryChangeEvent(deltas);
        }
    }

    @Override
    public void unregister(ComposerProfile profile) {
        Set<ComposerProfile> profiles = this.registeredProfiles.get(profile.getAllocationBinding());
        if (profiles != null) {
            profiles.remove(profile);
            if (profiles.isEmpty()) {
                this.registeredProfiles.remove(profile.getAllocationBinding());
            }
            IProfileDelta[] deltas = new IProfileDelta[]{new ProfileDelta(1, profile)};
            this.fireRegistryChangeEvent(deltas);
        }
    }

    @Override
    public Set<ComposerProfile> getAllRegisteredProfiles() {
        HashSet<ComposerProfile> result = new HashSet<ComposerProfile>();
        for (Set<ComposerProfile> profiles : this.registeredProfiles.values()) {
            result.addAll(profiles);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public ComposerProfile getById(String id) {
        for (ComposerProfile composerProfile : this.getAllRegisteredProfiles()) {
            if (!composerProfile.getId().equals(id)) continue;
            return composerProfile;
        }
        return null;
    }

    @Override
    public Set<ComposerProfile> getByAllocationNsURI(String allocationNsURI) {
        Set<ComposerProfile> result = this.registeredProfiles.get(allocationNsURI);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<ComposerProfile> getBySemanticNsURI(String semanticNsURI) {
        HashSet<String> allocationNsUris = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = CodeManagerExtensions.getAllBindingExtensions();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement bindingElement = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = bindingElement.getChildren(BINDING_MM_URI_CHILD);
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement businessMMUriDeclaration = iConfigurationElementArray2[n4];
                String uri = businessMMUriDeclaration.getAttribute("NsUri");
                if (uri.equals(semanticNsURI)) {
                    allocationNsUris.add(bindingElement.getAttribute("NsUri"));
                }
                ++n4;
            }
            ++n2;
        }
        HashSet<ComposerProfile> result = new HashSet<ComposerProfile>();
        for (String allocationNsUri : allocationNsUris) {
            result.addAll(this.getByAllocationNsURI(allocationNsUri));
        }
        return Collections.unmodifiableSet(result);
    }

    private void loadFromExtensions() {
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.polarsys.kitalpha.composer.profile").getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("composerProfile".equals(configurationElement.getName())) {
                    this.registerProfile(configurationElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void registerProfile(IConfigurationElement configurationElement) {
        ComposerProfile composerProfile = new ComposerProfile();
        composerProfile.setId(configurationElement.getAttribute("id"));
        composerProfile.setName(configurationElement.getAttribute("name"));
        composerProfile.setAllocationBinding(configurationElement.getAttribute("allocationNsUri"));
        composerProfile.setAllocationBindingId(configurationElement.getAttribute("bindingId"));
        IConfigurationElement[] strategy = configurationElement.getChildren("strategy");
        if (strategy.length != 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        composerProfile.setStrategy(this.createParameterizedProfileElement(strategy[0]));
        IConfigurationElement[] refinery = configurationElement.getChildren("refinery");
        if (refinery.length != 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        composerProfile.setRefinery(this.createParameterizedProfileElement(refinery[0]));
        IConfigurationElement[] generator = configurationElement.getChildren("generator");
        if (generator.length != 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        composerProfile.setGenerator(this.createParameterizedProfileElement(generator[0]));
        this.createCadenceActivities(composerProfile, configurationElement);
        this.createLibraries(composerProfile, configurationElement);
        this.register(composerProfile);
    }

    private void createLibraries(ComposerProfile composerProfile, IConfigurationElement configurationElement) {
        IConfigurationElement[] libraries;
        IConfigurationElement[] iConfigurationElementArray = libraries = configurationElement.getChildren("libraries");
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IConfigurationElement[] selectedLib = element.getChildren("library");
            ArrayList<String> idLibs = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray2 = selectedLib;
            int n3 = selectedLib.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement e = iConfigurationElementArray2[n4];
                idLibs.add(e.getAttribute("id"));
                ++n4;
            }
            composerProfile.setLibraries(idLibs);
            ++n2;
        }
    }

    private void createCadenceActivities(ComposerProfile composerProfile, IConfigurationElement configurationElement) {
        IConfigurationElement[] afterGenerator;
        IConfigurationElement[] beforeGenerator;
        IConfigurationElement[] beforeRefinery;
        IConfigurationElement[] beforeStrategy = configurationElement.getChildren("beforeStrategyActivities");
        if (beforeStrategy.length > 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        if (beforeStrategy.length == 1) {
            List<ParameterizedProfileElement> elements = this.createParameterizedProfileElements(beforeStrategy[0].getChildren("activity"));
            for (ParameterizedProfileElement activity : elements) {
                composerProfile.getBeforeStrategyActivities().add(activity);
            }
        }
        if ((beforeRefinery = configurationElement.getChildren("beforeRefineryActivities")).length > 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        if (beforeRefinery.length == 1) {
            List<ParameterizedProfileElement> elements = this.createParameterizedProfileElements(beforeRefinery[0].getChildren("activity"));
            for (ParameterizedProfileElement activity : elements) {
                composerProfile.getBeforeRefineryActivities().add(activity);
            }
        }
        if ((beforeGenerator = configurationElement.getChildren("beforeGeneratorActivities")).length > 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        if (beforeGenerator.length == 1) {
            List<ParameterizedProfileElement> elements = this.createParameterizedProfileElements(beforeGenerator[0].getChildren("activity"));
            for (ParameterizedProfileElement activity : elements) {
                composerProfile.getBeforeGeneratorActivities().add(activity);
            }
        }
        if ((afterGenerator = configurationElement.getChildren("afterGeneratorActivities")).length > 1) {
            this.invalidProfile(composerProfile.getName());
            return;
        }
        if (afterGenerator.length == 1) {
            List<ParameterizedProfileElement> elements = this.createParameterizedProfileElements(afterGenerator[0].getChildren("activity"));
            for (ParameterizedProfileElement activity : elements) {
                composerProfile.getAfterGeneratorActivities().add(activity);
            }
        }
    }

    private List<ParameterizedProfileElement> createParameterizedProfileElements(IConfigurationElement[] elements) {
        ArrayList<ParameterizedProfileElement> result = new ArrayList<ParameterizedProfileElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            result.add(this.createParameterizedProfileElement(element));
            ++n2;
        }
        return result;
    }

    private ParameterizedProfileElement createParameterizedProfileElement(IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute("id");
        ParameterizedProfileElement parameterizedProfileElement = new ParameterizedProfileElement(id);
        IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement parameterConfigurationElement = iConfigurationElementArray[n2];
            if ("parameter".equals(parameterConfigurationElement.getName())) {
                String name = parameterConfigurationElement.getAttribute("parameterName");
                String value = parameterConfigurationElement.getAttribute("parameterValue");
                ParameterProfileElement parameterProfileElement = new ParameterProfileElement(name, value);
                parameterizedProfileElement.addParameter(parameterProfileElement);
            }
            ++n2;
        }
        return parameterizedProfileElement;
    }

    private void invalidProfile(String name) {
        Status status = new Status(4, "org.polarsys.kitalpha.composer.core", "Invalid profile: " + name);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    @Override
    public void addRegistryChangeListener(IProfileRegistryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRegistryChangeListener(IProfileRegistryChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireRegistryChangeEvent(IProfileDelta[] deltas) {
        if (this.enableNotification) {
            ProfileRegistryChangeEvent event = new ProfileRegistryChangeEvent(this, deltas);
            for (IProfileRegistryChangeListener listener : this.listeners) {
                listener.registryChanged(event);
            }
        }
    }

    private class ComposerProfileRegistryListener
    implements IRegistryChangeListener {
        private ComposerProfileRegistryListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas("org.polarsys.kitalpha.composer.core", "org.polarsys.kitalpha.composer.profile");
            int n = iExtensionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                IConfigurationElement[] iConfigurationElementArray;
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                IExtension affectedExtension = delta.getExtension();
                if (delta.getKind() == 2) {
                    iConfigurationElementArray = affectedExtension.getConfigurationElements();
                    n4 = iConfigurationElementArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IConfigurationElement element = iConfigurationElementArray[n3];
                        if ("composerProfile".equals(element.getName())) {
                            String profileId = element.getAttribute("id");
                            ComposerProfile correspondingProfile = ComposerProfileRegistry.this.getById(profileId);
                            ComposerProfileRegistry.this.unregister(correspondingProfile);
                        }
                        ++n3;
                    }
                } else if (delta.getKind() == 1) {
                    iConfigurationElementArray = affectedExtension.getConfigurationElements();
                    n4 = iConfigurationElementArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IConfigurationElement configurationElement = iConfigurationElementArray[n3];
                        if ("composerProfile".equals(configurationElement.getName())) {
                            ComposerProfileRegistry.this.registerProfile(configurationElement);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    }
}

