/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloud.Cloudlet;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.eclipse.kura.core.configuration.RollbackCallable;
import org.eclipse.kura.core.configuration.UpdateConfigurationsCallable;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.XmlSnapshotIdResult;
import org.eclipse.kura.core.configuration.util.XmlUtil;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigurationHandler
extends Cloudlet {
    private static Logger s_logger = LoggerFactory.getLogger(CloudConfigurationHandler.class);
    public static final String APP_ID = "CONF-V1";
    public static final String RESOURCE_CONFIGURATIONS = "configurations";
    public static final String RESOURCE_SNAPSHOTS = "snapshots";
    public static final String RESOURCE_SNAPSHOT = "snapshot";
    public static final String RESOURCE_ROLLBACK = "rollback";
    private SystemService m_systemService;
    private ScheduledExecutorService m_executor;
    private ServiceTrackerAdapter m_serviceTrackerAdapter;
    private ConfigurationServiceImpl m_configService;

    public CloudConfigurationHandler(BundleContext context, ConfigurationServiceImpl configService, SystemService systemService) {
        super(APP_ID);
        this.m_serviceTrackerAdapter = new ServiceTrackerAdapter(context);
        this.m_configService = configService;
        this.m_systemService = systemService;
    }

    public void open() {
        this.m_executor = Executors.newSingleThreadScheduledExecutor();
        this.m_serviceTrackerAdapter.open();
    }

    public void close() {
        this.m_serviceTrackerAdapter.close();
        this.m_executor.shutdownNow();
    }

    protected void doGet(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String[] resources = reqTopic.getResources();
        if (resources == null || resources.length == 0) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one resource but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        if (resources[0].equals(RESOURCE_CONFIGURATIONS)) {
            this.doGetConfigurations(reqTopic, (KuraPayload)reqPayload, respPayload);
        } else if (resources[0].equals(RESOURCE_SNAPSHOTS)) {
            this.doGetSnapshots(reqTopic, (KuraPayload)reqPayload, respPayload);
        } else {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Cannot find resource with name: {}", (Object)resources[0]);
            respPayload.setResponseCode(404);
            return;
        }
    }

    protected void doPut(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String[] resources = reqTopic.getResources();
        if (resources == null || resources.length == 0) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one resource but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        if (!resources[0].equals(RESOURCE_CONFIGURATIONS)) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Cannot find resource with name: {}", (Object)resources[0]);
            respPayload.setResponseCode(404);
            return;
        }
        this.doPutConfigurations(reqTopic, (KuraPayload)reqPayload, respPayload);
    }

    protected void doExec(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String[] resources = reqTopic.getResources();
        if (resources == null || resources.length == 0) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one resource but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        if (resources[0].equals(RESOURCE_SNAPSHOT)) {
            this.doExecSnapshot(reqTopic, (KuraPayload)reqPayload, respPayload);
        } else if (resources[0].equals(RESOURCE_ROLLBACK)) {
            this.doExecRollback(reqTopic, (KuraPayload)reqPayload, respPayload);
        } else {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Cannot find resource with name: {}", (Object)resources[0]);
            respPayload.setResponseCode(404);
            return;
        }
    }

    private void doGetSnapshots(CloudletTopic reqTopic, KuraPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String snapshotId;
        String[] resources = reqTopic.getResources();
        if (resources.length > 2) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one or two resource(s) but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        String string = snapshotId = resources.length == 2 ? resources[1] : null;
        if (snapshotId != null) {
            long sid = Long.parseLong(snapshotId);
            XmlComponentConfigurations configs = this.m_configService.loadSnapshot(sid);
            byte[] body = CloudConfigurationHandler.toResponseBody(configs);
            respPayload.setBody(body);
        } else {
            Set<Long> sids = null;
            try {
                sids = this.m_configService.getSnapshots();
            }
            catch (KuraException e) {
                s_logger.error("Error listing snapshots: {}", (Throwable)e);
                throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_LISTING, (Throwable)e, new Object[0]);
            }
            ArrayList<Long> snapshotIds = new ArrayList<Long>(sids);
            XmlSnapshotIdResult xmlResult = new XmlSnapshotIdResult();
            xmlResult.setSnapshotIds(snapshotIds);
            byte[] body = CloudConfigurationHandler.toResponseBody(xmlResult);
            respPayload.setBody(body);
        }
    }

    private void doGetConfigurations(CloudletTopic reqTopic, KuraPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String[] resources = reqTopic.getResources();
        if (resources.length > 2) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected at most two resource(s) but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        String pid = resources.length == 2 ? resources[1] : null;
        ArrayList<ComponentConfigurationImpl> configs = new ArrayList<ComponentConfigurationImpl>();
        try {
            if (pid == null) {
                List pidsToIgnore = this.m_systemService.getDeviceManagementServiceIgnore();
                Set<String> componentPids = this.m_configService.getConfigurableComponentPids();
                for (String componentPid : componentPids) {
                    boolean skip = false;
                    if (pidsToIgnore != null && !pidsToIgnore.isEmpty()) {
                        for (String pidToIgnore : pidsToIgnore) {
                            if (!componentPid.equals(pidToIgnore)) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (skip) continue;
                    ComponentConfiguration cc = this.m_configService.getComponentConfiguration(componentPid);
                    if (cc == null) {
                        s_logger.error("null ComponentConfiguration");
                        continue;
                    }
                    if (cc.getPid() == null || cc.getPid().isEmpty()) {
                        s_logger.error("null or empty ComponentConfiguration PID");
                        continue;
                    }
                    if (cc.getDefinition() == null) {
                        s_logger.error("null OCD for ComponentConfiguration PID {}", (Object)cc.getPid());
                        continue;
                    }
                    if (cc.getDefinition().getId() == null || cc.getDefinition().getId().isEmpty()) {
                        s_logger.error("null or empty OCD ID for ComponentConfiguration PID {}. OCD ID: {}", (Object)cc.getPid(), (Object)cc.getDefinition().getId());
                        continue;
                    }
                    configs.add((ComponentConfigurationImpl)cc);
                }
            } else {
                ComponentConfiguration cc = this.m_configService.getComponentConfiguration(pid);
                if (cc != null) {
                    configs.add((ComponentConfigurationImpl)cc);
                }
            }
        }
        catch (KuraException e) {
            s_logger.error("Error getting component configurations: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[]{"Error getting component configurations"});
        }
        XmlComponentConfigurations xmlConfigs = new XmlComponentConfigurations();
        xmlConfigs.setConfigurations(configs);
        byte[] body = CloudConfigurationHandler.toResponseBody(xmlConfigs);
        respPayload.setBody(body);
    }

    private void doPutConfigurations(CloudletTopic reqTopic, KuraPayload reqPayload, KuraResponsePayload respPayload) {
        String[] resources = reqTopic.getResources();
        if (resources.length > 2) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected at most two resource(s) but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        String pid = resources.length == 2 ? resources[1] : null;
        XmlComponentConfigurations xmlConfigs = null;
        try {
            if (reqPayload.getBody() == null || reqPayload.getBody().length == 0) {
                throw new IllegalArgumentException("body");
            }
            String s = new String(reqPayload.getBody(), "UTF-8");
            s_logger.info("Received new Configuration...");
            s_logger.info(s);
            StringReader sr = new StringReader(s);
            xmlConfigs = XmlUtil.unmarshal(sr, XmlComponentConfigurations.class);
        }
        catch (Exception e) {
            s_logger.error("Error unmarshalling the request body: {}", (Throwable)e);
            respPayload.setResponseCode(400);
            respPayload.setException((Throwable)e);
            return;
        }
        this.m_executor.schedule(new UpdateConfigurationsCallable(pid, xmlConfigs, this.m_configService), 1000L, TimeUnit.MILLISECONDS);
    }

    private void doExecRollback(CloudletTopic reqTopic, KuraPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        Long sid;
        String[] resources = reqTopic.getResources();
        if (resources.length > 2) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected at most two resource(s) but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        String snapshotId = resources.length == 2 ? resources[1] : null;
        try {
            sid = snapshotId != null ? Long.valueOf(Long.parseLong(snapshotId)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            s_logger.error("Bad numeric numeric format for snapshot ID: {}", (Object)snapshotId);
            respPayload.setResponseCode(400);
            return;
        }
        this.m_executor.schedule(new RollbackCallable(sid, this.m_configService), 1000L, TimeUnit.MILLISECONDS);
    }

    private void doExecSnapshot(CloudletTopic reqTopic, KuraPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        long snapshotId;
        String[] resources = reqTopic.getResources();
        if (resources.length > 1) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one resource(s) but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        try {
            snapshotId = this.m_configService.snapshot();
        }
        catch (KuraException e) {
            s_logger.error("Error taking snapshot: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_TAKING, (Throwable)e, new Object[0]);
        }
        ArrayList<Long> snapshotIds = new ArrayList<Long>();
        snapshotIds.add(snapshotId);
        XmlSnapshotIdResult xmlResult = new XmlSnapshotIdResult();
        xmlResult.setSnapshotIds(snapshotIds);
        byte[] body = CloudConfigurationHandler.toResponseBody(xmlResult);
        respPayload.setBody(body);
    }

    private static byte[] toResponseBody(Object o) throws KuraException {
        StringWriter sw = new StringWriter();
        try {
            XmlUtil.marshal(o, sw);
        }
        catch (JAXBException e) {
            s_logger.error("Error marshalling snapshots: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_LOADING, (Throwable)e, new Object[0]);
        }
        byte[] body = null;
        try {
            body = sw.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            s_logger.error("Error encoding response body: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_LOADING, (Throwable)e, new Object[0]);
        }
        return body;
    }

    private class ServiceTrackerAdapter
    extends ServiceTracker<CloudService, CloudService> {
        private ServiceTrackerAdapter(BundleContext context) {
            super(context, CloudService.class, null);
        }

        public CloudService addingService(ServiceReference<CloudService> ref) {
            CloudService cloudService = (CloudService)this.context.getService(ref);
            CloudConfigurationHandler.this.setCloudService(cloudService);
            CloudConfigurationHandler.this.activate(null);
            return cloudService;
        }

        public void removedService(ServiceReference<CloudService> ref, CloudService service) {
            CloudConfigurationHandler.this.deactivate(null);
            CloudConfigurationHandler.this.unsetCloudService(null);
        }

        public void close() {
            CloudConfigurationHandler.this.deactivate(null);
            CloudConfigurationHandler.this.unsetCloudService(null);
            super.close();
        }
    }
}

