/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    public static boolean isCompressed(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }

    public static byte[] compress(byte[] source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipos = null;
        try {
            gzipos = new GZIPOutputStream(baos);
            gzipos.write(source);
        }
        catch (Throwable throwable) {
            if (gzipos != null) {
                try {
                    gzipos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (gzipos != null) {
            try {
                gzipos.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public static byte[] decompress(byte[] source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        GZIPInputStream gzipis = null;
        try {
            int n;
            gzipis = new GZIPInputStream(bais);
            byte[] buf = new byte[1024];
            while ((n = gzipis.read(buf, 0, 1024)) != -1) {
                baos.write(buf, 0, n);
            }
        }
        catch (Throwable throwable) {
            if (gzipis != null) {
                try {
                    gzipis.close();
                }
                catch (IOException iOException) {}
            }
            try {
                baos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (gzipis != null) {
            try {
                gzipis.close();
            }
            catch (IOException iOException) {}
        }
        try {
            baos.close();
        }
        catch (IOException iOException) {}
        return baos.toByteArray();
    }
}

