/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.microedition.io.Datagram;

public abstract class AbstractDatagram
implements Datagram {
    protected byte[] data;
    private int pos;
    private int count;

    public AbstractDatagram(int size) {
        this(new byte[size]);
    }

    public AbstractDatagram(byte[] data) {
        this.data = data;
        this.pos = 0;
        this.count = data.length;
    }

    public AbstractDatagram(byte[] data, int start, int length) {
        if (start > data.length || start + length > data.length) {
            throw new IllegalArgumentException("Start possition or length is greater than data length");
        }
        this.data = data;
        this.pos = start;
        this.count = length;
    }

    public synchronized byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.count;
    }

    public int getOffset() {
        return this.pos;
    }

    public void setLength(int len) {
        if (len < 0 || len > this.data.length) {
            throw new IllegalArgumentException("Given length is negative or greater than buffer size");
        }
        this.count = len;
    }

    public synchronized void setData(byte[] buffer, int offset, int len) {
        if (offset > buffer.length || offset + len > buffer.length) {
            throw new IllegalArgumentException();
        }
        this.data = buffer;
        this.pos = offset;
        this.count = len;
    }

    public void reset() {
        this.pos = 0;
        this.count = 0;
    }

    public int read() {
        return this.pos < this.count ? this.data[this.pos++] & 0xFF : -1;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int ch = this.read();
            if (ch < 0) {
                throw new EOFException();
            }
            b[off + n++] = (byte)ch;
        }
    }

    public int skipBytes(int n) throws IOException {
        if (this.pos + n > this.count) {
            n = this.count - this.pos;
        }
        if (n < 0) {
            return 0;
        }
        this.pos += n;
        return n;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new RuntimeException("Function not supported");
    }

    public String readUTF() throws IOException {
        return AbstractDatagram.readUTF(this);
    }

    public static final String readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return ((Object)str).toString();
    }

    public void write(int b) throws IOException {
        if (this.pos < this.data.length) {
            this.data[this.pos++] = (byte)b;
        } else {
            byte[] buf = new byte[this.data.length + 1];
            System.arraycopy(this.data, 0, buf, 0, this.count);
            this.data = buf;
            this.data[this.pos++] = (byte)b;
            ++this.count;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write((byte)s.charAt(i));
            ++i;
        }
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
            ++i;
        }
    }

    public void writeUTF(String str) throws IOException {
        AbstractDatagram.writeUTF(str, this);
    }

    static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        out.write(bytearr);
        return utflen + 2;
    }

    public abstract /* synthetic */ void setAddress(Datagram var1);

    public abstract /* synthetic */ void setAddress(String var1) throws IOException;

    public abstract /* synthetic */ String getAddress();
}

