/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.status;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.status.LedManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxLedManager
implements LedManager {
    private static final Logger logger = LoggerFactory.getLogger(LinuxLedManager.class);
    private final String brightnessPath;

    public LinuxLedManager(String ledPath) {
        this.brightnessPath = String.valueOf(ledPath) + "/brightness";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeLed(boolean enabled) throws KuraException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileWriter ledFileWriter = new FileWriter(this.brightnessPath);
                try {
                    try (BufferedWriter ledBufferedWriter = new BufferedWriter(ledFileWriter);){
                        if (enabled) {
                            ledBufferedWriter.write("1");
                        } else {
                            ledBufferedWriter.write("0");
                        }
                        ledBufferedWriter.flush();
                    }
                    if (ledFileWriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (ledFileWriter == null) throw throwable;
                    ledFileWriter.close();
                    throw throwable;
                }
                ledFileWriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            logger.error("Error accessing the specified LED!");
            throw new KuraException(KuraErrorCode.UNAVAILABLE_DEVICE);
        }
    }
}

