/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;

public class JmsDefaultDeserializationPolicy
implements JmsDeserializationPolicy {
    public static final String CATCH_ALL_WILDCARD = "*";
    public static final String WHITELIST_PROPERTY = "org.apache.qpid.jms.deserialization.white_list";
    public static final String BLACKLIST_PROPERTY = "org.apache.qpid.jms.deserialization.black_list";
    private List<String> whiteList = new ArrayList<String>();
    private List<String> blackList = new ArrayList<String>();

    public JmsDefaultDeserializationPolicy() {
        String whitelist = System.getProperty(WHITELIST_PROPERTY, CATCH_ALL_WILDCARD);
        this.setWhiteList(whitelist);
        String blackList = System.getProperty(BLACKLIST_PROPERTY);
        this.setBlackList(blackList);
    }

    public JmsDefaultDeserializationPolicy(JmsDefaultDeserializationPolicy source) {
        this.whiteList.addAll(source.whiteList);
        this.blackList.addAll(source.blackList);
    }

    @Override
    public JmsDeserializationPolicy copy() {
        return new JmsDefaultDeserializationPolicy(this);
    }

    @Override
    public boolean isTrustedType(JmsDestination destination, Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        String className = clazz.getCanonicalName();
        if (className == null) {
            className = clazz.getName();
        }
        for (String blackListEntry : this.blackList) {
            if (CATCH_ALL_WILDCARD.equals(blackListEntry)) {
                return false;
            }
            if (!this.isClassOrPackageMatch(className, blackListEntry)) continue;
            return false;
        }
        for (String whiteListEntry : this.whiteList) {
            if (CATCH_ALL_WILDCARD.equals(whiteListEntry)) {
                return true;
            }
            if (!this.isClassOrPackageMatch(className, whiteListEntry)) continue;
            return true;
        }
        return false;
    }

    private final boolean isClassOrPackageMatch(String className, String listEntry) {
        if (className == null) {
            return false;
        }
        if (className.equals(listEntry)) {
            return true;
        }
        int entryLength = listEntry.length();
        return className.length() > entryLength && className.startsWith(listEntry) && '.' == className.charAt(entryLength);
    }

    public String getWhiteList() {
        Iterator<String> entries = this.whiteList.iterator();
        StringBuilder builder = new StringBuilder();
        while (entries.hasNext()) {
            builder.append(entries.next());
            if (!entries.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public String getBlackList() {
        Iterator<String> entries = this.blackList.iterator();
        StringBuilder builder = new StringBuilder();
        while (entries.hasNext()) {
            builder.append(entries.next());
            if (!entries.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public void setWhiteList(String whiteList) {
        ArrayList<String> list = new ArrayList<String>();
        if (whiteList != null && !whiteList.isEmpty()) {
            list.addAll(Arrays.asList(whiteList.split(",")));
        }
        this.whiteList = list;
    }

    public void setBlackList(String blackList) {
        ArrayList<String> list = new ArrayList<String>();
        if (blackList != null && !blackList.isEmpty()) {
            list.addAll(Arrays.asList(blackList.split(",")));
        }
        this.blackList = list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.whiteList == null ? 0 : this.whiteList.hashCode());
        result = 31 * result + (this.blackList == null ? 0 : this.blackList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsDefaultDeserializationPolicy other = (JmsDefaultDeserializationPolicy)obj;
        if (this.whiteList == null ? other.whiteList != null : !this.whiteList.equals(other.whiteList)) {
            return false;
        }
        return !(this.blackList == null ? other.blackList != null : !this.blackList.equals(other.blackList));
    }
}

