/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.kura.KuraBluetoothConnectionException;
import org.eclipse.kura.KuraBluetoothPairException;
import org.eclipse.kura.KuraBluetoothRemoveException;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.internal.ble.BluetoothLeAdapterImpl;
import org.eclipse.kura.internal.ble.BluetoothLeGattServiceImpl;
import tinyb.BluetoothDevice;
import tinyb.BluetoothException;
import tinyb.BluetoothGattService;

public class BluetoothLeDeviceImpl
implements BluetoothLeDevice {
    private static final long TIMEOUT = 30L;
    private final BluetoothDevice device;

    public BluetoothLeDeviceImpl(BluetoothDevice device) {
        this.device = device;
    }

    public BluetoothLeGattService findService(UUID uuid) throws KuraBluetoothResourceNotFoundException {
        return this.findService(uuid, 30L);
    }

    public BluetoothLeGattService findService(UUID uuid, long timeout) throws KuraBluetoothResourceNotFoundException {
        BluetoothGattService service = this.device.find(uuid.toString(), Duration.ofSeconds(timeout));
        if (service != null) {
            return new BluetoothLeGattServiceImpl(service);
        }
        throw new KuraBluetoothResourceNotFoundException((Object)"Gatt service not found.");
    }

    public List<BluetoothLeGattService> findServices() throws KuraBluetoothResourceNotFoundException {
        List tinybServices = this.device.getServices();
        ArrayList<BluetoothLeGattService> services = new ArrayList<BluetoothLeGattService>();
        if (tinybServices != null) {
            for (BluetoothGattService service : tinybServices) {
                services.add(new BluetoothLeGattServiceImpl(service));
            }
        } else {
            throw new KuraBluetoothResourceNotFoundException((Object)"Gatt services not found.");
        }
        return services;
    }

    public void disconnect() throws KuraBluetoothConnectionException {
        try {
            this.device.disconnect();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothConnectionException((Throwable)e, (Object)"Disconnection from device failed");
        }
    }

    public void connect() throws KuraBluetoothConnectionException {
        try {
            this.device.connect();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothConnectionException((Throwable)e, (Object)"Connection to device failed");
        }
    }

    public void connectProfile(UUID uuid) throws KuraBluetoothConnectionException {
        try {
            this.device.connectProfile(uuid.toString());
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothConnectionException((Throwable)e, (Object)"Connection to profile failed");
        }
    }

    public void disconnectProfile(UUID uuid) throws KuraBluetoothConnectionException {
        try {
            this.device.disconnectProfile(uuid.toString());
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothConnectionException((Throwable)e, (Object)"Disconnection from profile failed");
        }
    }

    public void pair() throws KuraBluetoothPairException {
        try {
            this.device.pair();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothPairException((Throwable)e, (Object)"Pairing failed");
        }
    }

    public void cancelPairing() throws KuraBluetoothPairException {
        try {
            this.device.cancelPairing();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothPairException((Throwable)e, (Object)"Cancel pairing failed");
        }
    }

    public String getAddress() {
        return this.device.getAddress();
    }

    public String getName() {
        return this.device.getName();
    }

    public String getAlias() {
        return this.device.getAlias();
    }

    public void setAlias(String value) {
        this.device.setAlias(value);
    }

    public int getBluetoothClass() {
        return this.device.getBluetoothClass();
    }

    public short getAppearance() {
        return this.device.getAppearance();
    }

    public String getIcon() {
        return this.device.getIcon();
    }

    public boolean isPaired() {
        return this.device.getPaired();
    }

    public boolean isTrusted() {
        return this.device.getTrusted();
    }

    public void setTrusted(boolean value) {
        this.device.setTrusted(value);
    }

    public boolean isBlocked() {
        return this.device.getBlocked();
    }

    public void setBlocked(boolean value) {
        this.device.setBlocked(value);
    }

    public boolean isLegacyPairing() {
        return this.device.getLegacyPairing();
    }

    public short getRSSI() {
        return this.device.getRSSI();
    }

    public boolean isConnected() {
        return this.device.getConnected();
    }

    public UUID[] getUUIDs() {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        String[] stringArray = this.device.getUUIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            uuidList.add(UUID.fromString(uuid));
            ++n2;
        }
        UUID[] uuids = new UUID[uuidList.size()];
        return uuidList.toArray(uuids);
    }

    public String getModalias() {
        return this.device.getModalias();
    }

    public BluetoothLeAdapter getAdapter() {
        return new BluetoothLeAdapterImpl(this.device.getAdapter());
    }

    public Map<Short, byte[]> getManufacturerData() {
        return this.device.getManufacturerData();
    }

    public Map<UUID, byte[]> getServiceData() {
        HashMap<UUID, byte[]> serviceData = new HashMap<UUID, byte[]>();
        for (Map.Entry entry : this.device.getServiceData().entrySet()) {
            serviceData.put(UUID.fromString((String)entry.getKey()), (byte[])entry.getValue());
        }
        return serviceData;
    }

    public short getTxPower() {
        return this.device.getTxPower();
    }

    public boolean isServicesResolved() {
        return this.device.getServicesResolved();
    }

    public boolean remove() throws KuraBluetoothRemoveException {
        boolean result = false;
        try {
            result = this.device.remove();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothRemoveException((Throwable)e, (Object)"Failed to remove the device");
        }
        return result;
    }
}

