/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.ibeacon;

import java.util.Arrays;
import java.util.UUID;
import org.eclipse.kura.ble.ibeacon.BluetoothLeIBeacon;
import org.eclipse.kura.ble.ibeacon.BluetoothLeIBeaconDecoder;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeIBeaconDecoderImpl
implements BluetoothLeIBeaconDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeIBeaconDecoderImpl.class);
    private static final byte[] BEACON_ID = new byte[]{2, 21};
    private static final byte[] COMPANY_CODE;
    private static final byte[] IBEACON_PREFIX;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = 76;
        COMPANY_CODE = byArray;
        IBEACON_PREFIX = new byte[]{COMPANY_CODE[1], COMPANY_CODE[0], BEACON_ID[0], BEACON_ID[1]};
    }

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le IBeacon Codec...");
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Le IBeacon Codec...");
    }

    public Class<BluetoothLeIBeacon> getBeaconType() {
        return BluetoothLeIBeacon.class;
    }

    public BluetoothLeIBeacon decode(byte[] reportData) {
        return BluetoothLeIBeaconDecoderImpl.parseEIRData(reportData);
    }

    private static BluetoothLeIBeacon parseEIRData(byte[] b) {
        int ptr = 0;
        while (ptr < b.length) {
            byte structSize = b[ptr];
            if (structSize == 0) break;
            byte dataType = b[ptr + 1];
            if (dataType == -1 && Arrays.equals(IBEACON_PREFIX, Arrays.copyOfRange(b, ptr + 2, ptr + 2 + IBEACON_PREFIX.length)) && ptr > 0) {
                BluetoothLeIBeacon beacon = new BluetoothLeIBeacon();
                beacon.setLeLimited((b[ptr - 1] & 1) == 1);
                beacon.setLeGeneral((b[ptr - 1] & 2) == 2);
                beacon.setBrEdrSupported((b[ptr - 1] & 4) == 4);
                beacon.setLeBrController((b[ptr - 1] & 8) == 8);
                beacon.setLeBrHost((b[ptr - 1] & 0x10) == 16);
                int uuidPtr = ptr + 2 + IBEACON_PREFIX.length;
                int majorPtr = uuidPtr + 16;
                int minorPtr = uuidPtr + 18;
                StringBuilder uuid = new StringBuilder();
                byte[] byArray = Arrays.copyOfRange(b, uuidPtr, majorPtr);
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte ub = byArray[n2];
                    uuid.append(String.format("%02X", ub));
                    ++n2;
                }
                beacon.setUuid(UUID.fromString(uuid.toString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5")));
                int majorl = b[majorPtr + 1] & 0xFF;
                int majorh = b[majorPtr] & 0xFF;
                int minorl = b[minorPtr + 1] & 0xFF;
                int minorh = b[minorPtr] & 0xFF;
                beacon.setMajor((short)(majorh << 8 | majorl));
                beacon.setMinor((short)(minorh << 8 | minorl));
                beacon.setTxPower(b[minorPtr + 2]);
                return beacon;
            }
            ptr += structSize + 1;
        }
        return null;
    }
}

