/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.web.server.util.ServiceLocator;

public class AuthenticationManager {
    private static AuthenticationManager instance;
    private char[] password;
    private String username;

    public static AuthenticationManager getInstance() {
        if (instance == null) {
            instance = new AuthenticationManager();
        }
        return instance;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    protected void setPassword(char[] psw) {
        this.password = psw;
    }

    public boolean authenticate(String username, String password) throws KuraException {
        Objects.requireNonNull(this.username);
        Objects.requireNonNull(this.password);
        try {
            CryptoService cryptoService = ServiceLocator.getInstance().getService(CryptoService.class);
            String sha1Password = cryptoService.sha1Hash(password);
            boolean isUsernameMatching = username.equals(this.username);
            boolean isPasswordMatching = Arrays.equals(sha1Password.toCharArray(), this.password);
            return isUsernameMatching && isPasswordMatching;
        }
        catch (Exception exception) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
    }
}

