/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraStoreCapacityReachedException;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.core.data.DataMessage;
import org.eclipse.kura.core.data.DataStore;
import org.eclipse.kura.core.data.store.HouseKeeperTask;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDataStore
implements DataStore {
    private static final String TOPIC_ELEMENT = "topic";
    private static final String UPDATE = "UPDATE ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String SELECT_MESSAGE_METADATA_FROM = "SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, priority, sessionId, droppedOn FROM ";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final Logger logger = LoggerFactory.getLogger(DbDataStore.class);
    private static final String DATA_SERVICE_REPAIR_ENABLED_PROPNAME = "db.store.repair.enabled";
    private H2DbService dbService;
    private final Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private ScheduledExecutorService houseKeeperExecutor;
    private ScheduledFuture<?> houseKeeperTask;
    private int capacity;
    private final String tableName;
    private final String sanitizedTableName;
    private final String sqlCreateTable;
    private final String sqlCreateIndex;
    private final String sqlMessageCount;
    private final String sqlResetId;
    private final String sqlStore;
    private final String sqlGetMessage;
    private final String sqlGetNextMessage;
    private final String sqlSetPublished;
    private final String sqlSetPublished2;
    private final String sqlSetConfirmed;
    private final String sqlAllUnpublishedMessages;
    private final String sqlAllInFlightMessages;
    private final String sqlAllDroppedInFlightMessages;
    private final String sqlUnpublishAllInFlightMessages;
    private final String sqlDropAllInFlightMessages;
    private final String sqlDeleteDroppedMessages;
    private final String sqlDeleteConfirmedMessages;
    private final String sqlDeletePublishedMessages;
    private final String sqlDuplicateCount;
    private final String sqlDropPrimaryKey;
    private final String sqlDeleteDuplicates;
    private final String sqlCreatePrimaryKey;

    public DbDataStore(String table) {
        this.tableName = table;
        this.sanitizedTableName = this.sanitizeSql(table);
        this.sqlCreateTable = "CREATE TABLE IF NOT EXISTS " + this.sanitizedTableName + " (id INTEGER IDENTITY PRIMARY KEY, topic VARCHAR(32767 CHAR), qos INTEGER, retain BOOLEAN, createdOn TIMESTAMP, publishedOn TIMESTAMP, publishedMessageId INTEGER, confirmedOn TIMESTAMP, payload VARBINARY(16777216), priority INTEGER, sessionId VARCHAR(32767 CHAR), droppedOn TIMESTAMP);";
        this.sqlCreateIndex = "CREATE INDEX IF NOT EXISTS " + this.sanitizeSql(String.valueOf(this.tableName) + "_nextMsg") + " ON " + this.sanitizedTableName + " (publishedOn ASC NULLS FIRST, priority ASC, createdOn ASC, qos);";
        this.sqlMessageCount = "SELECT COUNT(*) FROM " + this.sanitizedTableName + ";";
        this.sqlResetId = ALTER_TABLE + this.sanitizedTableName + " ALTER COLUMN id RESTART WITH 1;";
        this.sqlStore = "INSERT INTO " + this.sanitizedTableName + " (topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, payload, priority, sessionId, droppedOn) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        this.sqlGetMessage = "SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, payload, priority, sessionId, droppedOn FROM " + this.sanitizedTableName + " WHERE id = ?";
        this.sqlGetNextMessage = "SELECT a.id, a.topic, a.qos, a.retain, a.createdOn, a.publishedOn, a.publishedMessageId, a.confirmedOn, a.payload, a.priority, a.sessionId, a.droppedOn FROM " + this.sanitizedTableName + " AS a JOIN (SELECT id, publishedOn FROM " + this.sanitizedTableName + " ORDER BY publishedOn ASC NULLS FIRST, priority ASC, createdOn ASC LIMIT 1) AS b WHERE a.id = b.id AND b.publishedOn IS NULL;";
        this.sqlSetPublished = UPDATE + this.sanitizedTableName + " SET publishedOn = ?, publishedMessageId = ?, sessionId = ? WHERE id = ?;";
        this.sqlSetPublished2 = UPDATE + this.sanitizedTableName + " SET publishedOn = ? WHERE id = ?;";
        this.sqlSetConfirmed = UPDATE + this.sanitizedTableName + " SET confirmedOn = ? WHERE id = ?;";
        this.sqlAllUnpublishedMessages = SELECT_MESSAGE_METADATA_FROM + this.sanitizedTableName + " WHERE publishedOn IS NULL ORDER BY priority ASC, createdOn ASC;";
        this.sqlAllInFlightMessages = SELECT_MESSAGE_METADATA_FROM + this.sanitizedTableName + " WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL AND droppedOn IS NULL ORDER BY priority ASC, createdOn ASC";
        this.sqlAllDroppedInFlightMessages = SELECT_MESSAGE_METADATA_FROM + this.sanitizedTableName + " WHERE droppedOn IS NOT NULL ORDER BY priority ASC, createdOn ASC;";
        this.sqlUnpublishAllInFlightMessages = UPDATE + this.sanitizedTableName + " SET publishedOn = NULL WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL;";
        this.sqlDropAllInFlightMessages = UPDATE + this.sanitizedTableName + " SET droppedOn = ? WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL;";
        this.sqlDeleteDroppedMessages = DELETE_FROM + this.sanitizedTableName + " WHERE droppedOn <= DATEADD('ss', -?, ?) AND droppedOn IS NOT NULL;";
        this.sqlDeleteConfirmedMessages = DELETE_FROM + this.sanitizedTableName + " WHERE confirmedOn <= DATEADD('ss', -?, ?) AND confirmedOn IS NOT NULL;";
        this.sqlDeletePublishedMessages = DELETE_FROM + this.sanitizedTableName + " WHERE qos = 0 AND publishedOn <= DATEADD('ss', -?, ?) AND publishedOn IS NOT NULL;";
        this.sqlDuplicateCount = "SELECT count(*) FROM (SELECT id, COUNT(id) FROM " + this.sanitizedTableName + " GROUP BY id HAVING (COUNT(id) > 1)) dups;";
        this.sqlDropPrimaryKey = ALTER_TABLE + this.sanitizedTableName + " DROP PRIMARY KEY;";
        this.sqlDeleteDuplicates = DELETE_FROM + this.sanitizedTableName + " WHERE id IN (SELECT id FROM " + this.sanitizedTableName + " GROUP BY id HAVING COUNT(*) > 1);";
        this.sqlCreatePrimaryKey = ALTER_TABLE + this.sanitizedTableName + " ADD PRIMARY KEY (id);";
    }

    private String sanitizeSql(String string) {
        String sanitizedName = string.replaceAll("\"", "\"\"");
        return "\"" + sanitizedName + "\"";
    }

    @Override
    public synchronized void start(H2DbService dbService, int houseKeeperInterval, int purgeAge, int capacity) throws KuraStoreException {
        this.dbService = dbService;
        this.houseKeeperExecutor = Executors.newSingleThreadScheduledExecutor();
        this.update(houseKeeperInterval, purgeAge, capacity);
    }

    @Override
    public synchronized void stop() {
        logger.info("Canceling the Housekeeper Task...");
        if (this.houseKeeperTask != null) {
            this.houseKeeperTask.cancel(true);
            this.houseKeeperExecutor.shutdownNow();
            this.houseKeeperTask = null;
        }
        this.dbService = null;
    }

    private boolean isRepairEnabled() {
        ServiceReference reference;
        BundleContext context = FrameworkUtil.getBundle(DbDataStore.class).getBundleContext();
        SystemService systemService = (SystemService)context.getService(reference = context.getServiceReference(SystemService.class));
        if (systemService == null) {
            return false;
        }
        try {
            String isRepairEnabled = systemService.getProperties().getProperty(DATA_SERVICE_REPAIR_ENABLED_PROPNAME);
            boolean bl = "true".equalsIgnoreCase(isRepairEnabled);
            return bl;
        }
        finally {
            context.ungetService(reference);
        }
    }

    @Override
    public synchronized void update(int houseKeeperInterval, int purgeAge, int capacity) {
        this.capacity = capacity;
        try {
            if (this.houseKeeperTask != null) {
                this.houseKeeperTask.cancel(true);
            }
            this.execute(this.sqlCreateTable, new Integer[0]);
            this.execute(this.sqlCreateIndex, new Integer[0]);
            this.createIndex(this.sanitizeSql(String.valueOf(this.tableName) + "_PUBLISHEDON"), this.sanitizedTableName, "(PUBLISHEDON DESC)");
            this.createIndex(this.sanitizeSql(String.valueOf(this.tableName) + "_CONFIRMEDON"), this.sanitizedTableName, "(CONFIRMEDON DESC)");
            this.createIndex(this.sanitizeSql(String.valueOf(this.tableName) + "_DROPPEDON"), this.sanitizedTableName, "(DROPPEDON DESC)");
            this.houseKeeperTask = this.houseKeeperExecutor.scheduleWithFixedDelay(new HouseKeeperTask(this, purgeAge, this.isRepairEnabled()), 1L, houseKeeperInterval, TimeUnit.SECONDS);
        }
        catch (KuraStoreException e) {
            logger.warn("got exception while creating tables", (Throwable)e);
        }
    }

    private synchronized int getMessageCount() throws KuraStoreException {
        return (Integer)this.withConnection(c -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                PreparedStatement stmt = c.prepareStatement(this.sqlMessageCount);
                try {
                    Integer n;
                    block17: {
                        ResultSet rs = stmt.executeQuery();
                        try {
                            if (rs.next()) {
                                n = rs.getInt(1);
                                return n;
                            }
                            Integer n2 = -1;
                            return n2;
                        }
                        finally {
                            if (rs == null) break block17;
                            rs.close();
                        }
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    return n;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }, "Cannot get message count");
    }

    private synchronized void resetIdentityGenerator() throws KuraStoreException {
        this.execute(this.sqlResetId, new Integer[0]);
    }

    @Override
    public synchronized DataMessage store(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        if (this.dbService == null) {
            throw new KuraStoreException((Object)"DbService instance not attached");
        }
        if (topic == null || topic.trim().length() == 0) {
            throw new IllegalArgumentException(TOPIC_ELEMENT);
        }
        if (priority != 0 && priority != 1) {
            int count = this.getMessageCount();
            logger.debug("Store message count: {}", (Object)count);
            if (count >= this.capacity) {
                logger.error("Store capacity exceeded");
                throw new KuraStoreCapacityReachedException((Object)"Store capacity exceeded");
            }
        }
        DataMessage message = null;
        try {
            message = this.storeInternal(topic, payload, qos, retain, priority);
        }
        catch (KuraStoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                SQLException sqle = (SQLException)cause;
                int errorCode = sqle.getErrorCode();
                if (errorCode == 22003) {
                    logger.warn("Identity generator limit exceeded. Resetting it...");
                    this.resetIdentityGenerator();
                    message = this.storeInternal(topic, payload, qos, retain, priority);
                }
                throw e;
            }
            throw e;
        }
        return message;
    }

    private synchronized DataMessage storeInternal(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        if (topic == null || topic.trim().length() == 0) {
            throw new IllegalArgumentException(TOPIC_ELEMENT);
        }
        Timestamp now = new Timestamp(new Date().getTime());
        int msgId = (Integer)this.withConnection(c -> {
            int result;
            block22: {
                result = -1;
                Throwable throwable = null;
                Object var10_12 = null;
                try (PreparedStatement pstmt = c.prepareStatement(this.sqlStore);){
                    pstmt.setString(1, topic);
                    pstmt.setInt(2, qos);
                    pstmt.setBoolean(3, retain);
                    pstmt.setTimestamp(4, now, this.utcCalendar);
                    pstmt.setTimestamp(5, null);
                    pstmt.setInt(6, -1);
                    pstmt.setTimestamp(7, null);
                    pstmt.setBytes(8, payload);
                    pstmt.setInt(9, priority);
                    pstmt.setString(10, null);
                    pstmt.setTimestamp(11, null);
                    pstmt.execute();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                throwable = null;
                var10_12 = null;
                try {
                    PreparedStatement cstmt = c.prepareStatement("CALL IDENTITY();");
                    try {
                        try (ResultSet rs = cstmt.executeQuery();){
                            if (rs != null && rs.next()) {
                                result = rs.getInt(1);
                            }
                        }
                        if (cstmt == null) break block22;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (cstmt == null) throw throwable;
                        cstmt.close();
                        throw throwable;
                    }
                    cstmt.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            c.commit();
            return result;
        }, "Cannot store message");
        return this.get(msgId);
    }

    @Override
    public synchronized DataMessage get(int msgId) throws KuraStoreException {
        return (DataMessage)this.withConnection(c -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, "Cannot get message by ID: " + msgId);
    }

    @Override
    public synchronized DataMessage getNextMessage() throws KuraStoreException {
        return (DataMessage)this.withConnection(c -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                PreparedStatement stmt = c.prepareStatement(this.sqlGetNextMessage);
                try {
                    DataMessage dataMessage;
                    block18: {
                        ResultSet rs = stmt.executeQuery();
                        try {
                            if (rs == null) {
                            }
                            if (rs.next()) {
                                dataMessage = this.buildDataMessage(rs);
                                return dataMessage;
                            }
                        }
                        finally {
                            if (rs == null) break block18;
                            rs.close();
                        }
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    return dataMessage;
                    {
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }, "Cannot get message next message");
    }

    @Override
    public synchronized void published(int msgId, int publishedMsgId, String sessionId) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        this.withConnection(c -> {
            Throwable throwable = null;
            Object var7_8 = null;
            try (PreparedStatement stmt = c.prepareStatement(this.sqlSetPublished);){
                stmt.setTimestamp(1, now, this.utcCalendar);
                stmt.setInt(2, publishedMsgId);
                stmt.setString(3, sessionId);
                stmt.setInt(4, msgId);
                stmt.execute();
                c.commit();
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, "Cannot update timestamp");
    }

    @Override
    public synchronized void published(int msgId) throws KuraStoreException {
        this.updateTimestamp(this.sqlSetPublished2, msgId);
    }

    @Override
    public synchronized void confirmed(int msgId) throws KuraStoreException {
        this.updateTimestamp(this.sqlSetConfirmed, msgId);
    }

    @Override
    public synchronized List<DataMessage> allUnpublishedMessagesNoPayload() throws KuraStoreException {
        return this.listMessages(this.sqlAllUnpublishedMessages, new Integer[0]);
    }

    @Override
    public synchronized List<DataMessage> allInFlightMessagesNoPayload() throws KuraStoreException {
        return this.listMessages(this.sqlAllInFlightMessages, new Integer[0]);
    }

    @Override
    public synchronized List<DataMessage> allDroppedInFlightMessagesNoPayload() throws KuraStoreException {
        return this.listMessages(this.sqlAllDroppedInFlightMessages, new Integer[0]);
    }

    @Override
    public synchronized void unpublishAllInFlighMessages() throws KuraStoreException {
        this.execute(this.sqlUnpublishAllInFlightMessages, new Integer[0]);
    }

    @Override
    public synchronized void dropAllInFlightMessages() throws KuraStoreException {
        this.updateTimestamp(this.sqlDropAllInFlightMessages, new Integer[0]);
    }

    @Override
    public synchronized void deleteStaleMessages(int purgeAge) throws KuraStoreException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.executeDeleteMessagesQuery(this.sqlDeleteDroppedMessages, now, purgeAge);
        this.executeDeleteMessagesQuery(this.sqlDeleteConfirmedMessages, now, purgeAge);
        this.executeDeleteMessagesQuery(this.sqlDeletePublishedMessages, now, purgeAge);
    }

    @Override
    public synchronized void repair() throws KuraStoreException {
        this.withConnection(c -> {
            Statement stmt;
            Object var4_7;
            Throwable throwable;
            int count;
            block29: {
                count = -1;
                throwable = null;
                var4_7 = null;
                try {
                    PreparedStatement pstmt = c.prepareStatement(this.sqlDuplicateCount);
                    try {
                        try (ResultSet rs = pstmt.executeQuery();){
                            if (rs.next()) {
                                count = rs.getInt(1);
                            }
                        }
                        if (pstmt == null) break block29;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (pstmt == null) throw throwable;
                        pstmt.close();
                        throw throwable;
                    }
                    pstmt.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (count <= 0) {
                return null;
            }
            logger.error("Found messages with duplicate ID. Count of IDs for which duplicates exist: {}. Attempting to repair...", (Object)count);
            throwable = null;
            var4_7 = null;
            try {
                stmt = c.createStatement();
                try {
                    stmt.execute(this.sqlDropPrimaryKey);
                    logger.info("Primary key dropped");
                    stmt.execute(this.sqlDeleteDuplicates);
                    logger.info("Duplicate messages deleted");
                    stmt.execute(this.sqlCreatePrimaryKey);
                    logger.info("Primary key created");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
            c.commit();
            throwable = null;
            var4_7 = null;
            try {
                stmt = c.prepareStatement("CHECKPOINT");
                try {
                    stmt.execute();
                    logger.info("Checkpoint");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
            c.commit();
            return null;
        }, "Cannot repair database");
    }

    private synchronized void updateTimestamp(String sql, Integer ... msgIds) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        this.withConnection(c -> {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement stmt = c.prepareStatement(sql);){
                stmt.setTimestamp(1, now, this.utcCalendar);
                int i = 0;
                while (i < msgIds.length) {
                    stmt.setInt(2 + i, msgIds[i]);
                    ++i;
                }
                stmt.execute();
                c.commit();
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, "Cannot update timestamp");
    }

    private synchronized List<DataMessage> listMessages(String sql, Integer ... params) throws KuraStoreException {
        return (List)this.withConnection(c -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, "Cannot list messages");
    }

    private synchronized void execute(String sql, Integer ... params) throws KuraStoreException {
        this.withConnection(c -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (PreparedStatement stmt = c.prepareStatement(sql);){
                int i = 0;
                while (i < params.length) {
                    stmt.setInt(1 + i, params[i]);
                    ++i;
                }
                stmt.execute();
                c.commit();
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, "Cannot execute query");
    }

    private synchronized void executeDeleteMessagesQuery(String sql, Timestamp timestamp, int purgeAge) throws KuraStoreException {
        this.withConnection(c -> {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement stmt = c.prepareStatement(sql);){
                stmt.setInt(1, purgeAge);
                stmt.setTimestamp(2, timestamp, this.utcCalendar);
                stmt.execute();
                c.commit();
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, "Cannot execute query");
    }

    private void createIndex(String indexname, String table, String order) throws KuraStoreException {
        this.execute("CREATE INDEX IF NOT EXISTS " + indexname + " ON " + table + " " + order + ";", new Integer[0]);
        logger.debug("Index {} created, order is {}", (Object)indexname, (Object)order);
    }

    private List<DataMessage> buildDataMessagesNoPayload(ResultSet rs) throws SQLException {
        ArrayList<DataMessage> messages = new ArrayList<DataMessage>();
        while (rs.next()) {
            messages.add(this.buildDataMessageNoPayload(rs));
        }
        return messages;
    }

    private DataMessage buildDataMessageNoPayload(ResultSet rs) throws SQLException {
        DataMessage.Builder builder = this.buildDataMessageBuilder(rs);
        return builder.build();
    }

    private DataMessage buildDataMessage(ResultSet rs) throws SQLException {
        DataMessage.Builder builder = this.buildDataMessageBuilder(rs);
        builder = builder.withPayload(rs.getBytes("payload"));
        return builder.build();
    }

    private DataMessage.Builder buildDataMessageBuilder(ResultSet rs) throws SQLException {
        DataMessage.Builder builder = new DataMessage.Builder(rs.getInt("id")).withTopic(rs.getString(TOPIC_ELEMENT)).withQos(rs.getInt("qos")).withRetain(rs.getBoolean("retain")).withCreatedOn(rs.getTimestamp("createdOn", this.utcCalendar)).withPublishedOn(rs.getTimestamp("publishedOn", this.utcCalendar)).withPublishedMessageId(rs.getInt("publishedMessageId")).withConfirmedOn(rs.getTimestamp("confirmedOn", this.utcCalendar)).withPriority(rs.getInt("priority")).withSessionId(rs.getString("sessionId")).withDroppedOn(rs.getTimestamp("droppedOn"));
        return builder;
    }

    private <T> T withConnection(H2DbService.ConnectionCallable<T> callable, String exceptionMessage) throws KuraStoreException {
        if (this.dbService == null) {
            throw new KuraStoreException((Object)"DbService instance not attached");
        }
        try {
            return (T)this.dbService.withConnection(callable);
        }
        catch (Exception e) {
            throw new KuraStoreException((Throwable)e, (Object)exceptionMessage);
        }
    }
}

