/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEnricherMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed Enricher")
public class ManagedEnricher
extends ManagedProcessor
implements ManagedEnricherMBean {
    private final Enricher processor;
    private String uri;
    private boolean sanitize;

    public ManagedEnricher(CamelContext context, Enricher processor, EnrichDefinition definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : false;
        this.uri = this.getDefinition().getExpression().getExpression();
        if (this.sanitize) {
            this.uri = URISupport.sanitizeUri(this.uri);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.processor.getEndpointUtilizationStatistics() != null) {
            this.processor.getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public EnrichDefinition getDefinition() {
        return (EnrichDefinition)super.getDefinition();
    }

    @Override
    public Enricher getProcessor() {
        return this.processor;
    }

    @Override
    public String getExpressionLanguage() {
        return this.getDefinition().getExpression().getLanguage();
    }

    @Override
    public String getExpression() {
        return this.uri;
    }

    @Override
    public Integer getCacheSize() {
        return this.processor.getCacheSize();
    }

    @Override
    public Boolean isIgnoreInvalidEndpoint() {
        return this.processor.isIgnoreInvalidEndpoint();
    }

    @Override
    public Boolean isShareUnitOfWork() {
        return this.processor.isShareUnitOfWork();
    }

    @Override
    public Boolean isAggregateOnException() {
        return this.processor.isAggregateOnException();
    }

    @Override
    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.processor.getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry<String, Long> entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri(url);
                    }
                    if ((hits = entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

