/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.linux.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.linux.util.ProcessStats;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.core.util.SafeProcess;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxProcessUtil {
    private static final Logger logger = LoggerFactory.getLogger(LinuxProcessUtil.class);
    private static final String PLATFORM_INTEL_EDISON = "intel-edison";
    private static volatile Boolean usingBusybox;

    public static int start(String command, boolean wait, boolean background) throws Exception {
        SafeProcess proc;
        block9: {
            int n;
            block10: {
                proc = null;
                try {
                    logger.info("executing: " + command);
                    proc = ProcessUtil.exec(command);
                    if (!wait) break block9;
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("Interrupted exception - ", (Throwable)e);
                    }
                    logger.info(String.valueOf(command) + " returned with exit value:" + proc.exitValue());
                    if (proc.exitValue() > 0) {
                        String stdout = LinuxProcessUtil.getInputStreamAsString(proc.getInputStream());
                        String stderr = LinuxProcessUtil.getInputStreamAsString(proc.getErrorStream());
                        logger.debug("stdout: {}", (Object)stdout);
                        logger.debug("stderr: {}", (Object)stderr);
                    }
                    n = proc.exitValue();
                    if (background || proc == null) break block10;
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (!background && proc != null) {
                            ProcessUtil.destroy(proc);
                        }
                        throw throwable;
                    }
                }
                ProcessUtil.destroy(proc);
            }
            return n;
        }
        if (!background && proc != null) {
            ProcessUtil.destroy(proc);
        }
        return 0;
    }

    public static int start(String command) throws Exception {
        return LinuxProcessUtil.start(command, true, false);
    }

    public static int start(String command, boolean wait) throws Exception {
        return LinuxProcessUtil.start(command, wait, false);
    }

    public static int start(String[] command, boolean wait) throws Exception {
        StringBuilder cmdBuilder = new StringBuilder();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            cmdBuilder.append(cmd).append(' ');
            ++n2;
        }
        return LinuxProcessUtil.start(cmdBuilder.toString(), wait);
    }

    public static int startBackground(String command, boolean wait) throws Exception {
        return LinuxProcessUtil.start(command, wait, true);
    }

    public static ProcessStats startWithStats(String command) throws Exception {
        SafeProcess proc = null;
        logger.info("executing: " + command);
        proc = ProcessUtil.exec(command);
        try {
            int exitVal = proc.waitFor();
            logger.info(String.valueOf(command) + " returned with exit value:" + exitVal);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("error executing " + command + " command" + e);
        }
        ProcessStats stats = new ProcessStats(proc);
        return stats;
    }

    public static ProcessStats startWithStats(String[] command) throws Exception {
        SafeProcess proc = null;
        StringBuilder cmdBuilder = new StringBuilder();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            cmdBuilder.append(cmd).append(' ');
            ++n2;
        }
        logger.debug("executing: {}", (Object)cmdBuilder);
        proc = ProcessUtil.exec(command);
        try {
            int exitVal = proc.waitFor();
            logger.debug("{} returned with exit value:{}", (Object)cmdBuilder, (Object)exitVal);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("error executing " + command + " command" + e);
        }
        ProcessStats stats = new ProcessStats(proc);
        return stats;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPid(String command) throws Exception {
        int n;
        BufferedReader br;
        SafeProcess proc;
        block10: {
            StringTokenizer st = null;
            String line = null;
            String pid = null;
            proc = null;
            br = null;
            if (command == null) return -1;
            if (command.isEmpty()) return -1;
            logger.trace("searching process list for {}", (Object)command);
            proc = LinuxProcessUtil.isUsingBusyBox() ? ProcessUtil.exec("ps") : ProcessUtil.exec("ps -ax");
            proc.waitFor();
            br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            do {
                if ((line = br.readLine()) == null) {
                    return -1;
                }
                st = new StringTokenizer(line);
                pid = st.nextToken();
                st.nextElement();
                st.nextElement();
                st.nextElement();
            } while ((line = line.substring(line.indexOf(st.nextToken()))).indexOf(command) < 0);
            logger.trace("found pid {} for command: {}", (Object)pid, (Object)command);
            n = Integer.parseInt(pid);
            if (br == null) break block10;
            br.close();
        }
        if (proc == null) return n;
        ProcessUtil.destroy(proc);
        return n;
        finally {
            if (br != null) {
                br.close();
            }
            if (proc != null) {
                ProcessUtil.destroy(proc);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPid(String command, String[] tokens) throws Exception {
        int n;
        BufferedReader br;
        SafeProcess proc;
        block12: {
            StringTokenizer st = null;
            String line = null;
            String pid = null;
            proc = null;
            br = null;
            if (command == null) return -1;
            if (command.isEmpty()) return -1;
            logger.trace("searching process list for {}", (Object)command);
            proc = LinuxProcessUtil.isUsingBusyBox() ? ProcessUtil.exec("ps") : ProcessUtil.exec("ps -ax");
            proc.waitFor();
            br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (true) {
                if ((line = br.readLine()) == null) {
                    return -1;
                }
                st = new StringTokenizer(line);
                pid = st.nextToken();
                st.nextElement();
                st.nextElement();
                st.nextElement();
                if ((line = line.substring(line.indexOf(st.nextToken()))).indexOf(command) < 0) continue;
                boolean allTokensPresent = true;
                String[] stringArray = tokens;
                int n2 = tokens.length;
                int n3 = 0;
                while (n3 < n2) {
                    String token = stringArray[n3];
                    if (!line.contains(token)) {
                        allTokensPresent = false;
                        break;
                    }
                    ++n3;
                }
                if (allTokensPresent) break;
            }
            logger.trace("found pid {} for command: {}", (Object)pid, (Object)command);
            n = Integer.parseInt(pid);
            if (br == null) break block12;
            br.close();
        }
        if (proc == null) return n;
        ProcessUtil.destroy(proc);
        return n;
        finally {
            if (br != null) {
                br.close();
            }
            if (proc != null) {
                ProcessUtil.destroy(proc);
            }
        }
    }

    public static int getKuraPid() throws Exception {
        int pid = -1;
        File kuraPidFile = new File("/var/run/kura.pid");
        if (kuraPidFile.exists()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(kuraPidFile));){
                pid = Integer.parseInt(br.readLine());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return pid;
    }

    public static boolean stop(int pid) {
        return LinuxProcessUtil.stop(pid, false);
    }

    public static boolean kill(int pid) {
        return LinuxProcessUtil.stop(pid, true);
    }

    public static boolean killAll(String command) {
        block3: {
            try {
                logger.info("attempting to kill process " + command);
                if (LinuxProcessUtil.start("killall " + command) != 0) break block3;
                logger.info("successfully killed process " + command);
                return true;
            }
            catch (Exception exception) {
                logger.warn("failed to kill process " + command);
                return false;
            }
        }
        logger.warn("failed to kill process " + command);
        return false;
    }

    public static String getInputStreamAsString(InputStream stream) throws IOException {
        StringBuffer sb = new StringBuffer();
        try (BufferedReader br = null;){
            int len;
            br = new BufferedReader(new InputStreamReader(stream));
            char[] cbuf = new char[1024];
            while ((len = br.read(cbuf)) > 0) {
                sb.append(cbuf, 0, len);
            }
        }
        return sb.toString();
    }

    public static boolean isProcessRunning(int pid) throws IOException {
        boolean bl;
        SafeProcess proc;
        block8: {
            boolean isRunning = false;
            proc = null;
            BufferedReader br = null;
            try {
                logger.trace("searching process list for pid{}", (Object)pid);
                proc = LinuxProcessUtil.isUsingBusyBox() ? ProcessUtil.exec("ps") : ProcessUtil.exec("ps -ax");
                proc.waitFor();
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if (LinuxProcessUtil.parsePid(line) != pid) continue;
                    isRunning = true;
                    break;
                }
                bl = isRunning;
                if (br == null) break block8;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        br.close();
                    }
                    if (proc != null) {
                        ProcessUtil.destroy(proc);
                    }
                    throw throwable;
                }
            }
            br.close();
        }
        if (proc != null) {
            ProcessUtil.destroy(proc);
        }
        return bl;
    }

    public static boolean stopAndKill(int pid) throws KuraException {
        try {
            if (pid >= 0) {
                logger.info("stopping pid={}", (Object)pid);
                boolean exists = LinuxProcessUtil.stop(pid);
                if (!exists) {
                    logger.warn("stopping pid={} has failed", (Object)pid);
                } else {
                    exists = LinuxProcessUtil.waitProcess(pid, 500L, 5000L);
                }
                if (exists) {
                    logger.info("killing pid={}", (Object)pid);
                    exists = LinuxProcessUtil.kill(pid);
                    if (!exists) {
                        logger.warn("killing pid={} has failed", (Object)pid);
                    } else {
                        exists = LinuxProcessUtil.waitProcess(pid, 500L, 5000L);
                    }
                }
                if (exists) {
                    logger.warn("Failed to stop process with pid {}", (Object)pid);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw KuraException.internalError((Throwable)e);
        }
    }

    private static boolean isUsingBusyBox() {
        if (usingBusybox != null) {
            return usingBusybox;
        }
        BundleContext ctx = FrameworkUtil.getBundle(LinuxProcessUtil.class).getBundleContext();
        ServiceReference systemServiceRef = ctx.getServiceReference(SystemService.class);
        if (systemServiceRef == null) {
            throw new IllegalStateException("Unable to find instance of: " + SystemService.class.getName());
        }
        SystemService service = (SystemService)ctx.getService(systemServiceRef);
        if (service == null) {
            throw new IllegalStateException("Unable to get instance of: " + SystemService.class.getName());
        }
        try {
            usingBusybox = PLATFORM_INTEL_EDISON.equals(service.getPlatform());
        }
        finally {
            ctx.ungetService(systemServiceRef);
        }
        return usingBusybox;
    }

    private static boolean stop(int pid, boolean kill) {
        boolean result = false;
        try {
            if (LinuxProcessUtil.isProcessRunning(pid)) {
                StringBuffer cmd = new StringBuffer();
                cmd.append("kill ");
                if (kill) {
                    cmd.append("-9 ");
                }
                cmd.append(pid);
                if (kill) {
                    logger.info("attempting to kill -9 pid {}", (Object)pid);
                } else {
                    logger.info("attempting to kill pid {}", (Object)pid);
                }
                if (LinuxProcessUtil.start(cmd.toString()) == 0) {
                    logger.info("successfully killed pid {}", (Object)pid);
                    result = true;
                } else {
                    logger.warn("failed to kill pid {}", (Object)pid);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("failed to kill pid {}", (Object)pid);
        }
        return result;
    }

    private static boolean waitProcess(int pid, long poll, long timeout) {
        boolean exists = false;
        try {
            long now;
            long startTime = System.currentTimeMillis();
            do {
                Thread.sleep(poll);
                exists = LinuxProcessUtil.isProcessRunning(pid);
                now = System.currentTimeMillis();
            } while (exists && now - startTime < timeout);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            logger.warn("Failed waiting for pid {} to exit - {}", (Object)pid, (Object)e);
        }
        return exists;
    }

    private static int parsePid(String line) {
        StringTokenizer st = new StringTokenizer(line);
        int processID = -1;
        try {
            processID = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            logger.warn("getPid() :: NumberFormatException reading PID - {}", (Throwable)e);
        }
        return processID;
    }
}

