/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.SelfConfiguringComponent;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableComponentTracker
extends ServiceTracker {
    private static final Logger s_logger = LoggerFactory.getLogger(ConfigurableComponentTracker.class);
    private final ConfigurationServiceImpl m_confService;

    public ConfigurableComponentTracker(BundleContext context, ConfigurationServiceImpl confService) throws InvalidSyntaxException {
        super(context, context.createFilter("(objectClass=*)"), null);
        this.m_confService = confService;
    }

    public void open(boolean trackAllServices) {
        block12: {
            s_logger.info("Opening ServiceTracker");
            super.open(trackAllServices);
            try {
                s_logger.info("Getting ServiceReferences");
                ServiceReference[] refs = this.context.getServiceReferences(null, null);
                if (refs == null) break block12;
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    String servicePid = (String)ref.getProperty("service.pid");
                    String pid = (String)ref.getProperty("kura.service.pid");
                    String factoryPid = (String)ref.getProperty("service.factoryPid");
                    if (servicePid != null) {
                        Object obj = this.context.getService(ref);
                        try {
                            if (obj == null) {
                                s_logger.info("Could not find service for: {}", (Object)ref);
                            } else if (obj instanceof ConfigurableComponent) {
                                s_logger.info("Adding ConfigurableComponent with pid {}, service pid {} and factory pid " + factoryPid, (Object)pid, (Object)servicePid);
                                this.m_confService.registerComponentConfiguration(pid, servicePid, factoryPid);
                            } else if (obj instanceof SelfConfiguringComponent) {
                                s_logger.info("Adding SelfConfiguringComponent with pid {} and service pid {}", (Object)pid, (Object)servicePid);
                                this.m_confService.registerSelfConfiguringComponent(pid, servicePid);
                            }
                        }
                        finally {
                            this.context.ungetService(ref);
                        }
                    }
                    ++n2;
                }
            }
            catch (InvalidSyntaxException ise) {
                s_logger.error("Error in addingBundle", (Throwable)ise);
            }
        }
    }

    public Object addingService(ServiceReference ref) {
        Object service = super.addingService(ref);
        String servicePid = (String)ref.getProperty("service.pid");
        String pid = (String)ref.getProperty("kura.service.pid");
        String factoryPid = (String)ref.getProperty("service.factoryPid");
        if (servicePid != null) {
            if (service instanceof ConfigurableComponent) {
                s_logger.info("Adding ConfigurableComponent with pid {}, service pid {} and factory pid " + factoryPid, (Object)pid, (Object)servicePid);
                this.m_confService.registerComponentConfiguration(pid, servicePid, factoryPid);
            } else if (service instanceof SelfConfiguringComponent) {
                s_logger.info("Adding SelfConfiguringComponent with pid {} and service pid {}", (Object)pid, (Object)servicePid);
                this.m_confService.registerSelfConfiguringComponent(pid, servicePid);
            }
        }
        return service;
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        String servicePid = (String)reference.getProperty("service.pid");
        String pid = (String)reference.getProperty("kura.service.pid");
        if (service instanceof ConfigurableComponent) {
            s_logger.info("Removed ConfigurableComponent with pid {} and service pid {}", (Object)pid, (Object)servicePid);
            this.m_confService.unregisterComponentConfiguration(pid);
        } else if (service instanceof SelfConfiguringComponent) {
            s_logger.info("Removed SelfConfiguringComponent with pid {} and service pid {}", (Object)pid, (Object)servicePid);
            this.m_confService.unregisterComponentConfiguration(servicePid);
        }
    }
}

