/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class NativeLongArray {
    private ByteBuffer memory;
    private long memoryAddress;
    private int capacity;
    private int size;

    NativeLongArray(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity must be >= 1 but was " + capacity);
        }
        this.memory = Buffer.allocateDirectWithNativeOrder((int)NativeLongArray.calculateBufferCapacity(capacity));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
        this.capacity = capacity;
    }

    private static int idx(int index) {
        return index * Limits.SIZEOF_JLONG;
    }

    private static int calculateBufferCapacity(int capacity) {
        return capacity * Limits.SIZEOF_JLONG;
    }

    void add(long value) {
        this.reallocIfNeeded();
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent.putLong((long)this.memoryOffset(this.size), (long)value);
        } else {
            this.memory.putLong(NativeLongArray.idx(this.size), value);
        }
        ++this.size;
    }

    void clear() {
        this.size = 0;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void free() {
        Buffer.free((ByteBuffer)this.memory);
        this.memoryAddress = 0L;
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    long memoryAddressEnd() {
        return this.memoryOffset(this.size);
    }

    private long memoryOffset(int index) {
        return this.memoryAddress + (long)NativeLongArray.idx(index);
    }

    private void reallocIfNeeded() {
        if (this.size == this.capacity) {
            int newLength = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
            ByteBuffer buffer = Buffer.allocateDirectWithNativeOrder((int)NativeLongArray.calculateBufferCapacity(newLength));
            this.memory.position(0).limit(this.size);
            buffer.put(this.memory);
            buffer.position(0);
            Buffer.free((ByteBuffer)this.memory);
            this.memory = buffer;
            this.memoryAddress = Buffer.memoryAddress((ByteBuffer)buffer);
            this.capacity = newLength;
        }
    }

    public String toString() {
        return "memoryAddress: " + this.memoryAddress + " capacity: " + this.capacity + " size: " + this.size;
    }
}

