/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.transport.mqtt;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraNotConnectedException;
import org.eclipse.kura.KuraTimeoutException;
import org.eclipse.kura.KuraTooManyInflightMessagesException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.data.transport.mqtt.DataTransportListenerS;
import org.eclipse.kura.core.data.transport.mqtt.MqttClientConfiguration;
import org.eclipse.kura.core.util.ValidationUtil;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.data.DataTransportService;
import org.eclipse.kura.data.DataTransportToken;
import org.eclipse.kura.data.transport.listener.DataTransportListener;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.ssl.SslServiceListener;
import org.eclipse.kura.status.CloudConnectionStatusComponent;
import org.eclipse.kura.status.CloudConnectionStatusEnum;
import org.eclipse.kura.status.CloudConnectionStatusService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttDataTransport
implements DataTransportService,
MqttCallback,
ConfigurableComponent,
SslServiceListener,
CloudConnectionStatusComponent {
    private static final String NOT_CONNECTED_MESSAGE = "Not connected";
    private static final String ALREADY_CONNECTED_MESSAGE = "Already connected";
    private static final String INVALID_CONFIGURATION_MESSAGE = "Invalid configuration";
    private static final Logger logger = LoggerFactory.getLogger(MqttDataTransport.class);
    private static final String MQTT_SCHEME = "mqtt://";
    private static final String MQTTS_SCHEME = "mqtts://";
    private static final String TOPIC_PATTERN_STRING = "#([^\\s/]+)";
    private static final Pattern TOPIC_PATTERN = Pattern.compile("#([^\\s/]+)");
    private static final String MQTT_BROKER_URL_PROP_NAME = "broker-url";
    private static final String MQTT_USERNAME_PROP_NAME = "username";
    private static final String MQTT_PASSWORD_PROP_NAME = "password";
    private static final String MQTT_CLIENT_ID_PROP_NAME = "client-id";
    private static final String MQTT_KEEP_ALIVE_PROP_NAME = "keep-alive";
    private static final String MQTT_CLEAN_SESSION_PROP_NAME = "clean-session";
    private static final String MQTT_TIMEOUT_PROP_NAME = "timeout";
    private static final String MQTT_DEFAULT_VERSION_PROP_NAME = "protocol-version";
    private static final String MQTT_LWT_QOS_PROP_NAME = "lwt.qos";
    private static final String MQTT_LWT_RETAIN_PROP_NAME = "lwt.retain";
    private static final String MQTT_LWT_TOPIC_PROP_NAME = "lwt.topic";
    private static final String MQTT_LWT_PAYLOAD_PROP_NAME = "lwt.payload";
    private static final String CLOUD_ACCOUNT_NAME_PROP_NAME = "topic.context.account-name";
    private static final String PERSISTENCE_TYPE_PROP_NAME = "in-flight.persistence";
    private static final String TOPIC_ACCOUNT_NAME_CTX_NAME = "account-name";
    private static final String TOPIC_DEVICE_ID_CTX_NAME = "client-id";
    private SystemService systemService;
    private SslManagerService sslManagerService;
    private CloudConnectionStatusService cloudConnectionStatusService;
    private CloudConnectionStatusEnum notificationStatus = CloudConnectionStatusEnum.OFF;
    private MqttAsyncClient mqttClient;
    private DataTransportListenerS dataTransportListeners;
    private MqttClientConfiguration clientConf;
    private boolean newSession;
    private String sessionId;
    private MqttClientConfiguration.PersistenceType persistenceType;
    private MqttClientPersistence persistence;
    private final Map<String, String> topicContext = new HashMap<String, String>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private CryptoService cryptoService;
    private final Object updateLock = new Object();

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSslManagerService(SslManagerService sslManagerService) {
        boolean update;
        Object object = this.updateLock;
        synchronized (object) {
            this.sslManagerService = sslManagerService;
            update = this.clientConf != null;
        }
        if (update) {
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetSslManagerService(SslManagerService sslManagerService) {
        Object object = this.updateLock;
        synchronized (object) {
            if (sslManagerService == this.sslManagerService) {
                this.sslManagerService = null;
            }
        }
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.cryptoService = null;
    }

    public void setCloudConnectionStatusService(CloudConnectionStatusService cloudConnectionStatusService) {
        this.cloudConnectionStatusService = cloudConnectionStatusService;
    }

    public void unsetCloudConnectionStatusService(CloudConnectionStatusService cloudConnectionStatusService) {
        this.cloudConnectionStatusService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        Object object = this.updateLock;
        synchronized (object) {
            logger.info("Activating {}...", properties.get("kura.service.pid"));
            HashMap<String, Object> decryptedPropertiesMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals(MQTT_PASSWORD_PROP_NAME)) {
                    try {
                        Password decryptedPassword = new Password(this.cryptoService.decryptAes(((String)value).toCharArray()));
                        decryptedPropertiesMap.put(key, decryptedPassword);
                    }
                    catch (Exception exception) {
                        logger.info("Password is not encrypted");
                        decryptedPropertiesMap.put(key, new Password((String)value));
                    }
                    continue;
                }
                decryptedPropertiesMap.put(key, value);
            }
            this.properties.putAll(decryptedPropertiesMap);
            try {
                this.clientConf = this.buildConfiguration(this.properties);
            }
            catch (RuntimeException e) {
                logger.error("Invalid client configuration. Service will not be able to connect until the configuration is updated", (Throwable)e);
            }
            this.dataTransportListeners = new DataTransportListenerS(componentContext);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating {}...", this.properties.get("kura.service.pid"));
        if (this.isConnected()) {
            this.disconnect(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Map<String, Object> properties) {
        Object object = this.updateLock;
        synchronized (object) {
            logger.info("Updating {}...", properties.get("kura.service.pid"));
            this.properties.clear();
            HashMap<String, Object> decryptedPropertiesMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals(MQTT_PASSWORD_PROP_NAME)) {
                    try {
                        Password decryptedPassword = new Password(this.cryptoService.decryptAes(((String)value).toCharArray()));
                        decryptedPropertiesMap.put(key, decryptedPassword);
                    }
                    catch (Exception exception) {
                        logger.info("Password is not encrypted");
                        decryptedPropertiesMap.put(key, new Password((String)value));
                    }
                    continue;
                }
                decryptedPropertiesMap.put(key, value);
            }
            this.properties.putAll(decryptedPropertiesMap);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        boolean wasConnected = this.isConnected();
        this.dataTransportListeners.onConfigurationUpdating(wasConnected);
        logger.info("Building new configuration...");
        Object object = this.updateLock;
        synchronized (object) {
            this.clientConf = this.buildConfiguration(this.properties);
        }
        this.dataTransportListeners.onConfigurationUpdated(wasConnected);
    }

    public synchronized void connect() throws KuraConnectException {
        if (this.isConnected()) {
            logger.error(ALREADY_CONNECTED_MESSAGE);
            throw new IllegalStateException(ALREADY_CONNECTED_MESSAGE);
        }
        try {
            this.setupMqttSession();
        }
        catch (RuntimeException e) {
            throw new KuraConnectException((Throwable)e, (Object)"Unexpected exception setting up MQTT session");
        }
        if (this.mqttClient == null) {
            logger.error(INVALID_CONFIGURATION_MESSAGE);
            throw new IllegalStateException(INVALID_CONFIGURATION_MESSAGE);
        }
        logger.info("# ------------------------------------------------------------");
        logger.info("#  Connection Properties");
        logger.info("#  broker    = {}", (Object)this.clientConf.getBrokerUrl());
        logger.info("#  clientId  = {}", (Object)this.clientConf.getClientId());
        logger.info("#  username  = {}", (Object)this.clientConf.getConnectOptions().getUserName());
        logger.info("#  password  = XXXXXXXXXXXXXX");
        logger.info("#  keepAlive = {}", (Object)this.clientConf.getConnectOptions().getKeepAliveInterval());
        logger.info("#  timeout   = {}", (Object)this.clientConf.getConnectOptions().getConnectionTimeout());
        logger.info("#  cleanSession    = {}", (Object)this.clientConf.getConnectOptions().isCleanSession());
        logger.info("#  MQTT version    = {}", (Object)MqttDataTransport.getMqttVersionLabel(this.clientConf.getConnectOptions().getMqttVersion()));
        logger.info("#  willDestination = {}", (Object)this.clientConf.getConnectOptions().getWillDestination());
        logger.info("#  willMessage     = {}", (Object)this.clientConf.getConnectOptions().getWillMessage());
        logger.info("#");
        logger.info("#  Connecting...");
        this.cloudConnectionStatusService.register((CloudConnectionStatusComponent)this);
        this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.FAST_BLINKING);
        try {
            try {
                IMqttToken connectToken = this.mqttClient.connect(this.clientConf.getConnectOptions());
                connectToken.waitForCompletion(this.getTimeToWaitMillis() * 3L);
                logger.info("#  Connected!");
                logger.info("# ------------------------------------------------------------");
                this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.ON);
            }
            catch (MqttException e) {
                logger.warn("xxxxx  Connect failed. Forcing disconnect. xxxxx");
                this.closeMqttClient();
                this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.OFF);
                throw new KuraConnectException((Throwable)e, (Object)"Cannot connect");
            }
        }
        finally {
            this.cloudConnectionStatusService.unregister((CloudConnectionStatusComponent)this);
        }
        this.dataTransportListeners.onConnectionEstablished(this.newSession);
    }

    public boolean isConnected() {
        if (this.mqttClient != null) {
            return this.mqttClient.isConnected();
        }
        return false;
    }

    public String getBrokerUrl() {
        String brokerUrl;
        if (this.clientConf != null && (brokerUrl = this.clientConf.getBrokerUrl()) != null) {
            return brokerUrl;
        }
        return "";
    }

    public String getAccountName() {
        String accountName;
        if (this.clientConf != null && (accountName = this.topicContext.get(TOPIC_ACCOUNT_NAME_CTX_NAME)) != null) {
            return accountName;
        }
        return "";
    }

    public String getUsername() {
        String username;
        if (this.clientConf != null && (username = this.clientConf.getConnectOptions().getUserName()) != null) {
            return username;
        }
        return "";
    }

    public String getClientId() {
        String clientId;
        if (this.clientConf != null && (clientId = this.clientConf.getClientId()) != null) {
            return clientId;
        }
        return "";
    }

    public synchronized void disconnect(long quiesceTimeout) {
        if (this.isConnected()) {
            logger.info("Disconnecting...");
            this.dataTransportListeners.onDisconnecting();
            try {
                this.mqttClient.disconnect(quiesceTimeout).waitForCompletion(this.getTimeToWaitMillis());
                logger.info("Disconnected");
            }
            catch (MqttException e) {
                logger.error("Disconnect failed", (Throwable)e);
            }
            this.dataTransportListeners.onDisconnected();
        } else {
            logger.warn("MQTT client already disconnected");
        }
    }

    public void subscribe(String topic, int qos) throws KuraException {
        if (this.mqttClient == null || !this.mqttClient.isConnected()) {
            throw new KuraNotConnectedException((Object)NOT_CONNECTED_MESSAGE);
        }
        topic = this.replaceTopicVariables(topic);
        logger.info("Subscribing to topic: {} with QoS: {}", (Object)topic, (Object)qos);
        try {
            IMqttToken token = this.mqttClient.subscribe(topic, qos);
            token.waitForCompletion(this.getTimeToWaitMillis());
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32000) {
                logger.warn("Timeout subscribing to topic: {}", (Object)topic);
                throw new KuraTimeoutException("Timeout subscribing to topic: " + topic, (Throwable)e);
            }
            logger.error("Cannot subscribe to topic: " + topic, (Throwable)e);
            throw KuraException.internalError((Throwable)e, (String)("Cannot subscribe to topic: " + topic));
        }
    }

    public void unsubscribe(String topic) throws KuraException {
        if (this.mqttClient == null || !this.mqttClient.isConnected()) {
            throw new KuraNotConnectedException((Object)NOT_CONNECTED_MESSAGE);
        }
        topic = this.replaceTopicVariables(topic);
        logger.info("Unsubscribing to topic: {}", (Object)topic);
        try {
            IMqttToken token = this.mqttClient.unsubscribe(topic);
            token.waitForCompletion(this.getTimeToWaitMillis());
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32000) {
                logger.warn("Timeout unsubscribing to topic: {}", (Object)topic);
                throw new KuraTimeoutException("Timeout unsubscribing to topic: " + topic, (Throwable)e);
            }
            logger.error("Cannot unsubscribe to topic: " + topic, (Throwable)e);
            throw KuraException.internalError((Throwable)e, (String)("Cannot unsubscribe to topic: " + topic));
        }
    }

    public DataTransportToken publish(String topic, byte[] payload, int qos, boolean retain) throws KuraException {
        IMqttDeliveryToken token;
        if (this.mqttClient == null || !this.mqttClient.isConnected()) {
            throw new KuraNotConnectedException((Object)NOT_CONNECTED_MESSAGE);
        }
        topic = this.replaceTopicVariables(topic);
        logger.info("Publishing message on topic: {} with QoS: {}", (Object)topic, (Object)qos);
        MqttMessage message = new MqttMessage();
        message.setPayload(payload);
        message.setQos(qos);
        message.setRetained(retain);
        Integer messageId = null;
        try {
            token = this.mqttClient.publish(topic, message);
            logger.debug("Published message with ID: {}", (Object)token.getMessageId());
            if (qos > 0) {
                messageId = token.getMessageId();
            }
        }
        catch (MqttPersistenceException e) {
            logger.error("Cannot publish on topic: {}", (Object)topic, (Object)e);
            throw new IllegalStateException("Cannot publish on topic: " + topic);
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32202) {
                logger.info("Too many inflight messages");
                throw new KuraTooManyInflightMessagesException((Throwable)e, (Object)"Too many in-fligh messages");
            }
            logger.error("Cannot publish on topic: " + topic, (Throwable)e);
            throw KuraException.internalError((Throwable)e, (String)("Cannot publish on topic: " + topic));
        }
        token = null;
        if (messageId != null) {
            token = new DataTransportToken(messageId.intValue(), this.sessionId);
        }
        return token;
    }

    public void addDataTransportListener(DataTransportListener listener) {
        this.dataTransportListeners.add(listener);
    }

    public void removeDataTransportListener(DataTransportListener listener) {
        this.dataTransportListeners.remove(listener);
    }

    public void connectionLost(Throwable cause) {
        logger.warn("Connection Lost", cause);
        this.dataTransportListeners.onConnectionLost(cause);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        int qos;
        if (token == null) {
            logger.error("null token");
            return;
        }
        MqttMessage msg = null;
        try {
            msg = token.getMessage();
        }
        catch (MqttException e) {
            logger.error("Cannot get message", (Throwable)e);
            return;
        }
        if (msg != null && (qos = msg.getQos()) == 0) {
            logger.debug("Ignoring deliveryComplete for messages published with QoS == 0");
            return;
        }
        int id = token.getMessageId();
        logger.debug("Delivery complete for message with ID: {}", (Object)id);
        DataTransportToken dataPublisherToken = new DataTransportToken(id, this.sessionId);
        this.dataTransportListeners.onMessageConfirmed(dataPublisherToken);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        logger.debug("Message arrived on topic: {}", (Object)topic);
        this.dataTransportListeners.onMessageArrived(topic, message.getPayload(), message.getQos(), message.isRetained());
    }

    private long getTimeToWaitMillis() {
        return (long)this.clientConf.getConnectOptions().getConnectionTimeout() * 1000L;
    }

    public void onConfigurationUpdated() {
        this.update();
    }

    public int getNotificationPriority() {
        return 200;
    }

    public CloudConnectionStatusEnum getNotificationStatus() {
        return this.notificationStatus;
    }

    public void setNotificationStatus(CloudConnectionStatusEnum status) {
        this.notificationStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MqttClientConfiguration buildConfiguration(Map<String, Object> properties) {
        MqttConnectOptions conOpt = new MqttConnectOptions();
        String clientId = null;
        String brokerUrl = null;
        try {
            Password password;
            clientId = (String)properties.get("client-id");
            if (clientId == null || clientId.trim().length() == 0) {
                clientId = this.systemService.getPrimaryMacAddress();
            }
            ValidationUtil.notEmptyOrNull(clientId, "clientId");
            clientId = clientId.replace('/', '-');
            clientId = clientId.replace('+', '-');
            clientId = clientId.replace('#', '-');
            clientId = clientId.replace('.', '-');
            brokerUrl = (String)properties.get(MQTT_BROKER_URL_PROP_NAME);
            ValidationUtil.notEmptyOrNull(brokerUrl, MQTT_BROKER_URL_PROP_NAME);
            brokerUrl = brokerUrl.trim();
            brokerUrl = brokerUrl.replaceAll("^mqtt://", "tcp://");
            brokerUrl = brokerUrl.replaceAll("^mqtts://", "ssl://");
            brokerUrl = brokerUrl.replaceAll("/$", "");
            ValidationUtil.notEmptyOrNull(brokerUrl, "brokerUrl");
            ValidationUtil.notNegative((Integer)properties.get(MQTT_KEEP_ALIVE_PROP_NAME), MQTT_KEEP_ALIVE_PROP_NAME);
            ValidationUtil.notNegative((Integer)properties.get(MQTT_TIMEOUT_PROP_NAME), MQTT_TIMEOUT_PROP_NAME);
            ValidationUtil.notNull(properties.get(MQTT_CLEAN_SESSION_PROP_NAME), MQTT_CLEAN_SESSION_PROP_NAME);
            String userName = (String)properties.get(MQTT_USERNAME_PROP_NAME);
            if (userName != null && !userName.isEmpty()) {
                conOpt.setUserName(userName);
            }
            if ((password = (Password)properties.get(MQTT_PASSWORD_PROP_NAME)) != null && password.toString().length() != 0) {
                conOpt.setPassword(password.getPassword());
            }
            conOpt.setKeepAliveInterval(((Integer)properties.get(MQTT_KEEP_ALIVE_PROP_NAME)).intValue());
            conOpt.setConnectionTimeout(((Integer)properties.get(MQTT_TIMEOUT_PROP_NAME)).intValue());
            conOpt.setCleanSession(((Boolean)properties.get(MQTT_CLEAN_SESSION_PROP_NAME)).booleanValue());
            conOpt.setMqttVersion(((Integer)properties.get(MQTT_DEFAULT_VERSION_PROP_NAME)).intValue());
            conOpt.setAutomaticReconnect(false);
            Map<String, String> map = this.topicContext;
            synchronized (map) {
                this.topicContext.clear();
                if (properties.get(CLOUD_ACCOUNT_NAME_PROP_NAME) != null) {
                    this.topicContext.put(TOPIC_ACCOUNT_NAME_CTX_NAME, (String)properties.get(CLOUD_ACCOUNT_NAME_PROP_NAME));
                }
                this.topicContext.put("client-id", clientId);
            }
            String willTopic = (String)properties.get(MQTT_LWT_TOPIC_PROP_NAME);
            if (willTopic != null && !willTopic.isEmpty()) {
                int willQos = 0;
                boolean willRetain = false;
                String willPayload = (String)properties.get(MQTT_LWT_PAYLOAD_PROP_NAME);
                if (properties.get(MQTT_LWT_QOS_PROP_NAME) != null) {
                    willQos = (Integer)properties.get(MQTT_LWT_QOS_PROP_NAME);
                }
                if (properties.get(MQTT_LWT_RETAIN_PROP_NAME) != null) {
                    willRetain = (Boolean)properties.get(MQTT_LWT_RETAIN_PROP_NAME);
                }
                willTopic = this.replaceTopicVariables(willTopic);
                byte[] payload = new byte[]{};
                if (willPayload != null && !willPayload.isEmpty()) {
                    payload = willPayload.getBytes(StandardCharsets.UTF_8);
                }
                conOpt.setWill(willTopic, payload, willQos, willRetain);
            }
        }
        catch (KuraException e) {
            logger.error(INVALID_CONFIGURATION_MESSAGE);
            throw new IllegalStateException("Invalid MQTT client configuration", e);
        }
        if (brokerUrl.startsWith("ssl") || brokerUrl.startsWith("wss")) {
            try {
                SSLSocketFactory ssf = this.sslManagerService.getSSLSocketFactory();
                conOpt.setSocketFactory((SocketFactory)ssf);
            }
            catch (Exception e) {
                logger.error("SSL setup failed", (Throwable)e);
                throw new IllegalStateException("SSL setup failed");
            }
        }
        String sType = (String)properties.get(PERSISTENCE_TYPE_PROP_NAME);
        MqttClientConfiguration.PersistenceType localPersistenceType = null;
        if ("file".equals(sType)) {
            localPersistenceType = MqttClientConfiguration.PersistenceType.FILE;
        } else if ("memory".equals(sType)) {
            localPersistenceType = MqttClientConfiguration.PersistenceType.MEMORY;
        } else {
            throw new IllegalStateException("Invalid MQTT client configuration: persistenceType: " + (Object)((Object)localPersistenceType));
        }
        MqttClientConfiguration clientConfiguration = new MqttClientConfiguration(brokerUrl, clientId, localPersistenceType, conOpt);
        return clientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceTopicVariables(String topic) {
        boolean found;
        Matcher topicMatcher = TOPIC_PATTERN.matcher(topic);
        StringBuffer sb = new StringBuffer();
        do {
            if (!(found = topicMatcher.find())) continue;
            String replacement = topicMatcher.group(0);
            String variableName = topicMatcher.group(1);
            Map<String, String> map = this.topicContext;
            synchronized (map) {
                String value = this.topicContext.get(variableName);
                if (value != null) {
                    replacement = value;
                }
            }
            topicMatcher.appendReplacement(sb, replacement);
        } while (found);
        topicMatcher.appendTail(sb);
        String replacedTopic = sb.toString();
        logger.debug("Replaced tokens in topic {} with: {}", (Object)topic, (Object)replacedTopic);
        return replacedTopic;
    }

    private String generateSessionId() {
        return String.valueOf(this.clientConf.getClientId()) + "-" + this.clientConf.getBrokerUrl();
    }

    private void setupMqttSession() {
        if (this.clientConf == null) {
            throw new IllegalStateException("Invalid client configuration");
        }
        if (this.mqttClient != null) {
            String brokerUrl = this.mqttClient.getServerURI();
            String clientId = this.mqttClient.getClientId();
            if (!brokerUrl.equals(this.clientConf.getBrokerUrl()) || !clientId.equals(this.clientConf.getClientId()) || this.persistenceType != this.clientConf.getPersistenceType()) {
                this.closeMqttClient();
            }
        }
        boolean newSessionTemp = this.clientConf.getConnectOptions().isCleanSession();
        if (this.mqttClient == null) {
            IMqttDeliveryToken[] pendingDeliveryTokens;
            logger.info("Creating a new client instance");
            MqttClientConfiguration.PersistenceType newPersistenceType = this.clientConf.getPersistenceType();
            if (newPersistenceType == MqttClientConfiguration.PersistenceType.MEMORY) {
                logger.info("Using memory persistence for in-flight messages");
                this.persistence = new MemoryPersistence();
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(this.systemService.getKuraDataDirectory()).append(this.systemService.getFileSeparator()).append("paho-persistence");
                String dir = sb.toString();
                logger.info("Using file persistence for in-flight messages: {}", (Object)dir);
                if (this.persistence != null) {
                    try {
                        this.persistence.close();
                    }
                    catch (MqttPersistenceException e) {
                        logger.warn("Failed to close persistence. Ignoring exception.", (Throwable)e);
                    }
                }
                this.persistence = new MqttDefaultFilePersistence(dir);
            }
            try {
                MqttAsyncClient newMqttClient = new MqttAsyncClient(this.clientConf.getBrokerUrl(), this.clientConf.getClientId(), this.persistence);
                newMqttClient.setCallback((MqttCallback)this);
                this.mqttClient = newMqttClient;
            }
            catch (MqttException e) {
                logger.error("Client instantiation failed", (Throwable)e);
                throw new IllegalStateException("Client instantiation failed");
            }
            this.persistenceType = newPersistenceType;
            if (!this.clientConf.getConnectOptions().isCleanSession() && (pendingDeliveryTokens = this.mqttClient.getPendingDeliveryTokens()) != null && pendingDeliveryTokens.length != 0) {
                newSessionTemp = false;
            }
        }
        this.newSession = newSessionTemp;
        this.sessionId = this.generateSessionId();
    }

    private void closeMqttClient() {
        try {
            logger.info("Forcing client disconnect...");
            this.mqttClient.disconnectForcibly();
        }
        catch (MqttException e) {
            logger.warn("Cannot force client disconnect", (Throwable)e);
        }
        try {
            try {
                logger.info("Closing client...");
                this.mqttClient.setCallback(null);
                this.mqttClient.close();
                logger.info("Closed");
            }
            catch (MqttException e) {
                logger.warn("Cannot close client", (Throwable)e);
                this.mqttClient = null;
            }
        }
        finally {
            this.mqttClient = null;
        }
    }

    private static String getMqttVersionLabel(int mqttVersion) {
        switch (mqttVersion) {
            case 3: {
                return "3.1";
            }
            case 4: {
                return "3.1.1";
            }
        }
        return String.valueOf(mqttVersion);
    }
}

